/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndi.http;

import java.security.Provider;
import java.security.Security;
import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.http.HttpClient;
import org.exolab.core.util.URI;
import org.exolab.jms.jndi.http.HttpJndiInitialContextFactory;

public class SslHttpJndiInitialContextFactory
extends HttpJndiInitialContextFactory {
    private boolean _sslInitialized = false;
    private static final String HTTPS_SCHEME = "https";
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$jndi$http$SslHttpJndiInitialContextFactory == null ? (class$org$exolab$jms$jndi$http$SslHttpJndiInitialContextFactory = SslHttpJndiInitialContextFactory.class$("org.exolab.jms.jndi.http.SslHttpJndiInitialContextFactory")) : class$org$exolab$jms$jndi$http$SslHttpJndiInitialContextFactory));
    static /* synthetic */ Class class$org$exolab$jms$jndi$http$SslHttpJndiInitialContextFactory;

    protected String getProviderURL(Hashtable environment) throws NamingException {
        if (environment == null) {
            throw new ConfigurationException("Cannot connect to JNDI provider - environment not set");
        }
        String url = (String)environment.get("java.naming.provider.url");
        if (url != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URI.MalformedURIException exception) {
                throw new ConfigurationException("Malformed JNDI provider URL: " + url);
            }
            if (!HTTPS_SCHEME.equals(uri.getScheme())) {
                throw new ConfigurationException("URL=" + url + " has an invalid scheme");
            }
            String path = uri.getPath();
            if (path == null || path.length() == 0) {
                url = url + "/openjms/OpenJMSJndi";
            } else if (path.equals("/")) {
                url = url + "openjms/OpenJMSJndi";
            }
        } else {
            url = this.getDeprecatedEnvironment(environment);
        }
        return url;
    }

    protected HttpClient openConnection(String url) throws NamingException {
        HttpClient client;
        this.initSSL();
        try {
            client = new HttpClient(url, "SslHttpJndiInitialContextFactory");
        }
        catch (Exception exception) {
            NamingException error = new NamingException("Failed to connect to JNDI provider");
            error.setRootCause(exception);
            throw error;
        }
        return client;
    }

    private synchronized void initSSL() throws NamingException {
        if (!this._sslInitialized) {
            try {
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Class<?> providerClass = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
                Provider provider = (Provider)providerClass.newInstance();
                Security.addProvider(provider);
                this._sslInitialized = true;
            }
            catch (Exception exception) {
                ConfigurationException error = new ConfigurationException("Failed to initialise SSL");
                error.setRootCause(exception);
                throw error;
            }
        }
    }

    private String getDeprecatedEnvironment(Hashtable environment) {
        _log.warn((Object)(this.getClass().getName() + ": using deprecated environment. Use Context.PROVIDER_URL"));
        StringBuffer url = new StringBuffer(HTTPS_SCHEME);
        String host = (String)environment.get("org.exolab.jms.jndi.host");
        Integer port = (Integer)environment.get("org.exolab.jms.jndi.port");
        if (host != null) {
            url.append(host);
        } else {
            url.append("localhost");
        }
        if (port != null) {
            url.append(":");
            url.append(port.toString());
        }
        url.append("/");
        url.append("openjms/OpenJMSJndi");
        return url.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

