/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndi.mipc;

import java.io.Serializable;
import java.util.Vector;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.apache.avalon.excalibur.naming.NamingProvider;
import org.exolab.core.ipc.Client;

public class NameServiceProxy
implements NamingProvider {
    private Client _connection;

    public NameServiceProxy(Client connection) {
        this._connection = connection;
    }

    public NameParser getNameParser() throws NamingException {
        NameParser parser;
        Vector request = this.pack("getNameParser", 0);
        Client client = this._connection;
        synchronized (client) {
            this.send(request);
            parser = (NameParser)this.checkReply("getNameParser");
        }
        return parser;
    }

    public void bind(Name name, String className, Object object) throws NamingException {
        Vector request = this.pack("bind", 3);
        request.add(name);
        request.add(className);
        request.add(object);
        Client client = this._connection;
        synchronized (client) {
            this.send(request);
            this.checkReply("bind");
        }
    }

    public void rebind(Name name, String className, Object object) throws NamingException {
        Vector request = this.pack("rebind", 3);
        request.add(name);
        request.add(className);
        request.add(object);
        Client client = this._connection;
        synchronized (client) {
            this.send(request);
            this.checkReply("rebind");
        }
    }

    public Context createSubcontext(Name name) throws NamingException {
        Context subcontext;
        Vector request = this.pack("createSubContext", 1);
        request.add(name);
        Client client = this._connection;
        synchronized (client) {
            this.send(request);
            subcontext = (Context)this.checkReply("createSubContext");
        }
        return subcontext;
    }

    public void destroySubcontext(Name name) throws NamingException {
        Vector request = this.pack("destroySubContext", 1);
        request.add(name);
        Client client = this._connection;
        synchronized (client) {
            this.send(request);
            this.checkReply("destroySubContext");
        }
    }

    public NameClassPair[] list(Name name) throws NamingException {
        NameClassPair[] pairs;
        Vector request = this.pack("list", 1);
        request.add(name);
        Client client = this._connection;
        synchronized (client) {
            this.send(request);
            pairs = (NameClassPair[])this.checkReply("list");
        }
        return pairs;
    }

    public Binding[] listBindings(Name name) throws NamingException {
        Binding[] bindings;
        Vector request = this.pack("listBindings", 1);
        request.add(name);
        Client client = this._connection;
        synchronized (client) {
            this.send(request);
            bindings = (Binding[])this.checkReply("listBindings");
        }
        return bindings;
    }

    public Object lookup(Name name) throws NamingException {
        Object object;
        Vector request = this.pack("lookup", 1);
        request.add(name);
        Client client = this._connection;
        synchronized (client) {
            this.send(request);
            object = this.checkReply("lookup");
        }
        return object;
    }

    public void unbind(Name name) throws NamingException {
        Vector request = this.pack("unbind", 1);
        request.add(name);
        Client client = this._connection;
        synchronized (client) {
            this.send(request);
            this.checkReply("unbind");
        }
    }

    protected Vector pack(String method, int numParams) {
        Vector<String> request = new Vector<String>(3 + numParams);
        request.add(this.getClassName());
        request.add(method);
        request.add("fooey");
        return request;
    }

    protected String getClassName() {
        return "org.exolab.jms.jndi.mipc.IpcJmsJndiServer";
    }

    protected Object checkReply(String method) throws NamingException {
        Object result = null;
        try {
            Vector v = (Vector)this._connection.receive();
            if (v != null) {
                Boolean b = (Boolean)v.get(0);
                if (!b.booleanValue()) {
                    NamingException error = (NamingException)v.get(1);
                    throw error;
                }
            } else {
                throw new NamingException("Unknown connection error for " + method);
            }
            result = v.get(1);
        }
        catch (NamingException error) {
            throw error;
        }
        catch (Exception error) {
            throw new NamingException("Operation " + method + " failed: " + error);
        }
        return result;
    }

    protected void send(Vector v) throws NamingException {
        try {
            this._connection.send((Serializable)v);
        }
        catch (Exception error) {
            throw new NamingException("Operation failed: " + error);
        }
    }
}

