/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.message;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jms.DeliveryMode;
import javax.jms.JMSException;

public class DeliveryModeImpl
implements DeliveryMode,
Externalizable {
    static final long serialVersionUID = 1L;
    private int mode_ = 1;

    public DeliveryModeImpl() {
    }

    public DeliveryModeImpl(int mode) throws JMSException {
        if (!this.validMode(mode)) {
            throw new JMSException("Invalid Mode");
        }
        this.mode_ = mode;
    }

    private boolean validMode(int mode) {
        return mode >= 1 && mode <= 2;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(1L);
        out.writeInt(this.mode_);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        long version = in.readLong();
        if (version != 1L) {
            throw new IOException("Incorrect version enountered: " + version + " This version = " + 1L);
        }
        this.mode_ = in.readInt();
    }

    public void setDeliveryMode(int mode) throws JMSException {
        if (!this.validMode(mode)) {
            throw new JMSException("Invalid Mode");
        }
        this.mode_ = mode;
    }

    public int getDeliveryMode() {
        return this.mode_;
    }

    public boolean isPersistent() {
        return this.mode_ == 2;
    }
}

