/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.ConnectionFactories;
import org.exolab.jms.config.Connector;
import org.exolab.jms.config.ConnectorHelper;
import org.exolab.jms.config.ConnectorResource;
import org.exolab.jms.config.HttpConfiguration;
import org.exolab.jms.config.HttpConfigurationType;
import org.exolab.jms.config.ServerConfiguration;
import org.exolab.jms.config.TcpConfiguration;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.server.ConnectionFactoryHelper;
import org.exolab.jms.server.JmsServerIfc;
import org.exolab.jms.server.ServerException;

public class HttpJmsServer
implements JmsServerIfc {
    public void init() throws ServerException {
        HttpConfiguration config = ConfigurationManager.getConfig().getHttpConfiguration();
        if (config.getProxyHost() != null) {
            System.setProperty("http.proxyHost", config.getProxyHost());
        }
        if (config.hasProxyPort()) {
            System.setProperty("http.proxyPort", Integer.toString(config.getProxyPort()));
        }
    }

    public void bindConnectionFactories(Context context) throws NamingException, ServerException {
        Class<?> proxy;
        Configuration config = ConfigurationManager.getConfig();
        ServerConfiguration server = config.getServerConfiguration();
        TcpConfiguration tcp = config.getTcpConfiguration();
        String host = this.normalizeHost(server.getHost());
        String internalHost = this.normalizeHost(tcp.getInternalHost());
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put(this.getHttpServerProperty(), this.getHttpServerURL());
        env.put("org.exolab.jms.mipc.server.host", host);
        env.put("org.exolab.jms.mipc.server.port", Integer.toString(tcp.getPort()));
        if (internalHost != null) {
            env.put("org.exolab.jms.mipc.server.internal.host", internalHost);
        }
        Connector connector = ConfigurationManager.getConnector(this.getScheme());
        ConnectorResource resource = ConnectorHelper.getConnectorResource(this.getScheme());
        String className = resource.getServer().getProxyClass();
        try {
            proxy = Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            throw new ServerException("Failed to locate the server proxy class: " + className);
        }
        ConnectionFactoryHelper.bind((Context)context, (ConnectionFactories)connector.getConnectionFactories(), proxy, env);
    }

    protected SchemeType getScheme() {
        return SchemeType.HTTP;
    }

    protected HttpConfigurationType getHttpConfiguration() {
        return ConfigurationManager.getConfig().getHttpConfiguration();
    }

    protected String getHttpServerProperty() {
        return "org.exolab.jms.http.server.url";
    }

    protected String getHttpServerURL() {
        HttpConfigurationType config = this.getHttpConfiguration();
        String host = config.getHost();
        int port = config.getPort();
        String url = this.getScheme() + "://" + host + ":" + port;
        String path = config.getServerServlet();
        url = !path.startsWith("/") ? url + "/" + path : url + path;
        return url;
    }

    protected String normalizeHost(String host) {
        String server = host;
        if (host == null) {
            return host;
        }
        if (host.equals("localhost")) {
            try {
                server = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return server;
    }
}

