/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.http;

import java.io.Serializable;
import java.util.Vector;
import javax.jms.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.http.HttpClient;
import org.exolab.jms.client.JmsMessageListener;
import org.exolab.jms.message.MessageImpl;
import org.exolab.jms.server.ClientDisconnectionException;
import org.exolab.jms.server.JmsServerSession;
import org.exolab.jms.server.http.HttpJmsSessionConnection;
import org.exolab.jms.server.http.HttpJmsSessionPinger;

public class HttpJmsSessionSender
implements JmsMessageListener {
    private HttpJmsSessionConnection _connection;
    private HttpClient _client;
    private JmsServerSession _session;
    private String _host;
    private String _port;
    private HttpJmsSessionPinger _pinger;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$server$http$HttpJmsSessionSender == null ? (class$org$exolab$jms$server$http$HttpJmsSessionSender = HttpJmsSessionSender.class$("org.exolab.jms.server.http.HttpJmsSessionSender")) : class$org$exolab$jms$server$http$HttpJmsSessionSender));
    static /* synthetic */ Class class$org$exolab$jms$server$http$HttpJmsSessionSender;

    public HttpJmsSessionSender(HttpJmsSessionConnection connection, HttpClient client, JmsServerSession session, String host, String port) {
        this._connection = connection;
        this._client = client;
        this._session = session;
        this._host = host;
        this._port = port;
        session.setMessageListener((JmsMessageListener)this);
        this._pinger = new HttpJmsSessionPinger(this);
        new Thread(this._pinger).start();
    }

    public void onMessage(Message message) {
        block5: {
            try {
                if (this._client == null) break block5;
                Vector<Object> v = new Vector<Object>(2);
                v.add(this._session.getSessionId());
                v.add((MessageImpl)message);
                this._pinger.reset();
                HttpClient httpClient = this._client;
                synchronized (httpClient) {
                    this._client.send(v, this._host, this._port);
                    Vector reply = (Vector)this._client.receive();
                }
            }
            catch (Exception err) {
                _log.debug((Object)"Failed to send message to client", (Throwable)err);
                throw new ClientDisconnectionException(err.getMessage());
            }
        }
    }

    public void onMessages(Vector messages) {
        block5: {
            try {
                if (this._client == null) break block5;
                Vector<Object> v = new Vector<Object>(2);
                v.add(this._session.getSessionId());
                v.add(messages);
                this._pinger.reset();
                HttpClient httpClient = this._client;
                synchronized (httpClient) {
                    this._client.send(v, this._host, this._port);
                    Vector reply = (Vector)this._client.receive();
                }
            }
            catch (Exception err) {
                _log.debug((Object)"Failed to send messages to client", (Throwable)err);
                throw new ClientDisconnectionException(err.getMessage());
            }
        }
    }

    public void onMessageAvailable(long clientId) {
        try {
            if (this._client != null) {
                Vector<Object> v = new Vector<Object>(2);
                v.add(this._session.getSessionId());
                v.add(new Long(clientId));
                this._pinger.reset();
                this._client.send(v, this._host, this._port);
                Vector reply = (Vector)this._client.receive();
            }
        }
        catch (Exception err) {
            _log.debug((Object)"Failed to notify client", (Throwable)err);
            throw new ClientDisconnectionException(err.getMessage());
        }
    }

    protected void ping() {
        block5: {
            try {
                if (this._client == null) break block5;
                Vector<String> v = new Vector<String>(1);
                v.add(this._session.getSessionId());
                HttpClient httpClient = this._client;
                synchronized (httpClient) {
                    this._client.send(v, this._host, this._port);
                    Vector vector = (Vector)this._client.receive();
                }
            }
            catch (Exception err) {
                _log.debug((Object)"Failed to ping client", (Throwable)err);
                throw new ClientDisconnectionException(err.getMessage());
            }
        }
    }

    public void close() {
        HttpClient client = this._client;
        if (client != null) {
            HttpClient httpClient = client;
            synchronized (httpClient) {
                try {
                    client.send((Serializable)((Object)"close"), this._host, this._port);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        JmsServerSession session = this._session;
        this._session = null;
        if (session != null) {
            session.setMessageListener(null);
            this._connection.disconnect(session);
            this._pinger.close();
            this._pinger = null;
        }
        this._host = null;
        this._port = null;
        this._client = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

