/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.server.http;

import java.security.Provider;
import java.security.Security;
import org.exolab.jms.config.ConfigurationManager;
import org.exolab.jms.config.HttpConfigurationType;
import org.exolab.jms.config.HttpsConfiguration;
import org.exolab.jms.config.types.SchemeType;
import org.exolab.jms.server.ServerException;
import org.exolab.jms.server.http.HttpJmsServer;

public class HttpsJmsServer
extends HttpJmsServer {
    public void init() throws ServerException {
        HttpsConfiguration config = ConfigurationManager.getConfig().getHttpsConfiguration();
        if (config.getProxyHost() != null) {
            System.setProperty("https.proxyHost", config.getProxyHost());
        }
        if (config.hasProxyPort()) {
            System.setProperty("https.proxyPort", Integer.toString(config.getProxyPort()));
        }
        System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
        try {
            Class<?> providerClass = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
            Provider provider = (Provider)providerClass.newInstance();
            Security.addProvider(provider);
        }
        catch (Exception exception) {
            throw new ServerException("Failed to initialise SSL support", (Throwable)exception);
        }
    }

    protected SchemeType getScheme() {
        return SchemeType.HTTPS;
    }

    protected HttpConfigurationType getHttpConfiguration() {
        return ConfigurationManager.getConfig().getHttpsConfiguration();
    }

    protected String getHttpServerProperty() {
        return "org.exolab.jms.http.server.url";
    }
}

