/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.BitSet;
import java.util.Vector;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;

class T4CTTIrxd
extends T4CTTIMsg {
    static final byte[] NO_BYTES = new byte[0];
    byte[] buffer;
    byte[] bufferCHAR;
    BitSet bvcColSent = null;
    int nbOfColumns = 0;
    boolean bvcFound = false;
    static final byte TTICMD_UNAUTHORIZED = 1;
    static int call_count = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    T4CTTIrxd(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)7);
    }

    void init() {
    }

    void setNumberOfColumns(int n2) {
        this.nbOfColumns = n2;
        this.bvcFound = false;
        if (this.bvcColSent == null || this.bvcColSent.length() < this.nbOfColumns) {
            this.bvcColSent = new BitSet(this.nbOfColumns);
        } else {
            this.bvcColSent.clear();
        }
    }

    void unmarshalBVC(int n2) throws SQLException, IOException {
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < this.bvcColSent.length(); ++n3) {
            this.bvcColSent.clear(n3);
        }
        n3 = this.nbOfColumns / 8 + (this.nbOfColumns % 8 != 0 ? 1 : 0);
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = (byte)(this.meg.unmarshalUB1() & 0xFF);
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((by & 1 << i3) != 0) {
                    this.bvcColSent.set(i2 * 8 + i3);
                    ++n4;
                    continue;
                }
                this.bvcColSent.clear(i2 * 8 + i3);
            }
        }
        if (n4 != n2) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.unmarshalBVC: bits missing in vector");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.bvcFound = true;
    }

    void readBitVector(byte[] byArray) throws SQLException, IOException {
        int n2;
        for (n2 = 0; n2 < this.bvcColSent.length(); ++n2) {
            this.bvcColSent.clear(n2);
        }
        if (byArray == null || byArray.length == 0) {
            this.bvcFound = false;
        } else {
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byte by = byArray[n2];
                for (int i2 = 0; i2 < 8; ++i2) {
                    if ((by & 1 << i2) == 0) continue;
                    this.bvcColSent.set(n2 * 8 + i2);
                }
            }
            this.bvcFound = true;
        }
    }

    Vector<IOException> marshal(byte[] byArray, char[] cArray, short[] sArray, int n2, byte[] byArray2, DBConversion dBConversion, InputStream[] inputStreamArray, byte[][] byArray3, OracleTypeADT[] oracleTypeADTArray, byte[] byArray4, char[] cArray2, short[] sArray2, byte[] byArray5, int n3, int[] nArray, boolean bl, int[] nArray2, int[] nArray3, int[][] nArray4, boolean bl2) throws IOException {
        Vector<IOException> vector = null;
        try {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            this.marshalTTCcode();
            int n18 = sArray[n2 + 0] & 0xFFFF;
            int n19 = 0;
            int n20 = nArray3[0];
            int[] nArray5 = nArray4[0];
            int n21 = 0;
            if (bl2) {
                n17 = 1;
                assert (n20 > 0) : "No postoned columns in RXD";
            } else {
                for (n16 = 0; n16 < n18; ++n16) {
                    short s2;
                    int n22;
                    int n23;
                    int n24;
                    if (n19 < n20 && nArray5[n19] == n16) {
                        ++n19;
                        continue;
                    }
                    n15 = 0;
                    n14 = n2 + 5 + 10 * n16;
                    n13 = sArray[n14 + 0] & 0xFFFF;
                    if (byArray5 != null && (byArray5[n16] & 0x20) == 0) {
                        if (n13 != 998) continue;
                        ++n21;
                        continue;
                    }
                    n12 = ((sArray[n14 + 7] & 0xFFFF) << 16) + (sArray[n14 + 8] & 0xFFFF) + n3;
                    n11 = ((sArray[n14 + 5] & 0xFFFF) << 16) + (sArray[n14 + 6] & 0xFFFF) + n3;
                    n10 = sArray[n12] & 0xFFFF;
                    n9 = sArray[n11];
                    if (n13 == 116) {
                        this.meg.marshalUB1((short)1);
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (n13 == 994) {
                        n9 = -1;
                        n24 = nArray2[3 + n16 * 4 + 0];
                        if (n24 == 109) {
                            n15 = 1;
                        }
                    } else if (n13 == 8 || n13 == 24 || !bl && nArray != null && nArray.length > n16 && nArray[n16] > this.connection.maxNonStreamBindByteSize) {
                        if (n20 >= nArray5.length) {
                            int[] nArray6 = new int[nArray5.length << 1];
                            System.arraycopy(nArray5, 0, nArray6, 0, nArray5.length);
                            nArray5 = nArray6;
                        }
                        nArray5[n20++] = n16;
                        continue;
                    }
                    if (n9 == -1) {
                        if (n13 == 109 || n15 != 0) {
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalDALC(NO_BYTES);
                            this.meg.marshalUB2(0);
                            this.meg.marshalUB4(0L);
                            this.meg.marshalUB2(1);
                            continue;
                        }
                        if (n13 == 998) {
                            ++n21;
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (n13 == 112 || n13 == 113 || n13 == 114) {
                            this.meg.marshalUB4(0L);
                            continue;
                        }
                        if (n13 != 8 && n13 != 24) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                    }
                    if (n13 == 998) {
                        n24 = (sArray2[6 + n21 * 8 + 4] & 0xFFFF) << 16 & 0xFFFF000 | sArray2[6 + n21 * 8 + 5] & 0xFFFF;
                        n23 = (sArray2[6 + n21 * 8 + 6] & 0xFFFF) << 16 & 0xFFFF000 | sArray2[6 + n21 * 8 + 7] & 0xFFFF;
                        int n25 = sArray2[6 + n21 * 8] & 0xFFFF;
                        int n26 = sArray2[6 + n21 * 8 + 1] & 0xFFFF;
                        this.meg.marshalUB4(n24);
                        for (n22 = 0; n22 < n24; ++n22) {
                            s2 = n23 + n22 * n26;
                            if (n25 == 9) {
                                n8 = cArray2[s2] / 2;
                                n7 = 0;
                                n7 = dBConversion.javaCharsToCHARBytes(cArray2, s2 + 1, byArray2, 0, n8);
                                this.meg.marshalCLR(byArray2, n7);
                                continue;
                            }
                            n10 = byArray4[s2];
                            if (n10 < 1) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalCLR(byArray4, s2 + 1, n10);
                        }
                        ++n21;
                        continue;
                    }
                    int n27 = sArray[n14 + 1] & 0xFFFF;
                    if (n27 != 0) {
                        int n28 = ((sArray[n14 + 3] & 0xFFFF) << 16) + (sArray[n14 + 4] & 0xFFFF) + n27 * n3;
                        if (n13 == 6) {
                            ++n28;
                            --n10;
                        } else if (n13 == 9) {
                            n28 += 2;
                            n10 -= 2;
                        } else if (n13 == 114 || n13 == 113 || n13 == 112) {
                            this.meg.marshalUB4(n10);
                        }
                        if (n13 == 109 || n13 == 111) {
                            if (byArray3 == null) {
                                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1, "INTERNAL ERROR: oracle.jdbc.driver.T4CTTIrxd.marshal: parameterDatum is null");
                                sQLException.fillInStackTrace();
                                throw sQLException;
                            }
                            byte[] byArray6 = byArray3[n16];
                            int n29 = n10 = byArray6 == null ? 0 : byArray6.length;
                            if (n13 == 109) {
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalDALC(NO_BYTES);
                                this.meg.marshalUB2(0);
                                this.meg.marshalUB4(n10);
                                this.meg.marshalUB2(1);
                            }
                            if (n10 <= 0) continue;
                            this.meg.marshalCLR(byArray6, 0, n10);
                            continue;
                        }
                        if (n13 == 104) {
                            long[] lArray = T4CRowidAccessor.stringToRowid(byArray, n28 += 2, 18);
                            n23 = 14;
                            long l2 = lArray[0];
                            n22 = (int)lArray[1];
                            s2 = 0;
                            long l3 = lArray[2];
                            int n30 = (int)lArray[3];
                            if (l2 == 0L && n22 == 0 && l3 == 0L && n30 == 0) {
                                this.meg.marshalUB1((short)0);
                                continue;
                            }
                            this.meg.marshalUB1((short)n23);
                            this.meg.marshalUB4(l2);
                            this.meg.marshalUB2(n22);
                            this.meg.marshalUB1(s2);
                            this.meg.marshalUB4(l3);
                            this.meg.marshalUB2(n30);
                            continue;
                        }
                        if (n13 == 208) {
                            this.meg.marshalUB4(n10 -= 2);
                            this.meg.marshalCLR(byArray, n28 += 2, n10);
                            continue;
                        }
                        if (n10 < 1) {
                            this.meg.marshalUB1((short)0);
                            continue;
                        }
                        this.meg.marshalCLR(byArray, n28, n10);
                        continue;
                    }
                    n6 = sArray[n14 + 9] & 0xFFFF;
                    n5 = sArray[n14 + 2] & 0xFFFF;
                    n4 = ((sArray[n14 + 3] & 0xFFFF) << 16) + (sArray[n14 + 4] & 0xFFFF) + n5 * n3 + 1;
                    if (n13 == 996) {
                        n24 = cArray[n4 - 1];
                        if (this.bufferCHAR == null || this.bufferCHAR.length < n24) {
                            this.bufferCHAR = new byte[n24];
                        }
                        for (n23 = 0; n23 < n24; ++n23) {
                            this.bufferCHAR[n23] = (byte)((cArray[n4 + n23 / 2] & 0xFF00) >> 8 & 0xFF);
                            if (n23 >= n24 - 1) continue;
                            this.bufferCHAR[n23 + 1] = (byte)(cArray[n4 + n23 / 2] & 0xFF & 0xFF);
                            ++n23;
                        }
                        this.meg.marshalCLR(this.bufferCHAR, n24);
                        if (this.bufferCHAR.length <= 4000) continue;
                        this.bufferCHAR = null;
                        continue;
                    }
                    if (n13 == 96) {
                        n8 = n10 / 2;
                        --n4;
                    } else {
                        n8 = (n10 - 2) / 2;
                    }
                    n7 = 0;
                    n7 = n6 == 2 ? dBConversion.javaCharsToNCHARBytes(cArray, n4, byArray2, 0, n8) : dBConversion.javaCharsToCHARBytes(cArray, n4, byArray2, 0, n8);
                    this.meg.marshalCLR(byArray2, n7);
                }
                n17 = n20;
            }
            if (n20 > 0) {
                for (n16 = 0; n16 < n17; ++n16) {
                    InputStream inputStream;
                    int n31;
                    n15 = nArray5[n16];
                    n14 = n2 + 5 + 10 * n15;
                    n13 = sArray[n14 + 0] & 0xFFFF;
                    n12 = ((sArray[n14 + 7] & 0xFFFF) << 16) + (sArray[n14 + 8] & 0xFFFF) + n3;
                    n11 = ((sArray[n14 + 5] & 0xFFFF) << 16) + (sArray[n14 + 6] & 0xFFFF) + n3;
                    n9 = sArray[n11];
                    n10 = sArray[n12] & 0xFFFF;
                    n5 = sArray[n14 + 2] & 0xFFFF;
                    n4 = ((sArray[n14 + 3] & 0xFFFF) << 16) + (sArray[n14 + 4] & 0xFFFF) + n5 * n3 + 1;
                    if (n9 == -1) {
                        this.meg.marshalUB1((short)0);
                        continue;
                    }
                    if (n13 == 996) {
                        n31 = cArray[n4 - 1];
                        if (this.bufferCHAR == null || this.bufferCHAR.length < n31) {
                            this.bufferCHAR = new byte[n31];
                        }
                        for (int i2 = 0; i2 < n31; ++i2) {
                            this.bufferCHAR[i2] = (byte)((cArray[n4 + i2 / 2] & 0xFF00) >> 8 & 0xFF);
                            if (i2 >= n31 - 1) continue;
                            this.bufferCHAR[i2 + 1] = (byte)(cArray[n4 + i2 / 2] & 0xFF & 0xFF);
                            ++i2;
                        }
                        this.meg.marshalCLR(this.bufferCHAR, n31);
                        if (this.bufferCHAR.length <= 4000) continue;
                        this.bufferCHAR = null;
                        continue;
                    }
                    if (n13 != 8 && n13 != 24) {
                        if (n13 == 96) {
                            n8 = n10 / 2;
                            --n4;
                        } else {
                            n8 = (n10 - 2) / 2;
                        }
                        n6 = sArray[n14 + 9] & 0xFFFF;
                        n7 = 0;
                        n7 = n6 == 2 ? dBConversion.javaCharsToNCHARBytes(cArray, n4, byArray2, 0, n8) : dBConversion.javaCharsToCHARBytes(cArray, n4, byArray2, 0, n8);
                        this.meg.marshalCLR(byArray2, n7);
                        continue;
                    }
                    n31 = n15;
                    if (inputStreamArray == null || (inputStream = inputStreamArray[n31]) == null) continue;
                    try {
                        this.meg.marshalCLR(inputStream, 0);
                        continue;
                    }
                    catch (IOException iOException) {
                        if (vector == null) {
                            vector = new Vector<IOException>();
                        }
                        vector.add(iOException);
                    }
                }
            }
            nArray3[0] = n20;
            nArray4[0] = nArray5;
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException();
            iOException.initCause(sQLException);
            throw iOException;
        }
        return vector;
    }

    boolean unmarshal(Accessor[] accessorArray, int n2) throws SQLException, IOException {
        return this.unmarshal(accessorArray, 0, n2);
    }

    void copyRowsAsNeeded(Accessor[] accessorArray, int n2) throws SQLException, IOException {
        int[] nArray = new int[this.nbOfColumns];
        int n3 = 0;
        int n4 = Math.min(n2, accessorArray.length);
        for (int i2 = 0; i2 < n4; ++i2) {
            Accessor accessor = accessorArray[i2];
            if (accessor.isUseLess || this.bvcColSent.get(accessor.physicalColumnIndex)) continue;
            nArray[n3++] = i2;
        }
        long l2 = -1L;
        while (n3 > 0) {
            int n5;
            int n6 = 0;
            Accessor accessor = accessorArray[nArray[n6]];
            long l3 = accessor.getOffset(accessor.getPreviousRowProcessed());
            for (n5 = 1; n5 < n3; ++n5) {
                int n7 = nArray[n5];
                accessor = accessorArray[nArray[n5]];
                long l4 = accessor.getOffset(accessor.getPreviousRowProcessed());
                if (l4 >= l3) continue;
                l3 = l4;
                n6 = n5;
                if (l4 == -1L) break;
            }
            n5 = nArray[n6];
            accessor = accessorArray[n5];
            assert (accessor.isNull(accessor.getPreviousRowProcessed()) || l2 < l3) : "lastOffset: " + l2 + "\tleastOffset: " + l3 + "\tindexOfLeastOffet: " + n6;
            l2 = l3;
            try {
                accessor.copyRow();
            }
            catch (AssertionError assertionError) {
                String string = this.dumpIndicesOfColumnsToBeCopied(n3, nArray, accessorArray);
                AssertionError assertionError2 = new AssertionError((Object)(string + "\nlastOffset: " + l2 + "\tleastOffset: " + l3 + "\tindexOfLeastOffet: " + n6));
                ((Throwable)((Object)assertionError2)).initCause((Throwable)((Object)assertionError));
                throw assertionError2;
            }
            nArray[n6] = nArray[--n3];
        }
    }

    boolean unmarshal(Accessor[] accessorArray, int n2, int n3) throws SQLException, IOException {
        int n4;
        for (n4 = n2; n4 < n3 && n4 < accessorArray.length; ++n4) {
            if (accessorArray[n4] == null || accessorArray[n4].physicalColumnIndex >= 0) continue;
            int n5 = 0;
            for (int i2 = 0; i2 < n3 && i2 < accessorArray.length; ++i2) {
                if (accessorArray[i2] == null) continue;
                accessorArray[i2].physicalColumnIndex = n5++;
                if (accessorArray[i2].isUseLess) continue;
            }
        }
        if (this.bvcFound && n2 == 0) {
            this.copyRowsAsNeeded(accessorArray, n3);
        }
        for (n4 = n2; n4 < n3 && n4 < accessorArray.length; ++n4) {
            if (accessorArray[n4] == null || this.bvcFound && !accessorArray[n4].isUseLess && !this.bvcColSent.get(accessorArray[n4].physicalColumnIndex)) continue;
            if (accessorArray[n4].statement.statementType == 2 || accessorArray[n4].statement.sqlKind.isPlsqlOrCall()) {
                accessorArray[n4].setCapacity(1);
            }
            if (!accessorArray[n4].unmarshalOneRow()) continue;
            return true;
        }
        this.bvcFound = false;
        return false;
    }

    String dumpIndicesOfColumnsToBeCopied(int n2, int[] nArray, Accessor[] accessorArray) throws SQLException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("dump indicesOfColumnsToBeCopied call_count: " + call_count++ + " numColumnsToBeCopied: " + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = accessorArray[nArray[i2]].getOffset(0);
            printWriter.println("copy order: " + i2 + " index: " + nArray[i2] + " offset: " + l2);
        }
        printWriter.println();
        return stringWriter.toString();
    }

    boolean unmarshal(Accessor[] accessorArray, int n2, int n3, int n4) throws SQLException, IOException {
        return false;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

