/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.LogicalTransactionIdEvent;
import oracle.jdbc.LogicalTransactionIdEventListener;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.ReplayContext;
import oracle.jdbc.replay.driver.EndReplayCallback;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManager;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableResultSet;
import oracle.jdbc.replay.driver.TxnReplayableStatement;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.OracleDataSource;

class TxnFailoverManagerImpl
implements TxnFailoverManager,
LogicalTransactionIdEventListener {
    private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
    private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
    private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
    private CallHistoryEntry head;
    private CallHistoryEntry tail;
    private ReplayLifecycle lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
    private static final int DIRECTIVE_ENQUEUE_CALL = 1;
    private static final int DIRECTIVE_REQ_SCOPE_CRSR = 2;
    private static final int DIRECTIVE_REPLAY_ENABLED = 4;
    private static final int DIRECTIVE_EMPTY_QUEUE = 8;
    private Object replayResult;
    private long requestStartTime;
    private long replayInitiationTimeout = 300L;
    private static final int REPLAY_RETRIES = 3;
    private int replayRetries = 0;
    private LogicalTransactionId ltxid = null;
    private LogicalTransactionId oldLtxidForPrepareReplay = null;
    private ReplayContext[] replayContext = null;
    private ReplayContext cxtBeforePrepareReplay;
    private OracleDataSource replayDataSource = null;
    private TxnReplayableBase connectionProxy;
    private String connectionProxyName;
    private Method callCausingReplayError;
    private int replayErrorCode;
    private String replayErrorMessage;
    private boolean doNotAbortConn = false;
    private boolean isReplayInDynamicMode = true;
    private static final int QUEUE_NUMBER = 2;
    private static final int NOT_IN_QUEUE = -1;
    private static int activeQueues = 2;
    private static final int INIT_EMPTY_COUNT = 0;
    private static final int NA_EMPTY_COUNT = -1;
    private static final int REQ_SCOPE_EMPTY_COUNT = Integer.MAX_VALUE;
    private int[] queueEmptyCounts = new int[2];
    boolean seenRoundtripCallInRequest = false;
    boolean didReplayingLastCallDisableReplay = false;
    short nestedLevelOfTopLevelCalls = 0;
    private static final HashSet<String> postExecuteGetCalls = new HashSet<String>(Arrays.asList("getGeneratedKeys", "getMoreResults", "getResultSet", "getUpdateCount", "getMetaData", "getArray", "getBigDecimal", "getBlob", "getBoolean", "getByte", "getBytes", "getCharacterStream", "getClob", "getDate", "getDouble", "getFloat", "getInt", "getLong", "getNCharacterStream", "getNClob", "getNString", "getObject", "getRef", "getRowId", "getShort", "getSQLXML", "getString", "getTime", "getTimestamp", "getURL", "wasNull", "getReturnResultSet", "getARRAY", "getAsciiStream", "getBFILE", "getBfile", "getBinaryStream", "getBLOB", "getCHAR", "getCLOB", "getCursor", "getCustomDatum", "getORAData", "getAnyDataEmbeddedObject", "getDATE", "getNUMBER", "getOPAQUE", "getOracleObject", "getRAW", "getREF", "getROWID", "getSTRUCT", "getINTERVALYM", "getINTERVALDS", "getTIMESTAMP", "getTIMESTAMPTZ", "getTIMESTAMPLTZ", "getUnicodeStream", "getPlsqlIndexTable", "getOraclePlsqlIndexTable"));
    private static final String NULL_METHOD_NAME = "NULL METHOD";
    private static final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(null, runnable, THREAD_NAME);
            thread.setPriority(5);
            thread.setDaemon(true);
            return thread;
        }
    });
    private static final String PREPARE_REPLAY = "DECLARE PROCEDURE PREPARE_REPLAY_WRAPPER(ltxid IN RAW, is_replay IN NUMBER, ac IN NUMBER, fncode IN BINARY_INTEGER, sql_text IN VARCHAR2, is_committed OUT NUMBER, is_embedded OUT NUMBER) IS attempting_replay BOOLEAN; auto_commit BOOLEAN; committed BOOLEAN; embedded BOOLEAN; BEGIN if is_replay = 1 then attempting_replay := true; else attempting_replay := false; end if; if ac = 1 then auto_commit := true; else auto_commit := false; end if; DBMS_APP_CONT_PRVT.PREPARE_REPLAY(ltxid, attempting_replay, auto_commit, fncode, sql_text, committed, embedded); if committed then is_committed := 1; else is_committed := 0; end if; if embedded then is_embedded := 1; else is_embedded := 0; end if; END; BEGIN PREPARE_REPLAY_WRAPPER(?,?,?,?,?,?,?); END;";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";

    private TxnFailoverManagerImpl(TxnReplayableBase txnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        this.connectionProxy = txnReplayableBase;
        this.connectionProxyName = this.connectionProxy.thisProxyNameInLog;
        this.replayDataSource = oracleDataSource;
        OracleConnection oracleConnection = (OracleConnection)txnReplayableBase.getDelegate();
        this.ltxid = oracleConnection.getLogicalTransactionId();
        this.replayContext = null;
        activeQueues = 2;
        this.queueEmptyCounts = new int[2];
        for (int i2 = 0; i2 < activeQueues; ++i2) {
            this.queueEmptyCounts[i2] = 0;
        }
        oracleConnection.addLogicalTransactionIdEventListener(this);
    }

    static TxnFailoverManager getFailoverManager(TxnReplayableBase txnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        return new TxnFailoverManagerImpl(txnReplayableBase, oracleDataSource);
    }

    private void append(CallHistoryEntry callHistoryEntry) {
        callHistoryEntry.prevEntry = this.tail;
        callHistoryEntry.nextEntry = null;
        if (this.tail != null) {
            this.tail.nextEntry = callHistoryEntry;
        }
        this.tail = callHistoryEntry;
        if (this.head == null) {
            this.head = callHistoryEntry;
        }
        JDBCReplayable jDBCReplayable = (JDBCReplayable)callHistoryEntry.jdbcProxy;
        jDBCReplayable.addToSameProxyList(callHistoryEntry);
    }

    private void remove(CallHistoryEntry callHistoryEntry) {
        if (callHistoryEntry.nextEntry != null) {
            callHistoryEntry.nextEntry.prevEntry = callHistoryEntry.prevEntry;
        }
        if (callHistoryEntry.prevEntry != null) {
            callHistoryEntry.prevEntry.nextEntry = callHistoryEntry.nextEntry;
        }
        if (this.head == callHistoryEntry) {
            this.head = callHistoryEntry.nextEntry;
        }
        if (this.tail == callHistoryEntry) {
            this.tail = callHistoryEntry.prevEntry;
        }
        JDBCReplayable jDBCReplayable = (JDBCReplayable)callHistoryEntry.jdbcProxy;
        jDBCReplayable.removeFromSameProxyList(callHistoryEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CallHistoryEntry record(Object object, Method method, Object[] objectArray, String string) {
        if (this.tail != null && this.tail.method != null && "started".equals(this.tail.callStatus)) {
            this.nestedLevelOfTopLevelCalls = (short)(this.nestedLevelOfTopLevelCalls + 1);
            return null;
        }
        TxnFailoverManagerImpl txnFailoverManagerImpl = this;
        synchronized (txnFailoverManagerImpl) {
            CallHistoryEntry callHistoryEntry = new CallHistoryEntry(object, method, objectArray, string);
            this.append(callHistoryEntry);
            return callHistoryEntry;
        }
    }

    private String dumpHistory() {
        String string = "Dump History: \n";
        if (this.head != null) {
            CallHistoryEntry callHistoryEntry = this.head;
            while (true) {
                string = string + callHistoryEntry.toString();
                if (callHistoryEntry == this.tail) break;
                callHistoryEntry = callHistoryEntry.nextEntry;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Object object, CallHistoryEntry callHistoryEntry, Object object2, String string, long l2, SQLException sQLException) {
        int n2;
        int n3;
        Object object3;
        int n4;
        Object object4;
        if (this.nestedLevelOfTopLevelCalls > 0) {
            this.nestedLevelOfTopLevelCalls = (short)(this.nestedLevelOfTopLevelCalls - 1);
            return;
        }
        ReplayContext[] replayContextArray = null;
        boolean bl = false;
        ReplayContext[] replayContextArray2 = null;
        int n5 = -1;
        int n6 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            object4 = (OracleConnection)this.connectionProxy.getDelegate();
            replayContextArray = object4.getReplayContext();
            Object object5 = object4 = callHistoryEntry == null ? this.tail : callHistoryEntry;
        }
        catch (SQLException sQLException2) {
            try {
                bl = true;
                Object object6 = object4 = callHistoryEntry == null ? this.tail : callHistoryEntry;
            }
            catch (Throwable throwable) {
                CallHistoryEntry callHistoryEntry2;
                CallHistoryEntry callHistoryEntry3 = callHistoryEntry2 = callHistoryEntry == null ? this.tail : callHistoryEntry;
                if (!bl) {
                    if (replayContextArray != null) {
                        this.replayContext = replayContextArray;
                        replayContextArray2 = new ReplayContext[replayContextArray.length];
                        if (replayContextArray.length > 0) {
                            this.seenRoundtripCallInRequest = true;
                        }
                        for (int i2 = 0; i2 < replayContextArray.length; ++i2) {
                            ReplayContext replayContext = replayContextArray[i2];
                            int n7 = (int)replayContext.getDirectives();
                            short s2 = replayContext.getQueue();
                            if ((n7 & 4) == 0) {
                                bl = true;
                                if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                                    this.didReplayingLastCallDisableReplay = true;
                                }
                                long l3 = replayContext.getErrorCode();
                                this.disableReplayInternal(callHistoryEntry2.method, 384, "Replay disabled by server Continuity Management", null);
                                return;
                            }
                            if ((n7 & 8) == 8) {
                                short s3 = s2;
                                this.queueEmptyCounts[s3] = this.queueEmptyCounts[s3] + 1;
                            }
                            assert ((n7 & 1) == 1 || !bl3) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
                            if ((n7 & 1) == 1) {
                                replayContextArray2[i2] = replayContext;
                                n5 = s2;
                                n6 = this.queueEmptyCounts[s2];
                                bl3 = true;
                            }
                            if ((n7 & 2) != 2) continue;
                            bl2 = true;
                        }
                    } else {
                        if (callHistoryEntry2.replayContext != null) {
                            return;
                        }
                        n5 = -1;
                        n6 = 0;
                    }
                } else {
                    this.disableReplayInternal(callHistoryEntry2.method, 383, "Replay disabled because getting replay context failed", null);
                }
                throw throwable;
            }
            if (!bl) {
                if (replayContextArray != null) {
                    this.replayContext = replayContextArray;
                    replayContextArray2 = new ReplayContext[replayContextArray.length];
                    if (replayContextArray.length > 0) {
                        this.seenRoundtripCallInRequest = true;
                    }
                    for (n4 = 0; n4 < replayContextArray.length; ++n4) {
                        object3 = replayContextArray[n4];
                        n3 = (int)object3.getDirectives();
                        n2 = object3.getQueue();
                        if ((n3 & 4) == 0) {
                            bl = true;
                            if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                                this.didReplayingLastCallDisableReplay = true;
                            }
                            long l4 = object3.getErrorCode();
                            this.disableReplayInternal(((CallHistoryEntry)object4).method, 384, "Replay disabled by server Continuity Management", null);
                            return;
                        }
                        if ((n3 & 8) == 8) {
                            int n8 = n2;
                            this.queueEmptyCounts[n8] = this.queueEmptyCounts[n8] + 1;
                        }
                        assert ((n3 & 1) == 1 || !bl3) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
                        if ((n3 & 1) == 1) {
                            replayContextArray2[n4] = object3;
                            n5 = n2;
                            n6 = this.queueEmptyCounts[n2];
                            bl3 = true;
                        }
                        if ((n3 & 2) != 2) continue;
                        bl2 = true;
                    }
                } else {
                    if (((CallHistoryEntry)object4).replayContext != null) {
                        return;
                    }
                    n5 = -1;
                    n6 = 0;
                }
            } else {
                this.disableReplayInternal(((CallHistoryEntry)object4).method, 383, "Replay disabled because getting replay context failed", null);
            }
        }
        if (!bl) {
            if (replayContextArray != null) {
                this.replayContext = replayContextArray;
                replayContextArray2 = new ReplayContext[replayContextArray.length];
                if (replayContextArray.length > 0) {
                    this.seenRoundtripCallInRequest = true;
                }
                for (n4 = 0; n4 < replayContextArray.length; ++n4) {
                    object3 = replayContextArray[n4];
                    n3 = (int)object3.getDirectives();
                    n2 = object3.getQueue();
                    if ((n3 & 4) == 0) {
                        bl = true;
                        if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
                            this.didReplayingLastCallDisableReplay = true;
                        }
                        long l5 = object3.getErrorCode();
                        this.disableReplayInternal(((CallHistoryEntry)object4).method, 384, "Replay disabled by server Continuity Management", null);
                        return;
                    }
                    if ((n3 & 8) == 8) {
                        int n9 = n2;
                        this.queueEmptyCounts[n9] = this.queueEmptyCounts[n9] + 1;
                    }
                    assert ((n3 & 1) == 1 || !bl3) : "AC runtime: the server doesn't send ENQUEUE for all the RPCs of the same JDBC call";
                    if ((n3 & 1) == 1) {
                        replayContextArray2[n4] = object3;
                        n5 = n2;
                        n6 = this.queueEmptyCounts[n2];
                        bl3 = true;
                    }
                    if ((n3 & 2) != 2) continue;
                    bl2 = true;
                }
            } else {
                if (((CallHistoryEntry)object4).replayContext != null) {
                    return;
                }
                n5 = -1;
                n6 = 0;
            }
        } else {
            this.disableReplayInternal(((CallHistoryEntry)object4).method, 383, "Replay disabled because getting replay context failed", null);
        }
        if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED && this.tail != null) {
            object4 = callHistoryEntry == null ? this.tail : callHistoryEntry;
            Object object7 = this;
            synchronized (object7) {
                object3 = object4 == null || ((CallHistoryEntry)object4).method == null ? NULL_METHOD_NAME : ((CallHistoryEntry)object4).method.getName();
                ((CallHistoryEntry)object4).result = object2;
                ((CallHistoryEntry)object4).checksum = l2;
                if (replayContextArray2 != null) {
                    if (((CallHistoryEntry)object4).replayContext == null) {
                        ((CallHistoryEntry)object4).replayContext = replayContextArray2;
                    } else {
                        ReplayContext[] replayContextArray3 = new ReplayContext[((CallHistoryEntry)object4).replayContext.length + replayContextArray2.length];
                        System.arraycopy(((CallHistoryEntry)object4).replayContext, 0, replayContextArray3, 0, ((CallHistoryEntry)object4).replayContext.length);
                        System.arraycopy(replayContextArray2, 0, replayContextArray3, ((CallHistoryEntry)object4).replayContext.length, replayContextArray2.length);
                        ((CallHistoryEntry)object4).replayContext = replayContextArray3;
                    }
                }
                ((CallHistoryEntry)object4).callException = sQLException;
                ((CallHistoryEntry)object4).queueId = n5;
                ((CallHistoryEntry)object4).queueEmptyCount = n6;
                ((CallHistoryEntry)object4).serverAsksToEnqueue = bl3;
                ((CallHistoryEntry)object4).callStatus = string;
                if (replayContextArray2 != null) {
                    for (ReplayContext replayContext : replayContextArray2) {
                        if (replayContext != null) continue;
                    }
                }
            }
            if (!this.isSessionStateConsistencyDynamic() && bl2) {
                object7 = ((TxnReplayableResultSet)((CallHistoryEntry)object4).jdbcProxy).creatorCallEntry;
                ((CallHistoryEntry)object7).queueEmptyCount = Integer.MAX_VALUE;
            }
        }
    }

    synchronized void purge() {
        CallHistoryEntry callHistoryEntry = this.head;
        while (callHistoryEntry != null) {
            this.remove(callHistoryEntry);
            callHistoryEntry = callHistoryEntry.nextEntry;
        }
    }

    synchronized void purgeForSameProxy(Set<Object> set, CallHistoryEntry callHistoryEntry) {
        Object object = callHistoryEntry == null ? null : callHistoryEntry.jdbcProxy;
        CallHistoryEntry callHistoryEntry2 = callHistoryEntry;
        while (callHistoryEntry2 != null) {
            Object object2 = callHistoryEntry2.result;
            if (object2 != null && object2 instanceof JDBCReplayable && !set.contains(object2)) {
                JDBCReplayable jDBCReplayable = (JDBCReplayable)object2;
                jDBCReplayable.purgeSameProxyList();
                set.add(jDBCReplayable);
            }
            this.remove(callHistoryEntry2);
            callHistoryEntry2 = callHistoryEntry2.nextEntrySameProxy;
        }
    }

    synchronized boolean isEmpty() {
        return this.head == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object handleOutage(SQLRecoverableException sQLRecoverableException) throws SQLException {
        TxnFailoverManagerImpl txnFailoverManagerImpl = this;
        synchronized (txnFailoverManagerImpl) {
            this.replayRetries = 0;
            do {
                ReplayLifecycle replayLifecycle;
                try {
                    return this.handleOutageInternal(sQLRecoverableException, this.replayRetries);
                }
                catch (SQLRecoverableException sQLRecoverableException2) {
                    replayLifecycle = this.lifecycle;
                    switch (replayLifecycle) {
                        case REPLAYING: 
                        case REPLAYING_CALLBACK: 
                        case REPLAYING_LASTCALL: {
                            ++this.replayRetries;
                            break;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    replayLifecycle = this.lifecycle;
                    switch (replayLifecycle) {
                        case INTERNALLY_FAILED: {
                            ++this.replayRetries;
                            this.lifecycle = ReplayLifecycle.REPLAYING;
                            break;
                        }
                        case ALWAYS_DISABLED: 
                        case INTERNALLY_DISABLED: 
                        case EXTERNALLY_DISABLED: {
                            if (this.didReplayingLastCallDisableReplay) {
                                throw sQLException;
                            }
                            this.throwOriginalExceptionWithReplayError(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
                        }
                        case REPLAYING_LASTCALL: {
                            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
                            throw sQLException;
                        }
                    }
                }
            } while (this.replayRetries <= 3);
            this.disableReplayAndThrowOriginalError(null, 378, "Replay disabled because maximum number of retries is exceeded", sQLRecoverableException);
            return null;
        }
    }

    synchronized Object handleOutageInternal(SQLRecoverableException sQLRecoverableException, int n2) throws SQLException {
        long l2;
        OracleConnection oracleConnection;
        this.didReplayingLastCallDisableReplay = false;
        ReplayLifecycle replayLifecycle = this.lifecycle;
        if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
            if (this.replayErrorCode == 0) {
                this.doNotAbortConn = true;
                this.replayErrorCode = 370;
                this.replayErrorMessage = "Replay disabled";
            }
            this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
        }
        OracleConnection oracleConnection2 = (OracleConnection)this.connectionProxy.getDelegate();
        short s2 = oracleConnection2.getExecutingRPCFunctionCode();
        String string = oracleConnection2.getExecutingRPCSQL();
        ReplayContext replayContext = oracleConnection2.getLastReplayContext();
        if (replayContext != null) {
            this.cxtBeforePrepareReplay = replayContext;
        }
        if ((oracleConnection = (OracleConnection)this.replayDataSource.getConnectionNoProxy(((TxnReplayableConnection)this.connectionProxy).originalUser, ((TxnReplayableConnection)this.connectionProxy).originalPasswd)) == null) {
            this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", sQLRecoverableException);
        }
        this.connectionProxy.setDelegate(oracleConnection);
        oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
        this.oldLtxidForPrepareReplay = this.ltxid;
        this.ltxid = oracleConnection.getLogicalTransactionId();
        oracleConnection.addLogicalTransactionIdEventListener(this);
        String string2 = this.tail.method.getName();
        oracleConnection.setReplayContext(new ReplayContext[]{this.cxtBeforePrepareReplay});
        boolean bl = this.prepareReplay(oracleConnection, sQLRecoverableException, s2, string);
        if (bl) {
            if (this.isSessionStateConsistencyDynamic()) {
                if (string2.equals("execute")) {
                    return false;
                }
                if (string2.equals("commit")) {
                    return null;
                }
                return null;
            }
            this.queueEmptyCounts[1] = this.queueEmptyCounts[1] + 1;
        }
        if (this.requestStartTime + this.replayInitiationTimeout * 1000L < (l2 = System.currentTimeMillis())) {
            this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", sQLRecoverableException);
        }
        oracleConnection.getReplayContext();
        this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
        ConnectionInitializationCallback connectionInitializationCallback = this.replayDataSource.getConnectionInitializationCallback();
        if (connectionInitializationCallback != null) {
            try {
                connectionInitializationCallback.initialize((Connection)((Object)this.connectionProxy));
            }
            catch (SQLRecoverableException sQLRecoverableException2) {
                throw sQLRecoverableException2;
            }
            catch (SQLException sQLException) {
                this.disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", sQLRecoverableException);
            }
            EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
            if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                this.disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", sQLRecoverableException);
            }
        }
        this.lifecycle = ReplayLifecycle.REPLAYING;
        this.beginReplay(oracleConnection, sQLRecoverableException);
        this.replayResult = this.replayAllBeforeLastCall(sQLRecoverableException);
        if (this.tail.replayContext == null || this.tail.replayContext.length == 0) {
            this.endReplay(oracleConnection, sQLRecoverableException);
        } else {
            oracleConnection.registerEndReplayCallback(new EndReplayCallback(this, oracleConnection, sQLRecoverableException));
        }
        if (!bl) {
            if (this.tail != null) {
                this.replayResult = ((JDBCReplayable)this.tail.jdbcProxy).replayOneCall(this.tail, sQLRecoverableException);
            }
        } else if (!this.isSessionStateConsistencyDynamic()) {
            this.tail.callStatus = "completed";
            this.tail.queueId = 1;
            this.tail.queueEmptyCount = this.queueEmptyCounts[1];
            this.tail.serverAsksToEnqueue = false;
            this.replayResult = string2.equals("execute") ? Boolean.valueOf(false) : (string2.equals("commit") ? null : null);
        }
        if (this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
            this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        }
        return this.replayResult;
    }

    private synchronized Object replayAllBeforeLastCall(SQLRecoverableException sQLRecoverableException) throws SQLException {
        Object object = null;
        CallHistoryEntry callHistoryEntry = this.head;
        while (callHistoryEntry != this.tail) {
            String string = callHistoryEntry.method == null ? NULL_METHOD_NAME : callHistoryEntry.method.getName();
            TxnReplayableBase txnReplayableBase = (TxnReplayableBase)callHistoryEntry.jdbcProxy;
            String string2 = txnReplayableBase.thisProxyNameInLog;
            if (this.isSessionStateConsistencyDynamic() && (callHistoryEntry.replayContext == null || callHistoryEntry.serverAsksToEnqueue) || !this.isSessionStateConsistencyDynamic() && txnReplayableBase.isCreatingCallReplayable && (callHistoryEntry.replayContext == null && !postExecuteGetCalls.contains(string) || callHistoryEntry.replayContext == null && postExecuteGetCalls.contains(string) && txnReplayableBase.isCurrentExecuteReplayable || callHistoryEntry.serverAsksToEnqueue && callHistoryEntry.replayContext != null && callHistoryEntry.queueId >= 0 && callHistoryEntry.queueId < this.queueEmptyCounts.length && callHistoryEntry.queueEmptyCount == this.queueEmptyCounts[callHistoryEntry.queueId] || callHistoryEntry.queueEmptyCount == Integer.MAX_VALUE)) {
                object = txnReplayableBase.replayOneCall(callHistoryEntry, sQLRecoverableException);
                if (!this.isSessionStateConsistencyDynamic() && txnReplayableBase instanceof TxnReplayableStatement && string.startsWith("execute")) {
                    txnReplayableBase.isCurrentExecuteReplayable = true;
                }
                if (!this.isSessionStateConsistencyDynamic() && callHistoryEntry.result != null && callHistoryEntry.result instanceof TxnReplayableBase) {
                    ((TxnReplayableBase)callHistoryEntry.result).isCreatingCallReplayable = true;
                }
                if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                    this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
                }
            } else {
                if (!this.isSessionStateConsistencyDynamic() && txnReplayableBase instanceof TxnReplayableStatement && string.startsWith("execute")) {
                    txnReplayableBase.isCurrentExecuteReplayable = false;
                }
                if (!this.isSessionStateConsistencyDynamic() && callHistoryEntry.result != null && callHistoryEntry.result instanceof TxnReplayableBase) {
                    ((TxnReplayableBase)callHistoryEntry.result).isCreatingCallReplayable = false;
                }
            }
            callHistoryEntry = callHistoryEntry.nextEntry;
        }
        return object;
    }

    ReplayLifecycle getReplayLifecycle() {
        return this.lifecycle;
    }

    void setDataSource(OracleDataSource oracleDataSource) {
        this.replayDataSource = oracleDataSource;
    }

    void setReplayInitiationTimeout(int n2) throws SQLException {
        this.replayInitiationTimeout = n2;
    }

    boolean isSessionStateConsistencyDynamic() {
        return this.isReplayInDynamicMode;
    }

    void setSessionStateConsistency(boolean bl) throws SQLException {
        this.isReplayInDynamicMode = !bl;
    }

    synchronized void beginRequest() throws SQLException {
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            return;
        }
        if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED) {
            throw DatabaseError.createSqlException(391);
        }
        this.requestStartTime = System.currentTimeMillis();
        OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        oracleConnection.getReplayContext();
        if (this.isReplayInDynamicMode) {
            oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
        } else {
            oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
        }
        EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
        if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
            SQLException sQLException = DatabaseError.createSqlException(392);
            throw sQLException;
        }
        this.replayErrorCode = 0;
        this.replayErrorMessage = "";
        this.callCausingReplayError = null;
        this.seenRoundtripCallInRequest = false;
        oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_BINDS);
        this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
    }

    synchronized void endRequest() throws SQLException {
        OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END));
        EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
        if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
            try {
                oracleConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            SQLException sQLException = DatabaseError.createSqlException(393);
            throw sQLException;
        }
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            return;
        }
        if (this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED || this.lifecycle == ReplayLifecycle.EXTERNALLY_DISABLED) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
            return;
        }
        this.disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
    }

    void disableReplay() throws SQLException {
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            return;
        }
        this.disableReplayInternal(null, 370, "Replay disabled", null);
        this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
    }

    void disableReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        ReplayLifecycle replayLifecycle = this.lifecycle;
        OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
        }
        this.purge();
        this.replayErrorCode = n2;
        this.replayErrorMessage = string;
        this.callCausingReplayError = method;
        for (int i2 = 0; i2 < activeQueues; ++i2) {
            this.queueEmptyCounts[i2] = 0;
        }
        try {
            oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.NO_CHECKSUM);
            if (!this.seenRoundtripCallInRequest) {
                if (!this.isReplayInDynamicMode) {
                    oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
                } else {
                    oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_BEGIN));
                }
            } else if (!this.isReplayInDynamicMode) {
                oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
            } else {
                oracleConnection.setReplayOperations(EnumSet.noneOf(OracleConnection.ReplayOperation.class));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void failReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        ReplayLifecycle replayLifecycle = this.lifecycle;
        if (this.lifecycle == ReplayLifecycle.REPLAYING || this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK || this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
        }
        this.replayErrorCode = n2;
        this.replayErrorMessage = string;
        this.callCausingReplayError = method;
    }

    void throwReplayExceptionInternal(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        if (n2 == 0) {
            return;
        }
        String string2 = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException sQLException = DatabaseError.createSqlException(this.replayErrorCode, string2);
        throw sQLException;
    }

    void disableReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.disableReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwReplayExceptionInternal(n2, string, sQLRecoverableException);
    }

    void disableReplayAndThrowOriginalError(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.disableReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwOriginalExceptionWithReplayError(n2, string, sQLRecoverableException);
    }

    void failReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.failReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwReplayExceptionInternal(n2, string, sQLRecoverableException);
    }

    void throwOriginalExceptionWithReplayError(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLRecoverableException {
        if (!this.doNotAbortConn) {
            this.killConnectionBeforeReplayDisabledException();
        }
        String string2 = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException sQLException = DatabaseError.createSqlException(this.replayErrorCode, string2);
        sQLRecoverableException.setNextException(sQLException);
        throw sQLRecoverableException;
    }

    void killConnectionBeforeReplayDisabledException() {
        final OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        try {
            oracleConnection.abort();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    TxnFailoverManagerImpl.this.closePhysicalConnection(oracleConnection);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void enableTxnMonitoring(OracleConnection oracleConnection) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(MONITOR_TXN);
            statement.close();
        }
        catch (SQLException sQLException) {
            this.disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
            this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
            throw DatabaseError.createSqlException(395);
        }
    }

    void beginReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(BEGIN_REPLAY);
            statement.close();
            oracleConnection.setReplayingMode(true);
            this.lifecycle = ReplayLifecycle.REPLAYING;
        }
        catch (SQLException sQLException) {
            this.disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", sQLRecoverableException);
        }
    }

    void endReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(END_REPLAY);
            statement.close();
            oracleConnection.setReplayingMode(false);
            oracleConnection.setReplayOperations(EnumSet.noneOf(OracleConnection.ReplayOperation.class));
            if (!this.isReplayInDynamicMode) {
                oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            } else {
                oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_APPCONT_ENABLED));
            }
            oracleConnection.getReplayContext();
            this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
        }
        catch (SQLException sQLException) {
            this.disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", sQLRecoverableException);
        }
    }

    boolean prepareReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException, short s2, String string) throws SQLException {
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (!this.isReplayInDynamicMode) {
                oracleConnection.setReplayOperations(EnumSet.of(OracleConnection.ReplayOperation.KPDSS_SESSSTATE_REQUEST_END, OracleConnection.ReplayOperation.KPDSS_SESSSTATE_STATIC));
            }
            CallableStatement callableStatement = oracleConnection.prepareCall(PREPARE_REPLAY);
            callableStatement.setBytes(1, this.oldLtxidForPrepareReplay.getBytes());
            callableStatement.setInt(2, this.seenRoundtripCallInRequest ? 1 : 0);
            callableStatement.setInt(3, oracleConnection.getAutoCommit() ? 1 : 0);
            callableStatement.setInt(4, (int)s2);
            callableStatement.setString(5, string);
            callableStatement.registerOutParameter(6, -7);
            callableStatement.registerOutParameter(7, -7);
            callableStatement.execute();
            bl = callableStatement.getBoolean(6);
            bl2 = callableStatement.getBoolean(7);
            callableStatement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.disableReplayAndThrowException(null, 385, "Replay disabled because server prepare_replay call failed", sQLRecoverableException);
        }
        if (!bl2) {
            return bl;
        }
        this.disableReplayAndThrowException(null, 386, "Replay disabled because of embedded commit", sQLRecoverableException);
        return false;
    }

    JDBCReplayable getConnectionProxy() {
        return this.connectionProxy;
    }

    private boolean isReplayFailure(SQLException sQLException) {
        int n2;
        boolean bl = false;
        if (sQLException instanceof SQLException && (n2 = sQLException.getErrorCode()) >= 370 && n2 < 400) {
            bl = true;
        }
        return bl;
    }

    private void closePhysicalConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    LogicalTransactionId getLogicalTransactionId() {
        return this.ltxid;
    }

    void setLogicalTransactionId(LogicalTransactionId logicalTransactionId) {
        this.ltxid = logicalTransactionId;
    }

    @Override
    public void onLogicalTransactionIdEvent(LogicalTransactionIdEvent logicalTransactionIdEvent) {
        LogicalTransactionId logicalTransactionId = logicalTransactionIdEvent.getLogicalTransactionId();
        this.setLogicalTransactionId(logicalTransactionId);
    }

    ReplayContext[] getReplayContext() {
        return this.replayContext;
    }

    void setReplayContext(ReplayContext[] replayContextArray) {
        this.replayContext = replayContextArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActiveQueues(int n2) {
        int n3;
        int n4 = (n2 + 1 - this.queueEmptyCounts.length) / 2 * 2;
        int n5 = this.queueEmptyCounts.length + n4;
        int[] nArray = new int[n5];
        System.arraycopy(this.queueEmptyCounts, 0, nArray, 0, this.queueEmptyCounts.length);
        for (n3 = this.queueEmptyCounts.length; n3 <= n2; ++n3) {
            nArray[n3] = 0;
        }
        for (n3 = n2 + 1; n3 <= n5; ++n3) {
            nArray[n3] = 0;
        }
        TxnFailoverManagerImpl txnFailoverManagerImpl = this;
        synchronized (txnFailoverManagerImpl) {
            this.queueEmptyCounts = nArray;
            activeQueues = n5;
        }
    }

    static enum ReplayLifecycle {
        ENABLED_NOT_REPLAYING,
        INTERNALLY_FAILED,
        INTERNALLY_DISABLED,
        ALWAYS_DISABLED,
        EXTERNALLY_DISABLED,
        REPLAYING_CALLBACK,
        REPLAYING,
        REPLAYING_LASTCALL;

    }

    static class CallHistoryEntry {
        Object jdbcProxy;
        Method method;
        Object[] args;
        Object result;
        String callStatus;
        long checksum;
        boolean openAcrossPurge;
        int queueId;
        int queueEmptyCount;
        ReplayContext[] replayContext;
        boolean serverAsksToEnqueue;
        SQLException callException;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;
        CallHistoryEntry nextEntrySameProxy = null;
        CallHistoryEntry prevEntrySameProxy = null;

        CallHistoryEntry(Object object, Method method, Object[] objectArray, String string) {
            this.jdbcProxy = object;
            this.method = method;
            this.args = objectArray;
            this.result = null;
            this.callStatus = string;
            this.openAcrossPurge = false;
        }

        public String toString() {
            String string = "CallHistoryEntry: method.getName()=" + this.method.getName() + ", queueId=" + this.queueId + ", queueEmptyCount=" + this.queueEmptyCount + ", serverAsksToEnqueue=" + this.serverAsksToEnqueue + ", replayContext=" + this.replayContext;
            if (this.replayContext != null) {
                for (int i2 = 0; i2 < this.replayContext.length; ++i2) {
                    string = string + this.replayContext[i2];
                }
            }
            return string + "\n";
        }
    }
}

