/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ScopeUtil;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;

public class SubProcessActivityBehavior
extends AbstractBpmnActivityBehavior
implements CompositeActivityBehavior {
    @Override
    public void execute(ActivityExecution execution) throws Exception {
        PvmActivity activity = execution.getActivity();
        ActivityImpl initialActivity = (ActivityImpl)activity.getProperty("initial");
        if (initialActivity == null) {
            throw new ActivitiException("No initial activity found for subprocess " + execution.getActivity().getId());
        }
        this.initializeDataObjects(execution, activity);
        execution.executeActivity(initialActivity);
    }

    @Override
    public void lastExecutionEnded(ActivityExecution execution) {
        ScopeUtil.createEventScopeExecution((ExecutionEntity)execution);
        Map<String, Object> dataObjectVars = ((ActivityImpl)execution.getActivity()).getVariables();
        if (dataObjectVars != null) {
            execution.removeVariablesLocal(dataObjectVars.keySet());
        }
        this.bpmnActivityBehavior.performDefaultOutgoingBehavior(execution);
    }

    protected void initializeDataObjects(ActivityExecution execution, PvmActivity activity) {
        Map<String, Object> dataObjectVars = ((ActivityImpl)activity).getVariables();
        if (dataObjectVars != null) {
            execution.setVariablesLocal(dataObjectVars);
        }
    }
}

