/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import java.util.HashSet;
import java.util.Set;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.form.DefaultTaskFormHandler;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.apache.commons.lang3.StringUtils;

public class UserTaskParseHandler
extends AbstractActivityBpmnParseHandler<UserTask> {
    public static final String PROPERTY_TASK_DEFINITION = "taskDefinition";

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return UserTask.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, UserTask userTask) {
        ActivityImpl activity = this.createActivityOnCurrentScope(bpmnParse, (FlowElement)userTask, "userTask");
        activity.setAsync(userTask.isAsynchronous());
        activity.setExclusive(!userTask.isNotExclusive());
        TaskDefinition taskDefinition = this.parseTaskDefinition(bpmnParse, userTask, userTask.getId(), (ProcessDefinitionEntity)bpmnParse.getCurrentScope().getProcessDefinition());
        activity.setProperty(PROPERTY_TASK_DEFINITION, taskDefinition);
        activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createUserTaskActivityBehavior(userTask, taskDefinition));
    }

    public TaskDefinition parseTaskDefinition(BpmnParse bpmnParse, UserTask userTask, String taskDefinitionKey, ProcessDefinitionEntity processDefinition) {
        DefaultTaskFormHandler taskFormHandler = new DefaultTaskFormHandler();
        taskFormHandler.parseConfiguration(userTask.getFormProperties(), userTask.getFormKey(), bpmnParse.getDeployment(), processDefinition);
        TaskDefinition taskDefinition = new TaskDefinition(taskFormHandler);
        taskDefinition.setKey(taskDefinitionKey);
        processDefinition.getTaskDefinitions().put(taskDefinitionKey, taskDefinition);
        ExpressionManager expressionManager = bpmnParse.getExpressionManager();
        if (StringUtils.isNotEmpty((CharSequence)userTask.getName())) {
            taskDefinition.setNameExpression(expressionManager.createExpression(userTask.getName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getDocumentation())) {
            taskDefinition.setDescriptionExpression(expressionManager.createExpression(userTask.getDocumentation()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getAssignee())) {
            taskDefinition.setAssigneeExpression(expressionManager.createExpression(userTask.getAssignee()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getOwner())) {
            taskDefinition.setOwnerExpression(expressionManager.createExpression(userTask.getOwner()));
        }
        for (String candidateUser : userTask.getCandidateUsers()) {
            taskDefinition.addCandidateUserIdExpression(expressionManager.createExpression(candidateUser));
        }
        for (String candidateGroup : userTask.getCandidateGroups()) {
            taskDefinition.addCandidateGroupIdExpression(expressionManager.createExpression(candidateGroup));
        }
        for (ActivitiListener taskListener : userTask.getTaskListeners()) {
            taskDefinition.addTaskListener(taskListener.getEvent(), this.createTaskListener(bpmnParse, taskListener, userTask.getId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getDueDate())) {
            taskDefinition.setDueDateExpression(expressionManager.createExpression(userTask.getDueDate()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getCategory())) {
            taskDefinition.setCategoryExpression(expressionManager.createExpression(userTask.getCategory()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getPriority())) {
            taskDefinition.setPriorityExpression(expressionManager.createExpression(userTask.getPriority()));
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getFormKey())) {
            taskDefinition.setFormKeyExpression(expressionManager.createExpression(userTask.getFormKey()));
        }
        for (String customUserIdentityLinkType : userTask.getCustomUserIdentityLinks().keySet()) {
            HashSet<Expression> userIdentityLinkExpression = new HashSet<Expression>();
            for (String userIdentityLink : (Set)userTask.getCustomUserIdentityLinks().get(customUserIdentityLinkType)) {
                userIdentityLinkExpression.add(expressionManager.createExpression(userIdentityLink));
            }
            taskDefinition.addCustomUserIdentityLinkExpression(customUserIdentityLinkType, userIdentityLinkExpression);
        }
        for (String customGroupIdentityLinkType : userTask.getCustomGroupIdentityLinks().keySet()) {
            HashSet<Expression> groupIdentityLinkExpression = new HashSet<Expression>();
            for (String groupIdentityLink : (Set)userTask.getCustomGroupIdentityLinks().get(customGroupIdentityLinkType)) {
                groupIdentityLinkExpression.add(expressionManager.createExpression(groupIdentityLink));
            }
            taskDefinition.addCustomGroupIdentityLinkExpression(customGroupIdentityLinkType, groupIdentityLinkExpression);
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getSkipExpression())) {
            taskDefinition.setSkipExpression(expressionManager.createExpression(userTask.getSkipExpression()));
        }
        return taskDefinition;
    }

    protected TaskListener createTaskListener(BpmnParse bpmnParse, ActivitiListener activitiListener, String taskId) {
        TaskListener taskListener = null;
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equalsIgnoreCase(activitiListener.getImplementationType())) {
            taskListener = bpmnParse.getListenerFactory().createClassDelegateTaskListener(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
            taskListener = bpmnParse.getListenerFactory().createExpressionTaskListener(activitiListener);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equalsIgnoreCase(activitiListener.getImplementationType())) {
            taskListener = bpmnParse.getListenerFactory().createDelegateExpressionTaskListener(activitiListener);
        }
        return taskListener;
    }
}

