/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity.html;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.entity.html.Table;
import org.anyline.entity.html.Tr;
import org.anyline.util.BeanUtil;
import org.dom4j.Element;

public class Td {
    private Map<String, String> styles = new HashMap<String, String>();
    private Element src;
    private String text = null;
    private int colspan = 1;
    private int rowspan = 1;
    private String clazz = null;
    private int merge = -1;
    private int offset = 0;
    private boolean remove = false;
    private String width;
    private boolean isMerge = false;
    private Tr tr;
    private String widthUnit = "px";

    public Map<String, String> getStyles() {
        return this.styles;
    }

    public Td() {
    }

    public Td(String text) {
        this.setText(text);
    }

    public void setStyles(Map<String, String> styles) {
        this.styles = styles;
    }

    public Element getSrc() {
        return this.src;
    }

    public void setSrc(Element src) {
        this.src = src;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getColspan() {
        return this.colspan;
    }

    public boolean isEmpty() {
        if (null != this.src) {
            return false;
        }
        if (null != this.clazz) {
            return false;
        }
        if (null != this.text) {
            return false;
        }
        if (this.merge >= 0) {
            return false;
        }
        if (this.rowspan > 1) {
            return false;
        }
        if (this.colspan > 1) {
            return false;
        }
        return !this.isRemove();
    }

    public Td setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public Td addOffset(int offset) {
        this.offset += offset;
        return this;
    }

    public Td setColspan(int colspan) {
        this.colspan = colspan;
        if (colspan > 1) {
            this.isMerge = true;
        }
        return this;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public Td setRowspan(int rowspan) {
        this.rowspan = rowspan;
        if (rowspan > 1) {
            this.isMerge = true;
        }
        return this;
    }

    public void merge() {
        if (this.isMerge) {
            return;
        }
        Tr tr = this.getTr();
        List<Td> tds = tr.getTds();
        List<Tr> trs = tr.getTable().getTrs();
        int cols = tds.indexOf(this);
        int rows = trs.indexOf(tr);
        for (int c = cols + 1; c < cols + this.colspan; ++c) {
            tr.getTd(c).setRemove(true);
        }
        for (int r = rows + 1; r < rows + this.rowspan; ++r) {
            tr = trs.get(r);
            for (int c = cols; c < cols + this.colspan; ++c) {
                tr.getTd(c).setRemove(true);
            }
        }
        this.isMerge = true;
    }

    public int[] index() {
        int[] result = new int[2];
        Tr tr = this.getTr();
        List<Td> tds = tr.getTds();
        result[0] = tr.index();
        result[1] = tds.indexOf(this);
        return result;
    }

    public int getColIndex() {
        Tr tr = this.getTr();
        List<Td> tds = tr.getTds();
        return tds.indexOf(this);
    }

    public int getRowIndex() {
        Tr tr = this.getTr();
        return tr.index();
    }

    public String getWidth() {
        return this.width;
    }

    public Td setWidth(String width) {
        this.width = width;
        return this;
    }

    public Td setWidth(int width) {
        this.width = width + this.widthUnit;
        return this;
    }

    public Td setWidth(double width) {
        this.width = width + this.widthUnit;
        return this;
    }

    public String getClazz() {
        return this.clazz;
    }

    public Tr getTr() {
        return this.tr;
    }

    public void setTr(Tr tr) {
        this.tr = tr;
    }

    public String getText() {
        return this.text;
    }

    public String getTextNvl() {
        if (null == this.text) {
            return "";
        }
        return this.text;
    }

    public String getTextTrim() {
        if (null == this.text) {
            return "";
        }
        return this.text.trim();
    }

    public Td setText(String text) {
        this.text = text;
        return this;
    }

    public Td setClazz(String clazz) {
        this.clazz = clazz;
        return this;
    }

    public int getMerge() {
        return this.merge;
    }

    public Td setMerge(int merge) {
        this.merge = merge;
        return this;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public Td setRemove(boolean remove) {
        this.remove = remove;
        return this;
    }

    public void build(StringBuilder builder) {
        if (null == builder) {
            builder = new StringBuilder();
        }
        if (!this.remove) {
            builder.append("<td");
            if (null != this.styles && !this.styles.isEmpty()) {
                builder.append(" style='");
                for (String key : this.styles.keySet()) {
                    builder.append(key).append(":").append(this.styles.get(key)).append(";");
                }
                builder.append("'");
            }
            if (this.colspan > 1) {
                builder.append(" colspan='").append(this.colspan).append("'");
            }
            if (this.rowspan > 1) {
                builder.append(" rowspan='").append(this.rowspan).append("'");
            }
            builder.append(" data-row-index='").append(this.getRowIndex()).append("'");
            builder.append(" data-col-index='").append(this.getColIndex()).append("'");
            builder.append(" data-offset='").append(this.offset).append("'");
            builder.append(" data-cell-col='").append(this.offset + this.getColIndex()).append("'");
            builder.append(">");
            if (null != this.text) {
                builder.append(this.text);
            }
            builder.append("</td>");
        }
    }

    public String build() {
        StringBuilder builder = new StringBuilder();
        this.build(builder);
        return builder.toString();
    }

    public Td left() {
        Td left = null;
        List<Td> tcs = this.tr.getTds();
        int index = tcs.indexOf(this);
        if (index > 0) {
            left = tcs.get(index - 1);
        }
        return left;
    }

    public Td right() {
        Td right = null;
        List<Td> tcs = this.tr.getTds();
        int index = tcs.indexOf(this);
        if (index < tcs.size() - 1) {
            right = tcs.get(index + 1);
        }
        return right;
    }

    public Td bottom() {
        Td bottom = null;
        Table table = this.tr.getTable();
        List<Tr> trs = table.getTrs();
        int y = trs.indexOf(this.tr);
        if (y < trs.size() - 1) {
            Tr tr = trs.get(y + 1);
            int x = tr.getTds().indexOf(this);
            bottom = tr.getTd(x);
        }
        return bottom;
    }

    public Td top() {
        Td top = null;
        Table table = this.tr.getTable();
        List<Tr> trs = table.getTrs();
        int y = trs.indexOf(this.tr);
        if (y < trs.size() - 1 && y > 0) {
            Tr tr = trs.get(y - 1);
            int x = tr.getTds().indexOf(this);
            top = tr.getTd(x);
        }
        return top;
    }

    public Td removeLeftBorder() {
        this.removeBorder("left");
        Td left = this.left();
        if (null != left) {
            left.removeBorder("right");
        }
        return this;
    }

    public Td removeRightBorder() {
        this.removeBorder("right");
        Td right = this.right();
        if (null != right) {
            right.removeBorder("left");
        }
        return this;
    }

    public Td removeTopBorder() {
        this.removeBorder("top");
        Td top = this.top();
        if (null != top) {
            top.removeBorder("bottom");
        }
        return this;
    }

    public Td removeBottomBorder() {
        this.removeBorder("bottom");
        Td bottom = this.bottom();
        if (null != bottom) {
            bottom.removeBorder("top");
        }
        return this;
    }

    public Td removeTl2brBorder() {
        this.removeBorder("tl2br");
        return this;
    }

    public Td removeTr2blBorder() {
        this.removeBorder("tr2bl");
        return this;
    }

    public Td removeBorder(String side) {
        this.styles.remove("border-" + side + "-size");
        this.styles.remove("border-" + side + "-color");
        this.styles.remove("border-" + side + "-style");
        this.styles.remove("border-" + side);
        return this;
    }

    public Td removeBorder() {
        this.removeLeftBorder();
        this.removeRightBorder();
        this.removeTopBorder();
        this.removeBottomBorder();
        this.removeTl2brBorder();
        this.removeTr2blBorder();
        return this;
    }

    public Td setBorder() {
        this.setLeftBorder();
        this.setRightBorder();
        this.setTopBorder();
        this.setBottomBorder();
        return this;
    }

    public Td setBorder(String weight, String color, String style) {
        this.setLeftBorder(weight, color, style);
        this.setRightBorder(weight, color, style);
        this.setTopBorder(weight, color, style);
        this.setBottomBorder(weight, color, style);
        return this;
    }

    public Td setLeftBorder() {
        this.setBorder("left", "1px", "auto", "single");
        return this;
    }

    public Td setRightBorder() {
        this.setBorder("right", "1px", "auto", "single");
        return this;
    }

    public Td setTopBorder() {
        this.setBorder("top", "1px", "auto", "single");
        return this;
    }

    public Td setBottomBorder() {
        this.setBorder("bottom", "1px", "auto", "single");
        return this;
    }

    public Td setTl2brBorder() {
        this.setBorder("tl2br", "1px", "auto", "single");
        return this;
    }

    public Td setTl2brBorder(String top, String bottom) {
        String text = "<div style='text-align:right'>" + top + "</div><div style='text-align:left'>" + bottom + "</div>";
        this.setText(text);
        this.setBorder("tl2br", "1px", "auto", "single");
        return this;
    }

    public Td setTr2blBorder() {
        this.setBorder("tr2bl", "1px", "auto", "single");
        return this;
    }

    public Td setTr2blBorder(String top, String bottom) {
        String text = "<div style='text-align:left'>" + top + "</div><div style='text-align:right'>" + bottom + "</div>";
        this.setText(text);
        this.setBorder("tr2bl", "1px", "auto", "single");
        return this;
    }

    public Td setLeftBorder(String width, String color, String style) {
        this.setBorder("left", width, color, style);
        return this;
    }

    public Td setLeftBorder(int width, String color, String style) {
        this.setBorder("left", width + this.widthUnit, color, style);
        return this;
    }

    public Td setLeftBorder(double width, String color, String style) {
        this.setBorder("left", width + this.widthUnit, color, style);
        return this;
    }

    public Td setRightBorder(String width, String color, String style) {
        this.setBorder("right", width, color, style);
        return this;
    }

    public Td setRightBorder(int width, String color, String style) {
        this.setBorder("right", width + this.widthUnit, color, style);
        return this;
    }

    public Td setRightBorder(double width, String color, String style) {
        this.setBorder("right", width + this.widthUnit, color, style);
        return this;
    }

    public Td setTopBorder(String width, String color, String style) {
        this.setBorder("top", width, color, style);
        return this;
    }

    public Td setTopBorder(int width, String color, String style) {
        this.setBorder("top", width + this.widthUnit, color, style);
        return this;
    }

    public Td setTopBorder(double width, String color, String style) {
        this.setBorder("top", width + this.widthUnit, color, style);
        return this;
    }

    public Td setBottomBorder(String width, String color, String style) {
        this.setBorder("bottom", width, color, style);
        return this;
    }

    public Td setBottomBorder(int width, String color, String style) {
        this.setBorder("bottom", width + this.widthUnit, color, style);
        return this;
    }

    public Td setBottomBorder(double width, String color, String style) {
        this.setBorder("bottom", width + this.widthUnit, color, style);
        return this;
    }

    public Td setTl2brBorder(String width, String color, String style) {
        this.setBorder("tl2br", width, color, style);
        return this;
    }

    public Td setTl2brBorder(int width, String color, String style) {
        this.setBorder("tl2br", width + this.widthUnit, color, style);
        return this;
    }

    public Td setTl2brBorder(double width, String color, String style) {
        this.setBorder("tl2br", width + this.widthUnit, color, style);
        return this;
    }

    public Td setTr2blBorder(String width, String color, String style) {
        this.setBorder("tr2bl", width, color, style);
        return this;
    }

    public Td setTr2blBorder(int width, String color, String style) {
        this.setBorder("tr2bl", width + this.widthUnit, color, style);
        return this;
    }

    public Td setTr2blBorder(double width, String color, String style) {
        this.setBorder("tr2bl", width + this.widthUnit, color, style);
        return this;
    }

    public Td setBorder(String side, String width, String color, String style) {
        this.styles.put("border-" + side + "-style", style);
        this.styles.put("border-" + side + "-color", color);
        this.styles.put("border-" + side + "-width", width);
        return this;
    }

    public Td setBorder(String side, int width, String color, String style) {
        return this.setBorder(side, width + this.widthUnit, color, style);
    }

    public Td setBorder(String side, double width, String color, String style) {
        return this.setBorder(side, width + this.widthUnit, color, style);
    }

    public Td setColor(String color) {
        this.styles.put("color", color);
        return this;
    }

    public Td setFont(String weight, String eastAsia, String ascii, String hint) {
        this.styles.put("font-weight", weight);
        this.styles.put("font-family-eastAsia", eastAsia);
        this.styles.put("font-family-ascii", ascii);
        this.styles.put("font-family-hint", hint);
        return this;
    }

    public Td setFontSize(String weight) {
        this.styles.put("font-weight", weight);
        return this;
    }

    public Td setFontWeight(String weight) {
        this.styles.put("font-weight", weight);
        return this;
    }

    public Td setFontFamily(String font) {
        this.styles.put("font-family-eastAsia", font);
        this.styles.put("font-family-ascii", font);
        this.styles.put("font-family-hint", font);
        return this;
    }

    public Td setAlign(String align) {
        this.styles.put("text-align", align);
        return this;
    }

    public Td setVerticalAlign(String align) {
        this.styles.put("vertical-align", align);
        return this;
    }

    public Td setBackgroundColor(String color) {
        this.styles.put("background-color", color);
        return this;
    }

    public Td removeStyle() {
        this.styles.clear();
        return this;
    }

    public Td removeBackgroundColor() {
        this.styles.remove("background-color");
        return this;
    }

    public Td removeColor() {
        this.styles.remove("color");
        return this;
    }

    public Td setBold(boolean bold) {
        if (bold) {
            this.styles.put("font-weight", "700");
        } else {
            this.styles.remove("font-weight");
        }
        return this;
    }

    public Td setBold() {
        this.setBold(true);
        return this;
    }

    public Td setUnderline(boolean underline) {
        if (underline) {
            this.styles.put("underline", "true");
        } else {
            this.styles.remove("underline");
        }
        return this;
    }

    public Td setUnderline() {
        this.setUnderline(true);
        return this;
    }

    public Td setStrike(boolean strike) {
        if (strike) {
            this.styles.put("strike", "true");
        } else {
            this.styles.remove("");
        }
        return this;
    }

    public Td setStrike() {
        this.setStrike(true);
        return this;
    }

    public Td setDelete() {
        this.setStrike(true);
        return this;
    }

    public Td setDelete(boolean strike) {
        if (strike) {
            this.styles.put("strike", "true");
        } else {
            this.styles.remove("");
        }
        return this;
    }

    public Td setItalic(boolean italic) {
        if (italic) {
            this.styles.put("italic", "true");
        } else {
            this.styles.remove("italic");
        }
        return this;
    }

    public Td setItalic() {
        return this.setItalic(true);
    }

    public Td setLineHeight(String height) {
        this.styles.put("line-height", height);
        return this;
    }

    public Td setLineHeight(int height) {
        return this.setLineHeight(height + this.widthUnit);
    }

    public Td setLineHeight(double height) {
        return this.setLineHeight(height + this.widthUnit);
    }

    public Td setPadding(String padding) {
        this.styles.put("padding-left", padding);
        this.styles.put("padding-right", padding);
        this.styles.put("padding-top", padding);
        this.styles.put("padding-bottom", padding);
        return this;
    }

    public Td setPadding(int padding) {
        return this.setPadding(padding + this.widthUnit);
    }

    public Td setPadding(double padding) {
        return this.setPadding(padding + this.widthUnit);
    }

    public Td setBottomPadding(String padding) {
        return this.setPadding("bottom", padding);
    }

    public Td setBottomPadding(int padding) {
        return this.setPadding("bottom", padding);
    }

    public Td setBottomPadding(double padding) {
        return this.setPadding("bottom", padding);
    }

    public Td setTopPadding(String padding) {
        return this.setPadding("top", padding);
    }

    public Td setTopPadding(int padding) {
        return this.setPadding("top", padding);
    }

    public Td setTopPadding(double padding) {
        return this.setPadding("top", padding);
    }

    public Td setRightPadding(String padding) {
        return this.setPadding("right", padding);
    }

    public Td setRightPadding(int padding) {
        return this.setPadding("right", padding);
    }

    public Td setRightPadding(double padding) {
        return this.setPadding("right", padding);
    }

    public Td setLeftPadding(String padding) {
        return this.setPadding("left", padding);
    }

    public Td setLeftPadding(int padding) {
        return this.setPadding("left", padding);
    }

    public Td setLeftPadding(double padding) {
        return this.setPadding("left", padding);
    }

    public Td setPadding(String side, String padding) {
        this.styles.put("padding-" + side, padding);
        return this;
    }

    public Td setPadding(String side, int padding) {
        return this.setPadding(side, padding + this.widthUnit);
    }

    public Td setPadding(String side, double padding) {
        return this.setPadding(side, padding + this.widthUnit);
    }

    public String getWidthUnit() {
        return this.widthUnit;
    }

    public void setWidthUnit(String widthUnit) {
        this.widthUnit = widthUnit;
    }

    public void addStyle(String key, String value) {
        this.styles.put(key, value);
    }

    public Td createCopy(boolean style, boolean content) {
        Td copy = new Td();
        copy.setWidthUnit(this.widthUnit);
        if (content) {
            copy.setText(this.text);
        }
        copy.setColspan(this.colspan);
        copy.setRowspan(this.rowspan);
        copy.setWidth(this.width);
        if (style) {
            copy.setClazz(this.clazz);
            List<String> keys = BeanUtil.getMapKeys(this.styles);
            for (String key : keys) {
                copy.addStyle(key, this.styles.get(key));
            }
        }
        return copy;
    }

    public Td createCopy() {
        return this.createCopy(true, false);
    }
}

