/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms;

import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.uri.ConnectionFactoryParser;

public class ActiveMQJMSClient {
    public static ActiveMQConnectionFactory createConnectionFactory(String url, String name) throws Exception {
        ConnectionFactoryParser parser = new ConnectionFactoryParser();
        return (ActiveMQConnectionFactory)parser.newObject(parser.expandURI(url), name);
    }

    public static ActiveMQConnectionFactory createConnectionFactoryWithHA(DiscoveryGroupConfiguration groupConfiguration, JMSFactoryType jmsFactoryType) {
        return jmsFactoryType.createConnectionFactoryWithHA(groupConfiguration);
    }

    public static ActiveMQConnectionFactory createConnectionFactoryWithoutHA(DiscoveryGroupConfiguration groupConfiguration, JMSFactoryType jmsFactoryType) {
        return jmsFactoryType.createConnectionFactoryWithoutHA(groupConfiguration);
    }

    public static ActiveMQConnectionFactory createConnectionFactoryWithHA(JMSFactoryType jmsFactoryType, TransportConfiguration ... initialServers) {
        return jmsFactoryType.createConnectionFactoryWithHA(initialServers);
    }

    public static ActiveMQConnectionFactory createConnectionFactoryWithoutHA(JMSFactoryType jmsFactoryType, TransportConfiguration ... transportConfigurations) {
        return jmsFactoryType.createConnectionFactoryWithoutHA(transportConfigurations);
    }

    public static Topic createTopic(String name) {
        return ActiveMQDestination.createTopic(name);
    }

    public static Queue createQueue(String name) {
        return ActiveMQDestination.createQueue(name);
    }

    private ActiveMQJMSClient() {
    }
}

