/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jndi;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.apache.activemq.artemis.jndi.JNDIStorable;

public class JNDIReferenceFactory
implements ObjectFactory {
    @Override
    public Object getObjectInstance(Object object, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        JNDIStorable result = null;
        if (object instanceof Reference) {
            Reference reference = (Reference)object;
            Class<?> theClass = JNDIReferenceFactory.loadClass(this, reference.getClassName());
            if (JNDIStorable.class.isAssignableFrom(theClass)) {
                JNDIStorable store = (JNDIStorable)theClass.newInstance();
                HashMap<String, String> properties = new HashMap<String, String>();
                Enumeration<RefAddr> iter = reference.getAll();
                while (iter.hasMoreElements()) {
                    StringRefAddr addr = (StringRefAddr)iter.nextElement();
                    properties.put(addr.getType(), addr.getContent() == null ? "" : addr.getContent().toString());
                }
                store.setProperties(properties);
                result = store;
            }
        } else {
            throw new RuntimeException("Object " + object + " is not a reference");
        }
        return result;
    }

    public static Reference createReference(String instanceClassName, JNDIStorable po) throws NamingException {
        Reference result = new Reference(instanceClassName, JNDIReferenceFactory.class.getName(), null);
        try {
            Map<String, String> props = po.getProperties();
            for (Map.Entry<String, String> entry : props.entrySet()) {
                StringRefAddr addr = new StringRefAddr(entry.getKey(), entry.getValue());
                result.add(addr);
            }
        }
        catch (Exception e) {
            throw new NamingException(e.getMessage());
        }
        return result;
    }

    public static Class<?> loadClass(Object thisObj, String className) throws ClassNotFoundException {
        ClassLoader loader = thisObj.getClass().getClassLoader();
        Class<?> theClass = loader != null ? loader.loadClass(className) : Class.forName(className);
        return theClass;
    }
}

