/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import org.apache.activemq.artemis.core.management.impl.view.predicate.ActiveMQFilterPredicate;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServerProducer;

public class ProducerFilterPredicate
extends ActiveMQFilterPredicate<ServerProducer> {
    private Field f;
    private final ActiveMQServer server;

    public ProducerFilterPredicate(ActiveMQServer server) {
        this.server = server;
    }

    @Override
    public boolean apply(ServerProducer producer) {
        if (this.f == null) {
            return true;
        }
        switch (this.f) {
            case ID: {
                return this.matches(producer.getID());
            }
            case CONNECTION_ID: {
                return this.matches(producer.getConnectionID());
            }
            case SESSION_ID: {
                return this.matches(producer.getSessionID());
            }
            case USER: {
                return this.matches(this.server.getSessionByID(producer.getSessionID()).getUsername());
            }
            case ADDRESS: {
                return this.matches(producer.getAddress() != null ? producer.getAddress() : this.server.getSessionByID(producer.getSessionID()).getDefaultAddress());
            }
            case PROTOCOL: {
                return this.matches(producer.getProtocol());
            }
            case CLIENT_ID: {
                return this.matches(this.server.getSessionByID(producer.getSessionID()).getRemotingConnection().getClientID());
            }
            case LOCAL_ADDRESS: {
                return this.matches(this.server.getSessionByID(producer.getSessionID()).getRemotingConnection().getTransportConnection().getLocalAddress());
            }
            case REMOTE_ADDRESS: {
                return this.matches(this.server.getSessionByID(producer.getSessionID()).getRemotingConnection().getTransportConnection().getRemoteAddress());
            }
        }
        return true;
    }

    @Override
    public void setField(String field) {
        if (field != null && !field.equals("")) {
            this.f = Field.valueOf(field.toUpperCase());
        }
    }

    static enum Field {
        ID,
        SESSION_ID,
        CONNECTION_ID,
        ADDRESS,
        USER,
        PROTOCOL,
        CLIENT_ID,
        LOCAL_ADDRESS,
        REMOTE_ADDRESS;

    }
}

