/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueManager;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.utils.ReferenceCounterUtil;

public class QueueManagerImpl
implements QueueManager {
    private final SimpleString queueName;
    private final ActiveMQServer server;
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            Queue queue = QueueManagerImpl.this.server.locateQueue(QueueManagerImpl.this.queueName);
            if (queue == null) {
                if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQServerLogger.LOGGER.debug("pno queue to delete \"" + QueueManagerImpl.this.queueName + ".\"");
                }
                return;
            }
            SimpleString address = queue.getAddress();
            AddressSettings settings = QueueManagerImpl.this.server.getAddressSettingsRepository().getMatch(address.toString());
            long consumerCount = queue.getConsumerCount();
            long messageCount = queue.getMessageCount();
            if (queue.isAutoCreated() && settings.isAutoDeleteQueues() && queue.getMessageCount() == 0L) {
                if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQServerLogger.LOGGER.debug("deleting " + (queue.isAutoCreated() ? "auto-created " : "") + "queue \"" + QueueManagerImpl.this.queueName + ".\" consumerCount = " + consumerCount + "; messageCount = " + messageCount + "; isAutoDeleteQueues = " + settings.isAutoDeleteQueues());
                }
                try {
                    QueueManagerImpl.this.server.destroyQueue(QueueManagerImpl.this.queueName, null, true, false);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorRemovingAutoCreatedQueue(e, QueueManagerImpl.this.queueName);
                }
            } else if (queue.isPurgeOnNoConsumers()) {
                if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQServerLogger.LOGGER.debug("purging queue \"" + QueueManagerImpl.this.queueName + ".\" consumerCount = " + consumerCount + "; messageCount = " + messageCount);
                }
                try {
                    queue.deleteAllReferences();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.failedToPurgeQueue(e, QueueManagerImpl.this.queueName);
                }
            }
        }
    };
    private final ReferenceCounterUtil referenceCounterUtil = new ReferenceCounterUtil(this.runnable);

    public QueueManagerImpl(ActiveMQServer server, SimpleString queueName) {
        this.server = server;
        this.queueName = queueName;
    }

    public int increment() {
        return this.referenceCounterUtil.increment();
    }

    public int decrement() {
        return this.referenceCounterUtil.decrement();
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }
}

