/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.groovy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.atlas.groovy.GroovyExpression;
import org.apache.atlas.groovy.IdentifierExpression;
import org.apache.atlas.groovy.LiteralExpression;

public class GroovyGenerationContext {
    private boolean parametersAllowed = true;
    private int parameterCount = 0;
    private Map<String, Object> parameterValues = new HashMap<String, Object>();
    private StringBuilder generatedQuery = new StringBuilder();

    public void setParametersAllowed(boolean value) {
        this.parametersAllowed = value;
    }

    public GroovyExpression addParameter(Object value) {
        if (this.parametersAllowed) {
            String parameterName = "p" + ++this.parameterCount;
            this.parameterValues.put(parameterName, value);
            return new IdentifierExpression(parameterName);
        }
        LiteralExpression expr = new LiteralExpression(value);
        expr.setTranslateToParameter(false);
        return expr;
    }

    public StringBuilder append(String gremlin) {
        this.generatedQuery.append(gremlin);
        return this.generatedQuery;
    }

    public String getQuery() {
        return this.generatedQuery.toString();
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameterValues);
    }
}

