/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.throttling;

import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.Continuation;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.throttling.ThrottleResponse;
import org.apache.cxf.throttling.ThrottlingManager;

public class ThrottlingInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final Logger LOG = LogUtils.getL7dLogger(ThrottlingInterceptor.class);
    final ThrottlingManager manager;

    public ThrottlingInterceptor(String phase, ThrottlingManager manager) {
        super(ThrottlingInterceptor.class.getName() + "-" + phase, phase);
        this.manager = manager;
    }

    public void handleMessage(Message message) throws Fault {
        ThrottleResponse rsp = this.manager.getThrottleResponse(this.getPhase(), message);
        if (rsp == null) {
            return;
        }
        message.getExchange().put(ThrottleResponse.class, (Object)rsp);
        long l = rsp.getDelay();
        if (l > 0L) {
            ContinuationProvider cp = (ContinuationProvider)message.get(ContinuationProvider.class);
            if (cp == null) {
                LOG.warning("No ContinuationProvider available, sleeping on current thread");
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                return;
            }
            Continuation c = cp.getContinuation();
            c.suspend(l);
        }
    }
}

