/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.throttling;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.throttling.ThrottleResponse;

public class ThrottlingResponseInterceptor
extends AbstractPhaseInterceptor<Message> {
    public ThrottlingResponseInterceptor() {
        super("setup");
    }

    public void handleMessage(Message message) throws Fault {
        ThrottleResponse rsp = (ThrottleResponse)message.getExchange().get(ThrottleResponse.class);
        if (rsp != null) {
            TreeMap<String, ArrayList<String>> headers;
            if (rsp.getResponseCode() > 0) {
                message.put((Object)Message.RESPONSE_CODE, (Object)rsp.getResponseCode());
                if (rsp.getErrorMessage() != null) {
                    message.put((Object)Message.ERROR_MESSAGE, (Object)rsp.getErrorMessage());
                }
            }
            if ((headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)))) == null) {
                headers = new TreeMap<String, ArrayList<String>>(String.CASE_INSENSITIVE_ORDER);
                message.put((Object)Message.PROTOCOL_HEADERS, headers);
            }
            for (Map.Entry<String, String> e : rsp.getResponseHeaders().entrySet()) {
                ArrayList<String> r = (ArrayList<String>)headers.get(e.getKey());
                if (r == null) {
                    r = new ArrayList<String>();
                    headers.put(e.getKey(), r);
                }
                r.add(e.getValue());
            }
        }
    }
}

