/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.util.Objects;
import java.util.Set;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.config.AbstractInterfaceConfig;
import org.apache.dubbo.config.ReferenceConfigBase;
import org.apache.dubbo.config.ServiceConfigBase;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;

public class ServiceModel {
    private String serviceKey;
    private Object proxyObject;
    private Runnable destroyRunner;
    private ClassLoader classLoader;
    private final ClassLoader interfaceClassLoader;
    private final ModuleModel moduleModel;
    private final ServiceDescriptor serviceModel;
    private AbstractInterfaceConfig config;
    private final ServiceMetadata serviceMetadata;

    public ServiceModel(Object proxyObject, String serviceKey, ServiceDescriptor serviceModel, ModuleModel moduleModel, ClassLoader interfaceClassLoader) {
        this(proxyObject, serviceKey, serviceModel, moduleModel, null, interfaceClassLoader);
    }

    public ServiceModel(Object proxyObject, String serviceKey, ServiceDescriptor serviceModel, ModuleModel moduleModel, ServiceMetadata serviceMetadata, ClassLoader interfaceClassLoader) {
        this.proxyObject = proxyObject;
        this.serviceKey = serviceKey;
        this.serviceModel = serviceModel;
        this.moduleModel = ScopeModelUtil.getModuleModel(moduleModel);
        this.serviceMetadata = serviceMetadata;
        this.interfaceClassLoader = interfaceClassLoader;
        if (serviceMetadata != null) {
            serviceMetadata.setServiceModel(this);
        }
        if (interfaceClassLoader != null) {
            this.classLoader = interfaceClassLoader;
        }
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
        }
    }

    @Deprecated
    public AbstractInterfaceConfig getConfig() {
        return this.config;
    }

    @Deprecated
    public void setConfig(AbstractInterfaceConfig config) {
        this.config = config;
    }

    @Deprecated
    public ReferenceConfigBase<?> getReferenceConfig() {
        if (this.config == null) {
            return null;
        }
        if (this.config instanceof ReferenceConfigBase) {
            return (ReferenceConfigBase)this.config;
        }
        throw new IllegalArgumentException("Current ServiceModel is not a ConsumerModel");
    }

    @Deprecated
    public ServiceConfigBase<?> getServiceConfig() {
        if (this.config == null) {
            return null;
        }
        if (this.config instanceof ServiceConfigBase) {
            return (ServiceConfigBase)this.config;
        }
        throw new IllegalArgumentException("Current ServiceModel is not a ProviderModel");
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public void setProxyObject(Object proxyObject) {
        this.proxyObject = proxyObject;
    }

    public Object getProxyObject() {
        return this.proxyObject;
    }

    public ServiceDescriptor getServiceModel() {
        return this.serviceModel;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Set<MethodDescriptor> getAllMethods() {
        return this.serviceModel.getAllMethods();
    }

    public Class<?> getServiceInterfaceClass() {
        return this.serviceModel.getServiceInterfaceClass();
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
        if (this.serviceMetadata != null) {
            this.serviceMetadata.setServiceKey(serviceKey);
            this.serviceMetadata.setGroup(BaseServiceMetadata.groupFromServiceKey(serviceKey));
        }
    }

    public String getServiceName() {
        return this.serviceMetadata.getServiceKey();
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    public ModuleModel getModuleModel() {
        return this.moduleModel;
    }

    public Runnable getDestroyRunner() {
        return this.destroyRunner;
    }

    public void setDestroyRunner(Runnable destroyRunner) {
        this.destroyRunner = destroyRunner;
    }

    public ClassLoader getInterfaceClassLoader() {
        return this.interfaceClassLoader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceModel that = (ServiceModel)o;
        return Objects.equals(this.serviceKey, that.serviceKey) && Objects.equals(this.proxyObject, that.proxyObject) && Objects.equals(this.destroyRunner, that.destroyRunner) && Objects.equals(this.classLoader, that.classLoader) && Objects.equals(this.interfaceClassLoader, that.interfaceClassLoader) && Objects.equals(this.moduleModel, that.moduleModel) && Objects.equals(this.serviceModel, that.serviceModel) && Objects.equals(this.serviceMetadata, that.serviceMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.serviceKey, this.proxyObject, this.destroyRunner, this.classLoader, this.interfaceClassLoader, this.moduleModel, this.serviceModel, this.serviceMetadata);
    }
}

