/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.dubbo.common.config.Configuration;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.PathUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.ReadOnlyServiceNameMapping;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class PropertiesFileServiceNameMapping
extends ReadOnlyServiceNameMapping {
    static final int PRIORITY = -2147483548;
    private final List<Properties> propertiesList = this.loadPropertiesList();

    @Override
    public Set<String> get(org.apache.dubbo.common.URL subscribedURL) {
        Properties properties;
        String propertyKey = this.getPropertyKey(subscribedURL);
        String propertyValue = null;
        Iterator<Properties> iterator = this.propertiesList.iterator();
        while (iterator.hasNext() && (propertyValue = (properties = iterator.next()).getProperty(propertyKey)) == null) {
        }
        return this.getValue(propertyValue);
    }

    private String getPropertyKey(org.apache.dubbo.common.URL url) {
        String protocol = url.getProtocol();
        String serviceInterface = url.getServiceInterface();
        String group = url.getParameter("group");
        String version = url.getParameter("version");
        StringBuilder propertyKeyBuilder = new StringBuilder(protocol).append(":").append(serviceInterface);
        this.appendIfPresent(propertyKeyBuilder, group);
        this.appendIfPresent(propertyKeyBuilder, version);
        return propertyKeyBuilder.toString();
    }

    private void appendIfPresent(StringBuilder builder, String value) {
        if (!StringUtils.isBlank((CharSequence)value)) {
            builder.append(":").append(value);
        }
    }

    private List<Properties> loadPropertiesList() {
        LinkedList<Properties> propertiesList;
        block3: {
            propertiesList = new LinkedList<Properties>();
            String propertiesPath = this.getPropertiesPath();
            try {
                Enumeration<URL> resources = ClassUtils.getClassLoader().getResources(propertiesPath);
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    InputStream inputStream = resource.openStream();
                    Properties properties = new Properties();
                    properties.load(new InputStreamReader(inputStream, "UTF-8"));
                    propertiesList.add(properties);
                }
            }
            catch (IOException e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error(String.format("The path of ServiceNameMapping's Properties file[path : %s] can't be loaded", propertiesPath), (Throwable)e);
            }
        }
        return propertiesList;
    }

    private String getPropertiesPath() {
        Configuration configuration = ApplicationModel.getEnvironment().getConfiguration();
        String propertyPath = configuration.getString("service-name-mapping.properties-path", "META-INF/dubbo/service-name-mapping.properties");
        if ((propertyPath = PathUtils.normalize((String)propertyPath)).startsWith(StringUtils.SLASH)) {
            propertyPath = propertyPath.substring(StringUtils.SLASH.length());
        }
        return propertyPath;
    }

    public int getPriority() {
        return -2147483548;
    }
}

