/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.env;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DubboDefaultPropertiesEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final String PROPERTY_SOURCE_NAME = "defaultProperties";
    public static final String ALLOW_BEAN_DEFINITION_OVERRIDING_PROPERTY = "spring.main.allow-bean-definition-overriding";
    public static final String DUBBO_THREAD_POOL_PROPERTY = "dubbo.protocol.threadpool";
    public static final String VIRTUAL_THREAD = "virtual";
    public static final String SPRING_THREAD_POOL_PROPERTY = "spring.threads.virtual.enabled";
    private static final String ENABLED_VALUE = "true";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        Map<String, Object> defaultProperties = this.createDefaultProperties(environment);
        if (!CollectionUtils.isEmpty(defaultProperties)) {
            this.addOrReplace(propertySources, defaultProperties);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private Map<String, Object> createDefaultProperties(ConfigurableEnvironment environment) {
        HashMap<String, Object> defaultProperties = new HashMap<String, Object>();
        this.setDubboApplicationNameProperty((Environment)environment, defaultProperties);
        this.setDubboConfigMultipleProperty(defaultProperties);
        this.setDubboVirtualThreadsProperty((Environment)environment, defaultProperties);
        return defaultProperties;
    }

    private void setDubboVirtualThreadsProperty(Environment environment, Map<String, Object> defaultProperties) {
        String virtualEnabled = environment.getProperty(SPRING_THREAD_POOL_PROPERTY);
        if (ENABLED_VALUE.equals(virtualEnabled)) {
            defaultProperties.put(DUBBO_THREAD_POOL_PROPERTY, VIRTUAL_THREAD);
        }
    }

    private void setDubboApplicationNameProperty(Environment environment, Map<String, Object> defaultProperties) {
        String springApplicationName = environment.getProperty("spring.application.name");
        if (StringUtils.hasLength((String)springApplicationName) && !environment.containsProperty("dubbo.application.name")) {
            defaultProperties.put("dubbo.application.name", springApplicationName);
        }
    }

    private void setDubboConfigMultipleProperty(Map<String, Object> defaultProperties) {
        defaultProperties.put("dubbo.config.multiple", Boolean.TRUE.toString());
    }

    private void setAllowBeanDefinitionOverriding(Map<String, Object> defaultProperties) {
        defaultProperties.put(ALLOW_BEAN_DEFINITION_OVERRIDING_PROPERTY, Boolean.TRUE.toString());
    }

    private void addOrReplace(MutablePropertySources propertySources, Map<String, Object> map) {
        PropertySource source;
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME) && (source = propertySources.get(PROPERTY_SOURCE_NAME)) instanceof MapPropertySource) {
            target = (MapPropertySource)source;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                if (target.containsProperty(key)) continue;
                ((Map)target.getSource()).put(key, entry.getValue());
            }
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast((PropertySource)target);
        }
    }
}

