/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;

public class TestQuota {
    private void runCommand(DFSAdmin admin, boolean expectError, String ... args) throws Exception {
        this.runCommand(admin, args, expectError);
    }

    private void runCommand(DFSAdmin admin, String[] args, boolean expectEror) throws Exception {
        int val = admin.run(args);
        if (expectEror) {
            Assert.assertEquals((long)val, (long)-1L);
        } else {
            Assert.assertTrue((val >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDSQuotaExceededExceptionIsHumanReadable() throws Exception {
        Integer bytes = 1024;
        try {
            throw new DSQuotaExceededException((long)bytes.intValue(), (long)bytes.intValue());
        }
        catch (DSQuotaExceededException e) {
            Assert.assertEquals((Object)"The DiskSpace quota is exceeded: quota = 1024 B = 1 KB but diskspace consumed = 1024 B = 1 KB", (Object)e.getMessage());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQuotaCommands() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int DEFAULT_BLOCK_SIZE = 512;
        conf.setLong("dfs.blocksize", 512L);
        conf.setInt("dfs.content-summary.limit", 2);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = fs;
        DFSAdmin admin = new DFSAdmin((Configuration)conf);
        try {
            FSDataOutputStream fout;
            int fileLen = 1024;
            int replication = 5;
            long spaceQuota = 9600L;
            Path parent = new Path("/test");
            Assert.assertTrue((boolean)dfs.mkdirs(parent));
            String[] args = new String[]{"-setQuota", "3", parent.toString()};
            this.runCommand(admin, args, false);
            this.runCommand(admin, false, "-setSpaceQuota", "2t", parent.toString());
            Assert.assertEquals((long)0x20000000000L, (long)dfs.getContentSummary(parent).getSpaceQuota());
            this.runCommand(admin, false, "-setSpaceQuota", Long.toString(9600L), parent.toString());
            Path childDir0 = new Path(parent, "data0");
            Assert.assertTrue((boolean)dfs.mkdirs(childDir0));
            Path childFile0 = new Path(parent, "datafile0");
            DFSTestUtil.createFile((FileSystem)fs, childFile0, 1024L, (short)5, 0L);
            ContentSummary c = dfs.getContentSummary(parent);
            Assert.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)3L);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)5120L);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)9600L);
            c = dfs.getContentSummary(childDir0);
            Assert.assertEquals((long)(c.getFileCount() + c.getDirectoryCount()), (long)1L);
            Assert.assertEquals((long)c.getQuota(), (long)-1L);
            c = dfs.getContentSummary(parent);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)5120L);
            Path childDir1 = new Path(parent, "data1");
            boolean hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.mkdirs(childDir1));
            }
            catch (QuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            Path childFile1 = new Path(parent, "datafile1");
            hasException = false;
            try {
                fout = dfs.create(childFile1);
            }
            catch (QuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            this.runCommand(admin, new String[]{"-clrQuota", parent.toString()}, false);
            c = dfs.getContentSummary(parent);
            Assert.assertEquals((long)c.getQuota(), (long)-1L);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)9600L);
            this.runCommand(admin, new String[]{"-clrQuota", childDir0.toString()}, false);
            c = dfs.getContentSummary(childDir0);
            Assert.assertEquals((long)c.getQuota(), (long)-1L);
            fout = dfs.create(childFile1, (short)5);
            try {
                fout.write(new byte[1024]);
                fout.close();
                Assert.fail();
            }
            catch (QuotaExceededException e) {
                IOUtils.closeStream((Closeable)fout);
            }
            dfs.delete(childFile1, false);
            this.runCommand(admin, false, "-clrSpaceQuota", parent.toString());
            c = dfs.getContentSummary(parent);
            Assert.assertEquals((long)c.getQuota(), (long)-1L);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)-1L);
            DFSTestUtil.createFile((FileSystem)dfs, childFile1, 1024L, (short)5, 0L);
            args = new String[]{"-setQuota", "1", parent.toString()};
            this.runCommand(admin, args, false);
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(1024), args[2]);
            args = new String[]{"-setQuota", "1", childDir0.toString()};
            this.runCommand(admin, args, false);
            hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.mkdirs(new Path(childDir0, "in")));
            }
            catch (QuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            c = dfs.getContentSummary(childDir0);
            Assert.assertEquals((long)(c.getDirectoryCount() + c.getFileCount()), (long)1L);
            Assert.assertEquals((long)c.getQuota(), (long)1L);
            Path nonExistentPath = new Path("/test1");
            Assert.assertFalse((boolean)dfs.exists(nonExistentPath));
            args = new String[]{"-setQuota", "1", nonExistentPath.toString()};
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-setSpaceQuota", "1g", nonExistentPath.toString());
            Assert.assertTrue((boolean)dfs.isFile(childFile0));
            args[1] = childFile0.toString();
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-setSpaceQuota", "1t", args[1]);
            args[0] = "-clrQuota";
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-clrSpaceQuota", args[1]);
            args[1] = nonExistentPath.toString();
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-clrSpaceQuota", args[1]);
            args = new String[]{"-setQuota", "0", parent.toString()};
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-setSpaceQuota", "0", args[2]);
            args[1] = "-1";
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-setSpaceQuota", args[1], args[2]);
            args[1] = String.valueOf(Long.MIN_VALUE);
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-setSpaceQuota", args[1], args[2]);
            args[1] = "33aa1.5";
            this.runCommand(admin, args, true);
            this.runCommand(admin, true, "-setSpaceQuota", args[1], args[2]);
            this.runCommand(admin, true, "-setSpaceQuota", "8796093023231m", args[2]);
            String username = "userxx";
            UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"userxx", (String[])new String[]{"groupyy"});
            String[] args2 = (String[])args.clone();
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((Configuration)conf, args2, parent){
                final /* synthetic */ Configuration val$conf;
                final /* synthetic */ String[] val$args2;
                final /* synthetic */ Path val$parent;
                {
                    this.val$conf = configuration;
                    this.val$args2 = stringArray;
                    this.val$parent = path;
                }

                @Override
                public Object run() throws Exception {
                    Assert.assertEquals((String)"Not running as new user", (Object)"userxx", (Object)UserGroupInformation.getCurrentUser().getShortUserName());
                    DFSAdmin userAdmin = new DFSAdmin(this.val$conf);
                    this.val$args2[1] = "100";
                    TestQuota.this.runCommand(userAdmin, this.val$args2, true);
                    TestQuota.this.runCommand(userAdmin, true, new String[]{"-setSpaceQuota", "1g", this.val$args2[2]});
                    String[] args3 = new String[]{"-clrQuota", this.val$parent.toString()};
                    TestQuota.this.runCommand(userAdmin, args3, true);
                    TestQuota.this.runCommand(userAdmin, true, new String[]{"-clrSpaceQuota", args3[1]});
                    return null;
                }
            });
            this.runCommand(admin, true, "-clrQuota", "/");
            this.runCommand(admin, false, "-setQuota", "1000000", "/");
            this.runCommand(admin, true, "-clrQuota", "/");
            this.runCommand(admin, false, "-clrSpaceQuota", "/");
            this.runCommand(admin, new String[]{"-clrQuota", parent.toString()}, false);
            this.runCommand(admin, false, "-clrSpaceQuota", parent.toString());
            Path childDir2 = new Path(parent, "data2");
            Assert.assertTrue((boolean)dfs.mkdirs(childDir2));
            Path childFile2 = new Path(childDir2, "datafile2");
            Path childFile3 = new Path(childDir2, "datafile3");
            long spaceQuota2 = 2560L;
            long fileLen2 = 512L;
            this.runCommand(admin, false, "-setSpaceQuota", Long.toString(2560L), childDir2.toString());
            this.runCommand(admin, false, "-clrSpaceQuota", childDir2.toString());
            DFSTestUtil.createFile((FileSystem)fs, childFile2, 512L, (short)5, 0L);
            this.runCommand(admin, false, "-setSpaceQuota", Long.toString(2560L), childDir2.toString());
            hasException = false;
            try {
                DFSTestUtil.createFile((FileSystem)fs, childFile3, 512L, (short)5, 0L);
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            Path childFile4 = new Path("/", "datafile2");
            Path childFile5 = new Path("/", "datafile3");
            this.runCommand(admin, true, "-clrQuota", "/");
            this.runCommand(admin, false, "-clrSpaceQuota", "/");
            this.runCommand(admin, false, "-setSpaceQuota", Long.toString(2560L), "/");
            this.runCommand(admin, false, "-clrSpaceQuota", "/");
            DFSTestUtil.createFile((FileSystem)fs, childFile4, 512L, (short)5, 0L);
            this.runCommand(admin, false, "-setSpaceQuota", Long.toString(2560L), "/");
            hasException = false;
            try {
                DFSTestUtil.createFile((FileSystem)fs, childFile5, 512L, (short)5, 0L);
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            Assert.assertEquals((long)4L, (long)cluster.getNamesystem().getFSDirectory().getYieldCount());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamespaceCommands() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.content-summary.limit", 2);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem dfs = cluster.getFileSystem();
        try {
            Assert.assertTrue((boolean)dfs.mkdirs(new Path("/nqdir0/qdir1/qdir20/nqdir30")));
            Path quotaDir1 = new Path("/nqdir0/qdir1");
            dfs.setQuota(quotaDir1, 6L, Long.MAX_VALUE);
            ContentSummary c = dfs.getContentSummary(quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            Path quotaDir2 = new Path("/nqdir0/qdir1/qdir20");
            dfs.setQuota(quotaDir2, 7L, Long.MAX_VALUE);
            c = dfs.getContentSummary(quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            Path quotaDir3 = new Path("/nqdir0/qdir1/qdir21");
            Assert.assertTrue((boolean)dfs.mkdirs(quotaDir3));
            dfs.setQuota(quotaDir3, 2L, Long.MAX_VALUE);
            c = dfs.getContentSummary(quotaDir3);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)1L);
            Assert.assertEquals((long)c.getQuota(), (long)2L);
            Path tempPath = new Path(quotaDir3, "nqdir32");
            Assert.assertTrue((boolean)dfs.mkdirs(tempPath));
            c = dfs.getContentSummary(quotaDir3);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
            Assert.assertEquals((long)c.getQuota(), (long)2L);
            tempPath = new Path(quotaDir3, "nqdir33");
            boolean hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.mkdirs(tempPath));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            c = dfs.getContentSummary(quotaDir3);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
            Assert.assertEquals((long)c.getQuota(), (long)2L);
            tempPath = new Path(quotaDir2, "nqdir31");
            Assert.assertTrue((boolean)dfs.mkdirs(tempPath));
            c = dfs.getContentSummary(quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            c = dfs.getContentSummary(quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)6L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            tempPath = new Path(quotaDir2, "nqdir33");
            hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.mkdirs(tempPath));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            tempPath = new Path(quotaDir2, "nqdir30");
            dfs.rename(new Path(quotaDir3, "nqdir32"), tempPath);
            c = dfs.getContentSummary(quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)4L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            c = dfs.getContentSummary(quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)6L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.rename(tempPath, quotaDir3));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            Assert.assertTrue((boolean)dfs.exists(tempPath));
            Assert.assertFalse((boolean)dfs.exists(new Path(quotaDir3, "nqdir30")));
            hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.rename(tempPath, new Path(quotaDir3, "nqdir32")));
            }
            catch (QuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            Assert.assertTrue((boolean)dfs.exists(tempPath));
            Assert.assertFalse((boolean)dfs.exists(new Path(quotaDir3, "nqdir32")));
            Assert.assertTrue((boolean)dfs.rename(tempPath, new Path("/nqdir0")));
            c = dfs.getContentSummary(quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            c = dfs.getContentSummary(quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)4L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            Assert.assertTrue((boolean)dfs.mkdirs(new Path("/nqdir0/nqdir30/nqdir33")));
            hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.rename(new Path("/nqdir0/nqdir30"), tempPath));
            }
            catch (NSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            Assert.assertTrue((boolean)dfs.rename(quotaDir3, quotaDir2));
            c = dfs.getContentSummary(quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)4L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            c = dfs.getContentSummary(quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            tempPath = new Path(quotaDir2, "qdir21");
            c = dfs.getContentSummary(tempPath);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)1L);
            Assert.assertEquals((long)c.getQuota(), (long)2L);
            dfs.delete(tempPath, true);
            c = dfs.getContentSummary(quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)2L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            c = dfs.getContentSummary(quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)3L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            Assert.assertTrue((boolean)dfs.rename(new Path("/nqdir0/nqdir30"), quotaDir2));
            c = dfs.getContentSummary(quotaDir2);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)5L);
            Assert.assertEquals((long)c.getQuota(), (long)7L);
            c = dfs.getContentSummary(quotaDir1);
            Assert.assertEquals((long)c.getDirectoryCount(), (long)6L);
            Assert.assertEquals((long)c.getQuota(), (long)6L);
            Assert.assertEquals((long)14L, (long)cluster.getNamesystem().getFSDirectory().getYieldCount());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpaceCommands() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.blocksize", "512");
        conf.setInt("dfs.content-summary.limit", 2);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Assert.assertTrue((String)("Not a HDFS: " + fs.getUri()), (boolean)(fs instanceof DistributedFileSystem));
        DistributedFileSystem dfs = fs;
        try {
            int fileLen = 1024;
            short replication = 3;
            int fileSpace = fileLen * replication;
            Assert.assertTrue((boolean)dfs.mkdirs(new Path("/nqdir0/qdir1/qdir20/nqdir30")));
            Path quotaDir1 = new Path("/nqdir0/qdir1");
            dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(4 * fileSpace));
            ContentSummary c = dfs.getContentSummary(quotaDir1);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)(4 * fileSpace));
            Path quotaDir20 = new Path("/nqdir0/qdir1/qdir20");
            dfs.setQuota(quotaDir20, Long.MAX_VALUE, (long)(6 * fileSpace));
            c = dfs.getContentSummary(quotaDir20);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)(6 * fileSpace));
            Path quotaDir21 = new Path("/nqdir0/qdir1/qdir21");
            Assert.assertTrue((boolean)dfs.mkdirs(quotaDir21));
            dfs.setQuota(quotaDir21, Long.MAX_VALUE, (long)(2 * fileSpace));
            c = dfs.getContentSummary(quotaDir21);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)(2 * fileSpace));
            Path tempPath = new Path(quotaDir21, "nqdir32");
            Assert.assertTrue((boolean)dfs.mkdirs(tempPath));
            DFSTestUtil.createFile((FileSystem)dfs, new Path(tempPath, "fileDir/file1"), fileLen, replication, 0L);
            c = dfs.getContentSummary(quotaDir21);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
            boolean hasException = false;
            try {
                DFSTestUtil.createFile((FileSystem)dfs, new Path(quotaDir21, "nqdir33/file2"), 2 * fileLen, replication, 0L);
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            Assert.assertTrue((boolean)dfs.delete(new Path(quotaDir21, "nqdir33"), true));
            c = dfs.getContentSummary(quotaDir21);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)(2 * fileSpace));
            c = dfs.getContentSummary(quotaDir20);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)0L);
            Path dstPath = new Path(quotaDir20, "nqdir30");
            Path srcPath = new Path(quotaDir21, "nqdir32");
            Assert.assertTrue((boolean)dfs.rename(srcPath, dstPath));
            c = dfs.getContentSummary(quotaDir20);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
            c = dfs.getContentSummary(quotaDir1);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)fileSpace);
            c = dfs.getContentSummary(quotaDir21);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)0L);
            Path file2 = new Path(dstPath, "fileDir/file2");
            int file2Len = 2 * fileLen;
            DFSTestUtil.createFile((FileSystem)dfs, file2, file2Len, replication, 0L);
            c = dfs.getContentSummary(quotaDir20);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
            c = dfs.getContentSummary(quotaDir21);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)0L);
            hasException = false;
            try {
                Assert.assertFalse((boolean)dfs.rename(dstPath, srcPath));
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            Assert.assertFalse((boolean)dfs.exists(srcPath));
            Assert.assertTrue((boolean)dfs.exists(dstPath));
            c = dfs.getContentSummary(quotaDir20);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
            c = dfs.getContentSummary(quotaDir21);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)0L);
            c = dfs.getContentSummary(quotaDir1);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)(4 * fileSpace));
            c = dfs.getContentSummary(dstPath);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(3 * fileSpace));
            FSDataOutputStream out = dfs.append(file2);
            out.write(new byte[fileLen]);
            out.close();
            file2Len += fileLen;
            c = dfs.getContentSummary(dstPath);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(4 * fileSpace));
            dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(5 * fileSpace));
            out = dfs.append(file2);
            hasException = false;
            try {
                out.write(new byte[fileLen + 1024]);
                out.flush();
                out.close();
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
                IOUtils.closeStream((Closeable)out);
            }
            Assert.assertTrue((boolean)hasException);
            file2Len += fileLen;
            c = dfs.getContentSummary(dstPath);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace));
            dfs.setReplication(file2, (short)(replication - 1));
            c = dfs.getContentSummary(dstPath);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace - file2Len));
            hasException = false;
            try {
                dfs.setReplication(file2, (short)(replication + 1));
            }
            catch (DSQuotaExceededException e) {
                hasException = true;
            }
            Assert.assertTrue((boolean)hasException);
            c = dfs.getContentSummary(dstPath);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace - file2Len));
            dfs.setQuota(quotaDir1, Long.MAX_VALUE, (long)(10 * fileSpace));
            dfs.setQuota(quotaDir20, Long.MAX_VALUE, (long)(10 * fileSpace));
            dfs.setReplication(file2, (short)(replication + 1));
            c = dfs.getContentSummary(dstPath);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(5 * fileSpace + file2Len));
            Path quotaDir2053 = new Path("/hdfs-2053");
            Assert.assertTrue((boolean)dfs.mkdirs(quotaDir2053));
            Path quotaDir2053_A = new Path(quotaDir2053, "A");
            Assert.assertTrue((boolean)dfs.mkdirs(quotaDir2053_A));
            Path quotaDir2053_B = new Path(quotaDir2053, "B");
            Assert.assertTrue((boolean)dfs.mkdirs(quotaDir2053_B));
            Path quotaDir2053_C = new Path(quotaDir2053, "C");
            Assert.assertTrue((boolean)dfs.mkdirs(quotaDir2053_C));
            int sizeFactorA = 1;
            int sizeFactorB = 2;
            int sizeFactorC = 4;
            dfs.setQuota(quotaDir2053_C, Long.MAX_VALUE, (long)((sizeFactorC + 1) * fileSpace));
            c = dfs.getContentSummary(quotaDir2053_C);
            Assert.assertEquals((long)c.getSpaceQuota(), (long)((sizeFactorC + 1) * fileSpace));
            DFSTestUtil.createFile((FileSystem)dfs, new Path(quotaDir2053_A, "fileA"), sizeFactorA * fileLen, replication, 0L);
            c = dfs.getContentSummary(quotaDir2053_A);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(sizeFactorA * fileSpace));
            DFSTestUtil.createFile((FileSystem)dfs, new Path(quotaDir2053_B, "fileB"), sizeFactorB * fileLen, replication, 0L);
            c = dfs.getContentSummary(quotaDir2053_B);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(sizeFactorB * fileSpace));
            DFSTestUtil.createFile((FileSystem)dfs, new Path(quotaDir2053_C, "fileC"), sizeFactorC * fileLen, replication, 0L);
            c = dfs.getContentSummary(quotaDir2053_C);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)(sizeFactorC * fileSpace));
            c = dfs.getContentSummary(quotaDir2053);
            Assert.assertEquals((long)c.getSpaceConsumed(), (long)((sizeFactorA + sizeFactorB + sizeFactorC) * fileSpace));
            Assert.assertEquals((long)20L, (long)cluster.getNamesystem().getFSDirectory().getYieldCount());
        }
        finally {
            cluster.shutdown();
        }
    }

    private static void checkContentSummary(ContentSummary expected, ContentSummary computed) {
        Assert.assertEquals((Object)expected.toString(), (Object)computed.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockAllocationAdjustsUsageConservatively() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int BLOCK_SIZE = 6144;
        conf.setInt("dfs.blocksize", 6144);
        conf.setBoolean("dfs.webhdfs.enabled", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        DFSAdmin admin = new DFSAdmin((Configuration)conf);
        String nnAddr = conf.get("dfs.namenode.http-address");
        String webhdfsuri = "webhdfs://" + nnAddr;
        System.out.println("webhdfsuri=" + webhdfsuri);
        FileSystem webhdfs = new Path(webhdfsuri).getFileSystem((Configuration)conf);
        try {
            Path dir = new Path("/test");
            Path file1 = new Path("/test/test1");
            Path file2 = new Path("/test/test2");
            boolean exceededQuota = false;
            int QUOTA_SIZE = 18432;
            int FILE_SIZE = 3072;
            Assert.assertTrue((boolean)fs.mkdirs(dir));
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(18432), dir.toString());
            DFSTestUtil.createFile((FileSystem)fs, file1, 3072L, (short)3, 1L);
            DFSTestUtil.waitReplication((FileSystem)fs, file1, (short)3);
            ContentSummary c = fs.getContentSummary(dir);
            TestQuota.checkContentSummary(c, webhdfs.getContentSummary(dir));
            Assert.assertEquals((String)"Quota is half consumed", (long)9216L, (long)c.getSpaceConsumed());
            try {
                DFSTestUtil.createFile((FileSystem)fs, file2, 3072L, (short)3, 1L);
            }
            catch (QuotaExceededException e) {
                exceededQuota = true;
            }
            Assert.assertTrue((String)"Quota not exceeded", (boolean)exceededQuota);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleFilesSmallerThanOneBlock() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        int BLOCK_SIZE = 6144;
        conf.setInt("dfs.blocksize", 6144);
        conf.setBoolean("dfs.webhdfs.enabled", true);
        conf.setInt("dfs.content-summary.limit", 2);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        DFSAdmin admin = new DFSAdmin((Configuration)conf);
        String nnAddr = conf.get("dfs.namenode.http-address");
        String webhdfsuri = "webhdfs://" + nnAddr;
        System.out.println("webhdfsuri=" + webhdfsuri);
        FileSystem webhdfs = new Path(webhdfsuri).getFileSystem((Configuration)conf);
        try {
            Path dir = new Path("/test");
            boolean exceededQuota = false;
            int FILE_SIZE = 1024;
            int QUOTA_SIZE = 32 * (int)fs.getDefaultBlockSize(dir);
            Assert.assertEquals((long)6144L, (long)fs.getDefaultBlockSize(dir));
            Assert.assertEquals((long)196608L, (long)QUOTA_SIZE);
            Assert.assertTrue((boolean)fs.mkdirs(dir));
            this.runCommand(admin, false, "-setSpaceQuota", Integer.toString(QUOTA_SIZE), dir.toString());
            for (int i = 0; i < 59; ++i) {
                Path file = new Path("/test/test" + i);
                DFSTestUtil.createFile((FileSystem)fs, file, 1024L, (short)3, 1L);
                DFSTestUtil.waitReplication((FileSystem)fs, file, (short)3);
            }
            ContentSummary c = fs.getContentSummary(dir);
            TestQuota.checkContentSummary(c, webhdfs.getContentSummary(dir));
            Assert.assertEquals((String)"Invalid space consumed", (long)181248L, (long)c.getSpaceConsumed());
            Assert.assertEquals((String)"Invalid space consumed", (long)(QUOTA_SIZE - 181248), (long)(3L * (fs.getDefaultBlockSize(dir) - 1024L)));
            try {
                Path file = new Path("/test/test59");
                DFSTestUtil.createFile((FileSystem)fs, file, 1024L, (short)3, 1L);
                DFSTestUtil.waitReplication((FileSystem)fs, file, (short)3);
            }
            catch (QuotaExceededException e) {
                exceededQuota = true;
            }
            Assert.assertTrue((String)"Quota not exceeded", (boolean)exceededQuota);
            Assert.assertEquals((long)2L, (long)cluster.getNamesystem().getFSDirectory().getYieldCount());
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHugeFileCount() throws IOException {
        MiniDFSCluster cluster = null;
        Configuration conf = new Configuration();
        conf.setInt("dfs.content-summary.limit", 4);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            DistributedFileSystem dfs = cluster.getFileSystem();
            for (int i = 1; i <= 5; ++i) {
                FSDataOutputStream out = dfs.create(new Path("/Folder1/file" + i), (short)1);
                out.close();
            }
            FSDataOutputStream out = dfs.create(new Path("/Folder2/file6"), (short)1);
            out.close();
            ContentSummary contentSummary = dfs.getContentSummary(new Path("/"));
            Assert.assertEquals((long)6L, (long)contentSummary.getFileCount());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
                cluster = null;
            }
        }
    }
}

