/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.ChunkChecksum;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInPipelineInterface;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.ReplicaOutputStreams;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DataChecksum;

public class ReplicaInPipeline
extends ReplicaInfo
implements ReplicaInPipelineInterface {
    private long bytesAcked;
    private long bytesOnDisk;
    private byte[] lastChecksum;
    private AtomicReference<Thread> writer = new AtomicReference();
    private long bytesReserved;
    private final long originalBytesReserved;

    public ReplicaInPipeline(long blockId, long genStamp, FsVolumeSpi vol, File dir, long bytesToReserve) {
        this(blockId, 0L, genStamp, vol, dir, Thread.currentThread(), bytesToReserve);
    }

    ReplicaInPipeline(Block block, FsVolumeSpi vol, File dir, Thread writer) {
        this(block.getBlockId(), block.getNumBytes(), block.getGenerationStamp(), vol, dir, writer, 0L);
    }

    ReplicaInPipeline(long blockId, long len, long genStamp, FsVolumeSpi vol, File dir, Thread writer, long bytesToReserve) {
        super(blockId, len, genStamp, vol, dir);
        this.bytesAcked = len;
        this.bytesOnDisk = len;
        this.writer.set(writer);
        this.bytesReserved = bytesToReserve;
        this.originalBytesReserved = bytesToReserve;
    }

    public ReplicaInPipeline(ReplicaInPipeline from) {
        super(from);
        this.bytesAcked = from.getBytesAcked();
        this.bytesOnDisk = from.getBytesOnDisk();
        this.writer.set(from.writer.get());
        this.bytesReserved = from.bytesReserved;
        this.originalBytesReserved = from.originalBytesReserved;
    }

    @Override
    public long getVisibleLength() {
        return -1L;
    }

    @Override
    public HdfsServerConstants.ReplicaState getState() {
        return HdfsServerConstants.ReplicaState.TEMPORARY;
    }

    @Override
    public long getBytesAcked() {
        return this.bytesAcked;
    }

    @Override
    public void setBytesAcked(long bytesAcked) {
        long newBytesAcked = bytesAcked - this.bytesAcked;
        this.bytesAcked = bytesAcked;
        this.getVolume().releaseReservedSpace(newBytesAcked);
        this.bytesReserved -= newBytesAcked;
    }

    @Override
    public long getBytesOnDisk() {
        return this.bytesOnDisk;
    }

    @Override
    public long getBytesReserved() {
        return this.bytesReserved;
    }

    @Override
    public long getOriginalBytesReserved() {
        return this.originalBytesReserved;
    }

    @Override
    public void releaseAllBytesReserved() {
        this.getVolume().releaseReservedSpace(this.bytesReserved);
        this.getVolume().releaseLockedMemory(this.bytesReserved);
        this.bytesReserved = 0L;
    }

    @Override
    public synchronized void setLastChecksumAndDataLen(long dataLength, byte[] lastChecksum) {
        this.bytesOnDisk = dataLength;
        this.lastChecksum = lastChecksum;
    }

    @Override
    public synchronized ChunkChecksum getLastChecksumAndDataLen() {
        return new ChunkChecksum(this.getBytesOnDisk(), this.lastChecksum);
    }

    public void interruptThread() {
        Thread thread = this.writer.get();
        if (thread != null && thread != Thread.currentThread() && thread.isAlive()) {
            thread.interrupt();
        }
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public boolean attemptToSetWriter(Thread prevWriter, Thread newWriter) {
        return this.writer.compareAndSet(prevWriter, newWriter);
    }

    /*
     * Exception decompiling
     */
    public void stopWriter(long xceiverStopTimeout) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicaOutputStreams createStreams(boolean isCreate, DataChecksum requestedChecksum) throws IOException {
        DataChecksum checksum;
        File blockFile = this.getBlockFile();
        File metaFile = this.getMetaFile();
        if (DataNode.LOG.isDebugEnabled()) {
            DataNode.LOG.debug("writeTo blockfile is " + blockFile + " of size " + blockFile.length());
            DataNode.LOG.debug("writeTo metafile is " + metaFile + " of size " + metaFile.length());
        }
        long blockDiskSize = 0L;
        long crcDiskSize = 0L;
        RandomAccessFile metaRAF = new RandomAccessFile(metaFile, "rw");
        if (!isCreate) {
            boolean checkedMeta = false;
            try {
                BlockMetadataHeader header = BlockMetadataHeader.readHeader((RandomAccessFile)metaRAF);
                checksum = header.getChecksum();
                if (checksum.getBytesPerChecksum() != requestedChecksum.getBytesPerChecksum()) {
                    throw new IOException("Client requested checksum " + requestedChecksum + " when appending to an existing block " + "with different chunk size: " + checksum);
                }
                int bytesPerChunk = checksum.getBytesPerChecksum();
                int checksumSize = checksum.getChecksumSize();
                blockDiskSize = this.bytesOnDisk;
                crcDiskSize = (long)BlockMetadataHeader.getHeaderSize() + (blockDiskSize + (long)bytesPerChunk - 1L) / (long)bytesPerChunk * (long)checksumSize;
                if (blockDiskSize > 0L && (blockDiskSize > blockFile.length() || crcDiskSize > metaFile.length())) {
                    throw new IOException("Corrupted block: " + this);
                }
                checkedMeta = true;
            }
            finally {
                if (!checkedMeta) {
                    IOUtils.closeStream((Closeable)metaRAF);
                }
            }
        } else {
            checksum = requestedChecksum;
        }
        FileOutputStream blockOut = null;
        FileOutputStream crcOut = null;
        try {
            blockOut = new FileOutputStream(new RandomAccessFile(blockFile, "rw").getFD());
            crcOut = new FileOutputStream(metaRAF.getFD());
            if (!isCreate) {
                blockOut.getChannel().position(blockDiskSize);
                crcOut.getChannel().position(crcDiskSize);
            }
            return new ReplicaOutputStreams(blockOut, crcOut, checksum, this.getVolume().isTransientStorage());
        }
        catch (IOException e) {
            IOUtils.closeStream(blockOut);
            IOUtils.closeStream((Closeable)metaRAF);
            throw e;
        }
    }

    @Override
    public OutputStream createRestartMetaStream() throws IOException {
        File blockFile = this.getBlockFile();
        File restartMeta = new File(blockFile.getParent() + File.pathSeparator + "." + blockFile.getName() + ".restart");
        if (restartMeta.exists() && !restartMeta.delete()) {
            DataNode.LOG.warn("Failed to delete restart meta file: " + restartMeta.getPath());
        }
        return new FileOutputStream(restartMeta);
    }

    @Override
    public String toString() {
        return super.toString() + "\n  bytesAcked=" + this.bytesAcked + "\n  bytesOnDisk=" + this.bytesOnDisk;
    }
}

