/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.client.impl.metrics.BlockReaderIoProvider;
import org.apache.hadoop.hdfs.client.impl.metrics.BlockReaderLocalMetrics;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricsTestHelper;
import org.apache.hadoop.metrics2.lib.MutableRollingAverages;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestBlockReaderLocalMetrics {
    private static final long ROLLING_AVERAGES_WINDOW_LENGTH_MS = 1000L;
    private static final int ROLLING_AVERAGE_NUM_WINDOWS = 5;
    private static final long SLOW_READ_DELAY = 2000L;
    private static final String SHORT_CIRCUIT_READ_METRIC_REGISTERED_NAME = "HdfsShortCircuitReads";
    private static final String SHORT_CIRCUIT_LOCAL_READS_METRIC_VALUE_FULL_NAME = "[ShortCircuitLocalReads]RollingAvgLatencyMs";
    private static final FakeTimer TIMER = new FakeTimer();
    private static HdfsConfiguration conf = new HdfsConfiguration();
    private static DfsClientConf clientConf;

    @Test(timeout=300000L)
    public void testSlowShortCircuitReadsStatsRecorded() throws IOException, InterruptedException, TimeoutException {
        final BlockReaderLocalMetrics metrics = BlockReaderLocalMetrics.create();
        final MutableRollingAverages shortCircuitReadRollingAverages = metrics.getShortCircuitReadRollingAverages();
        MetricsTestHelper.replaceRollingAveragesScheduler((MutableRollingAverages)shortCircuitReadRollingAverages, (int)5, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        FileChannel dataIn = (FileChannel)Mockito.mock(FileChannel.class);
        Mockito.when((Object)dataIn.read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                TIMER.advance(2000L);
                return 0;
            }
        });
        BlockReaderIoProvider blockReaderIoProvider = new BlockReaderIoProvider(clientConf.getShortCircuitConf(), metrics, (Timer)TIMER);
        blockReaderIoProvider.read(dataIn, (ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        blockReaderIoProvider.read(dataIn, (ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                metrics.collectThreadLocalStates();
                return shortCircuitReadRollingAverages.getStats(0L).size() > 0;
            }
        }, (long)500L, (long)10000L);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)SHORT_CIRCUIT_READ_METRIC_REGISTERED_NAME);
        double averageLatency = MetricsAsserts.getDoubleGauge((String)SHORT_CIRCUIT_LOCAL_READS_METRIC_VALUE_FULL_NAME, (MetricsRecordBuilder)rb);
        Assert.assertTrue((String)"Average Latency of Short Circuit Reads lower than expected", (averageLatency >= 2000.0 ? 1 : 0) != 0);
    }

    @Test(timeout=300000L)
    public void testMutlipleBlockReaderIoProviderStats() throws IOException, InterruptedException, TimeoutException {
        final BlockReaderLocalMetrics metrics = BlockReaderLocalMetrics.create();
        final MutableRollingAverages shortCircuitReadRollingAverages = metrics.getShortCircuitReadRollingAverages();
        MetricsTestHelper.replaceRollingAveragesScheduler((MutableRollingAverages)shortCircuitReadRollingAverages, (int)5, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        FileChannel dataIn1 = (FileChannel)Mockito.mock(FileChannel.class);
        FileChannel dataIn2 = (FileChannel)Mockito.mock(FileChannel.class);
        Mockito.when((Object)dataIn1.read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                TIMER.advance(2000L);
                return 0;
            }
        });
        Mockito.when((Object)dataIn2.read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                TIMER.advance(6000L);
                return 0;
            }
        });
        BlockReaderIoProvider blockReaderIoProvider1 = new BlockReaderIoProvider(clientConf.getShortCircuitConf(), metrics, (Timer)TIMER);
        BlockReaderIoProvider blockReaderIoProvider2 = new BlockReaderIoProvider(clientConf.getShortCircuitConf(), metrics, (Timer)TIMER);
        blockReaderIoProvider1.read(dataIn1, (ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        blockReaderIoProvider2.read(dataIn2, (ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                metrics.collectThreadLocalStates();
                return shortCircuitReadRollingAverages.getStats(0L).size() > 0;
            }
        }, (long)500L, (long)10000L);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)SHORT_CIRCUIT_READ_METRIC_REGISTERED_NAME);
        double averageLatency = MetricsAsserts.getDoubleGauge((String)SHORT_CIRCUIT_LOCAL_READS_METRIC_VALUE_FULL_NAME, (MetricsRecordBuilder)rb);
        Assert.assertTrue((String)"Average Latency of Short Circuit Reads lower than expected", (averageLatency >= 4000.0 ? 1 : 0) != 0);
    }

    @Test(timeout=300000L)
    public void testSlowShortCircuitReadsAverageLatencyValue() throws IOException, InterruptedException, TimeoutException {
        final BlockReaderLocalMetrics metrics = BlockReaderLocalMetrics.create();
        final MutableRollingAverages shortCircuitReadRollingAverages = metrics.getShortCircuitReadRollingAverages();
        MetricsTestHelper.replaceRollingAveragesScheduler((MutableRollingAverages)shortCircuitReadRollingAverages, (int)5, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        Random random = new Random();
        FileChannel[] dataIns = new FileChannel[5];
        long totalDelay = 0L;
        for (int i = 0; i < 5; ++i) {
            dataIns[i] = (FileChannel)Mockito.mock(FileChannel.class);
            final long delay = 2000L * (long)random.nextInt(5);
            Mockito.when((Object)dataIns[i].read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).thenAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocation) throws Throwable {
                    TIMER.advance(delay);
                    return 0;
                }
            });
            totalDelay += delay;
        }
        long expectedAvgLatency = totalDelay / 5L;
        BlockReaderIoProvider blockReaderIoProvider = new BlockReaderIoProvider(clientConf.getShortCircuitConf(), metrics, (Timer)TIMER);
        for (int i = 0; i < 5; ++i) {
            blockReaderIoProvider.read(dataIns[i], (ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        }
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                metrics.collectThreadLocalStates();
                return shortCircuitReadRollingAverages.getStats(0L).size() > 0;
            }
        }, (long)500L, (long)10000L);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)SHORT_CIRCUIT_READ_METRIC_REGISTERED_NAME);
        double averageLatency = MetricsAsserts.getDoubleGauge((String)SHORT_CIRCUIT_LOCAL_READS_METRIC_VALUE_FULL_NAME, (MetricsRecordBuilder)rb);
        Assert.assertTrue((String)"Average Latency of Short Circuit Reads lower than expected", (averageLatency >= (double)expectedAvgLatency ? 1 : 0) != 0);
    }

    static {
        conf = new HdfsConfiguration();
        conf.setInt("dfs.client.read.shortcircuit.metrics.sampling.percentage", 100);
        clientConf = new DfsClientConf((Configuration)conf);
    }
}

