/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.InternalDataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.TestBlockRecovery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataNodeReconfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(TestBlockRecovery.class);
    private static final String DATA_DIR = MiniDFSCluster.getBaseDirectory() + "data";
    private static final InetSocketAddress NN_ADDR = new InetSocketAddress("localhost", 5020);
    private final int NUM_NAME_NODE = 1;
    private final int NUM_DATA_NODE = 10;
    private MiniDFSCluster cluster;

    @Before
    public void Setup() throws IOException {
        this.startDFSCluster(1, 10);
    }

    @After
    public void tearDown() throws Exception {
        File dir;
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
        if ((dir = new File(DATA_DIR)).exists()) {
            Assert.assertTrue((String)"Cannot delete data-node dirs", (boolean)FileUtil.fullyDelete((File)dir));
        }
    }

    private void startDFSCluster(int numNameNodes, int numDataNodes) throws IOException {
        Configuration conf = new Configuration();
        MiniDFSNNTopology nnTopology = MiniDFSNNTopology.simpleFederatedTopology(numNameNodes);
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(nnTopology).numDataNodes(numDataNodes).build();
        this.cluster.waitActive();
    }

    public DataNode[] createDNsForTest(int numDateNode) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.datanode.data.dir", DATA_DIR);
        conf.set("dfs.datanode.address", "0.0.0.0:0");
        conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        conf.setInt("ipc.client.connect.max.retries", 0);
        DataNode[] result = new DataNode[numDateNode];
        for (int i = 0; i < numDateNode; ++i) {
            result[i] = InternalDataNodeTestUtils.startDNWithMockNN((Configuration)conf, NN_ADDR, DATA_DIR);
        }
        return result;
    }

    @Test
    public void testMaxConcurrentMoversReconfiguration() throws ReconfigurationException, IOException {
        int maxConcurrentMovers = 10;
        for (int i = 0; i < 10; ++i) {
            DataNode dn = this.cluster.getDataNodes().get(i);
            try {
                dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", "text");
                Assert.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting NumberFormatException", (boolean)(expected.getCause() instanceof NumberFormatException));
            }
            try {
                dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", String.valueOf(-1));
                Assert.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting IllegalArgumentException", (boolean)(expected.getCause() instanceof IllegalArgumentException));
            }
            try {
                dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", String.valueOf(0));
                Assert.fail((String)"ReconfigurationException expected");
            }
            catch (ReconfigurationException expected) {
                Assert.assertTrue((String)"expecting IllegalArgumentException", (boolean)(expected.getCause() instanceof IllegalArgumentException));
            }
            dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", String.valueOf(maxConcurrentMovers));
            Assert.assertEquals((String)String.format("%s has wrong value", "dfs.datanode.balance.max.concurrent.moves"), (long)maxConcurrentMovers, (long)dn.xserver.balanceThrottler.getMaxConcurrentMovers());
            Assert.assertEquals((String)String.format("%s has wrong value", "dfs.datanode.balance.max.concurrent.moves"), (long)maxConcurrentMovers, (long)Integer.parseInt(dn.getConf().get("dfs.datanode.balance.max.concurrent.moves")));
            dn.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", null);
            Assert.assertEquals((String)String.format("%s has wrong value", "dfs.datanode.balance.max.concurrent.moves"), (long)100L, (long)dn.xserver.balanceThrottler.getMaxConcurrentMovers());
            Assert.assertEquals((String)String.format("expect %s is not configured", "dfs.datanode.balance.max.concurrent.moves"), null, (Object)dn.getConf().get("dfs.datanode.balance.max.concurrent.moves"));
        }
    }

    @Test
    public void testAcquireWithMaxConcurrentMoversGreaterThanDefault() throws IOException, ReconfigurationException {
        DataNode[] dns = this.createDNsForTest(1);
        try {
            this.testAcquireOnMaxConcurrentMoversReconfiguration(dns[0], 10);
        }
        finally {
            dns[0].shutdown();
        }
    }

    @Test
    public void testAcquireWithMaxConcurrentMoversLessThanDefault() throws IOException, ReconfigurationException {
        DataNode[] dns = this.createDNsForTest(1);
        try {
            this.testAcquireOnMaxConcurrentMoversReconfiguration(dns[0], 3);
        }
        finally {
            dns[0].shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedDecreaseConcurrentMovers() throws IOException, ReconfigurationException {
        DataNode[] dns = this.createDNsForTest(1);
        DataNode dataNode = dns[0];
        try {
            dataNode.xserver.updateBalancerMaxConcurrentMovers(2);
            dataNode.xserver.balanceThrottler.acquire();
            dataNode.xserver.balanceThrottler.acquire();
            dataNode.xserver.setMaxReconfigureWaitTime(1);
            boolean success = dataNode.xserver.updateBalancerMaxConcurrentMovers(1);
            Assert.assertFalse((boolean)success);
        }
        finally {
            dataNode.shutdown();
        }
    }

    @Test(expected=ReconfigurationException.class)
    public void testFailedDecreaseConcurrentMoversReconfiguration() throws IOException, ReconfigurationException {
        DataNode[] dns = this.createDNsForTest(1);
        DataNode dataNode = dns[0];
        try {
            dataNode.xserver.updateBalancerMaxConcurrentMovers(2);
            dataNode.xserver.balanceThrottler.acquire();
            dataNode.xserver.balanceThrottler.acquire();
            dataNode.xserver.setMaxReconfigureWaitTime(1);
            dataNode.reconfigurePropertyImpl("dfs.datanode.balance.max.concurrent.moves", "1");
        }
        catch (ReconfigurationException e) {
            Assert.assertEquals((Object)"dfs.datanode.balance.max.concurrent.moves", (Object)e.getProperty());
            Assert.assertEquals((Object)"1", (Object)e.getNewValue());
            throw e;
        }
        finally {
            dataNode.shutdown();
        }
    }

    private void testAcquireOnMaxConcurrentMoversReconfiguration(DataNode dataNode, int maxConcurrentMovers) throws IOException, ReconfigurationException {
        int i;
        int defaultMaxThreads = dataNode.getConf().getInt("dfs.datanode.balance.max.concurrent.moves", 100);
        for (i = 0; i < defaultMaxThreads; ++i) {
            Assert.assertEquals((String)"should be able to get thread quota", (Object)true, (Object)dataNode.xserver.balanceThrottler.acquire());
        }
        Assert.assertEquals((String)"should not be able to get thread quota", (Object)false, (Object)dataNode.xserver.balanceThrottler.acquire());
        for (i = 0; i < defaultMaxThreads; ++i) {
            dataNode.xserver.balanceThrottler.release();
        }
        dataNode.reconfigureProperty("dfs.datanode.balance.max.concurrent.moves", String.valueOf(maxConcurrentMovers));
        Assert.assertEquals((String)"thread quota is wrong", (long)maxConcurrentMovers, (long)dataNode.xserver.balanceThrottler.getMaxConcurrentMovers());
        for (i = 0; i < maxConcurrentMovers; ++i) {
            Assert.assertEquals((String)"should be able to get thread quota", (Object)true, (Object)dataNode.xserver.balanceThrottler.acquire());
        }
        Assert.assertEquals((String)"should not be able to get thread quota", (Object)false, (Object)dataNode.xserver.balanceThrottler.acquire());
    }
}

