/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.checker;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hdfs.server.datanode.checker.Checkable;
import org.apache.hadoop.hdfs.server.datanode.checker.ThrottledAsyncChecker;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestThrottledAsyncCheckerTimeout {
    public static final Logger LOG = LoggerFactory.getLogger(TestThrottledAsyncCheckerTimeout.class);
    @Rule
    public TestName testName = new TestName();
    @Rule
    public Timeout testTimeout = new Timeout(300000);
    private static final long DISK_CHECK_TIMEOUT = 10L;
    private ReentrantLock lock;

    private ExecutorService getExecutorService() {
        return new ScheduledThreadPoolExecutor(1);
    }

    @Before
    public void initializeLock() {
        this.lock = new ReentrantLock();
    }

    @Test
    public void testDiskCheckTimeout() throws Exception {
        LOG.info("Executing {}", (Object)this.testName.getMethodName());
        DummyCheckable target = new DummyCheckable();
        FakeTimer timer = new FakeTimer();
        ThrottledAsyncChecker checker = new ThrottledAsyncChecker((Timer)timer, 0L, 10L, this.getExecutorService());
        this.lock.lock();
        Optional olf = checker.schedule((Checkable)target, (Object)true);
        final AtomicLong numCallbackInvocationsSuccess = new AtomicLong(0L);
        final AtomicLong numCallbackInvocationsFailure = new AtomicLong(0L);
        final AtomicBoolean callbackResult = new AtomicBoolean(false);
        final Throwable[] throwable = new Throwable[1];
        Assert.assertTrue((boolean)olf.isPresent());
        Futures.addCallback((ListenableFuture)((ListenableFuture)olf.get()), (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                numCallbackInvocationsSuccess.incrementAndGet();
                callbackResult.set(true);
            }

            public void onFailure(Throwable t) {
                throwable[0] = t;
                numCallbackInvocationsFailure.incrementAndGet();
                callbackResult.set(true);
            }
        }, (Executor)MoreExecutors.directExecutor());
        while (!callbackResult.get()) {
            Thread.sleep(10L);
        }
        this.lock.unlock();
        Assert.assertThat((Object)numCallbackInvocationsFailure.get(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)numCallbackInvocationsSuccess.get(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertTrue((boolean)(throwable[0] instanceof TimeoutException));
    }

    @Test
    public void testDiskCheckTimeoutInvokesOneCallbackOnly() throws Exception {
        LOG.info("Executing {}", (Object)this.testName.getMethodName());
        DummyCheckable target = new DummyCheckable();
        FakeTimer timer = new FakeTimer();
        ThrottledAsyncChecker checker = new ThrottledAsyncChecker((Timer)timer, 0L, 10L, this.getExecutorService());
        FutureCallback futureCallback = (FutureCallback)Mockito.mock(FutureCallback.class);
        this.lock.lock();
        Optional olf1 = checker.schedule((Checkable)target, (Object)true);
        Assert.assertTrue((boolean)olf1.isPresent());
        Futures.addCallback((ListenableFuture)((ListenableFuture)olf1.get()), (FutureCallback)futureCallback, (Executor)MoreExecutors.directExecutor());
        ((FutureCallback)Mockito.verify((Object)futureCallback, (VerificationMode)Mockito.timeout((long)100L).times(1))).onFailure((Throwable)ArgumentMatchers.any());
        ((FutureCallback)Mockito.verify((Object)futureCallback, (VerificationMode)Mockito.timeout((long)100L).times(0))).onSuccess(ArgumentMatchers.any());
        this.lock.unlock();
        Optional olf2 = checker.schedule((Checkable)target, (Object)true);
        Assert.assertTrue((boolean)olf2.isPresent());
        Futures.addCallback((ListenableFuture)((ListenableFuture)olf2.get()), (FutureCallback)futureCallback, (Executor)MoreExecutors.directExecutor());
        ((FutureCallback)Mockito.verify((Object)futureCallback, (VerificationMode)Mockito.timeout((long)100L).times(1))).onFailure((Throwable)ArgumentMatchers.any());
        ((FutureCallback)Mockito.verify((Object)futureCallback, (VerificationMode)Mockito.timeout((long)100L).times(1))).onSuccess(ArgumentMatchers.any());
    }

    @Test
    public void testTimeoutExceptionIsNotThrownForGoodDisk() throws Exception {
        LOG.info("Executing {}", (Object)this.testName.getMethodName());
        DummyCheckable target = new DummyCheckable();
        FakeTimer timer = new FakeTimer();
        ThrottledAsyncChecker checker = new ThrottledAsyncChecker((Timer)timer, 0L, 10L, this.getExecutorService());
        Optional olf = checker.schedule((Checkable)target, (Object)true);
        final AtomicBoolean callbackResult = new AtomicBoolean(false);
        final Throwable[] throwable = new Throwable[1];
        Assert.assertTrue((boolean)olf.isPresent());
        Futures.addCallback((ListenableFuture)((ListenableFuture)olf.get()), (FutureCallback)new FutureCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                callbackResult.set(true);
            }

            public void onFailure(Throwable t) {
                throwable[0] = t;
                callbackResult.set(true);
            }
        }, (Executor)MoreExecutors.directExecutor());
        while (!callbackResult.get()) {
            Thread.sleep(10L);
        }
        Assert.assertTrue((throwable[0] == null ? 1 : 0) != 0);
    }

    protected class DummyCheckable
    implements Checkable<Boolean, Boolean> {
        protected DummyCheckable() {
        }

        public Boolean check(Boolean context) throws Exception {
            TestThrottledAsyncCheckerTimeout.this.lock.lock();
            TestThrottledAsyncCheckerTimeout.this.lock.unlock();
            return true;
        }
    }
}

