/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyRackFaultTolerant;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import org.apache.hadoop.net.StaticMapping;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBlockPlacementPolicyRackFaultTolerant {
    private static final int DEFAULT_BLOCK_SIZE = 1024;
    private MiniDFSCluster cluster = null;
    private NamenodeProtocols nameNodeRpc = null;
    private FSNamesystem namesystem = null;
    private PermissionStatus perm = null;

    @Before
    public void setup() throws IOException {
        StaticMapping.resetMap();
        HdfsConfiguration conf = new HdfsConfiguration();
        ArrayList<String> rackList = new ArrayList<String>();
        ArrayList<String> hostList = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 2; ++j) {
                rackList.add("/rack" + i);
                hostList.add("/host" + i + j);
            }
        }
        conf.setClass("dfs.block.replicator.classname", BlockPlacementPolicyRackFaultTolerant.class, BlockPlacementPolicy.class);
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.bytes-per-checksum", 512);
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(hostList.size()).racks(rackList.toArray(new String[rackList.size()])).hosts(hostList.toArray(new String[hostList.size()])).build();
        this.cluster.waitActive();
        this.nameNodeRpc = this.cluster.getNameNodeRpc();
        this.namesystem = this.cluster.getNamesystem();
        this.perm = new PermissionStatus("TestBlockPlacementPolicyEC", null, FsPermission.getDefault());
    }

    @After
    public void teardown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testChooseTarget() throws Exception {
        this.doTestChooseTargetNormalCase();
        this.doTestChooseTargetSpecialCase();
    }

    private void doTestChooseTargetNormalCase() throws Exception {
        String clientMachine = "client.foo.com";
        short[][] testSuite = new short[][]{{3, 2}, {3, 7}, {3, 8}, {3, 10}, {9, 1}, {10, 1}, {10, 6}, {11, 6}, {11, 9}};
        int fileCount = 0;
        for (int i = 0; i < 5; ++i) {
            for (short[] testCase : testSuite) {
                short replication = testCase[0];
                short additionalReplication = testCase[1];
                String src = "/testfile" + fileCount++;
                HdfsFileStatus fileStatus = this.namesystem.startFile(src, this.perm, clientMachine, clientMachine, EnumSet.of(CreateFlag.CREATE), true, replication, 1024L, null, null, null, false);
                LocatedBlock locatedBlock = this.nameNodeRpc.addBlock(src, clientMachine, null, null, fileStatus.getFileId(), null, null);
                this.doTestLocatedBlock(replication, locatedBlock);
                LocatedBlock additionalLocatedBlock = this.nameNodeRpc.getAdditionalDatanode(src, fileStatus.getFileId(), locatedBlock.getBlock(), locatedBlock.getLocations(), locatedBlock.getStorageIDs(), new DatanodeInfo[0], (int)additionalReplication, clientMachine);
                this.doTestLocatedBlock(replication + additionalReplication, additionalLocatedBlock);
            }
        }
    }

    private void doTestChooseTargetSpecialCase() throws Exception {
        String clientMachine = "client.foo.com";
        String src = "/testfile_1_";
        HdfsFileStatus fileStatus = this.namesystem.startFile(src, this.perm, clientMachine, clientMachine, EnumSet.of(CreateFlag.CREATE), true, (short)20, 1024L, null, null, null, false);
        LocatedBlock locatedBlock = this.nameNodeRpc.addBlock(src, clientMachine, null, null, fileStatus.getFileId(), null, null);
        this.doTestLocatedBlock(20, locatedBlock);
        DatanodeInfo[] locs = locatedBlock.getLocations();
        String[] storageIDs = locatedBlock.getStorageIDs();
        for (int time = 0; time < 5; ++time) {
            this.shuffle(locs, storageIDs);
            for (int i = 1; i < locs.length; ++i) {
                DatanodeInfo[] partLocs = new DatanodeInfo[i];
                String[] partStorageIDs = new String[i];
                System.arraycopy(locs, 0, partLocs, 0, i);
                System.arraycopy(storageIDs, 0, partStorageIDs, 0, i);
                for (int j = 1; j < 20 - i; ++j) {
                    LocatedBlock additionalLocatedBlock = this.nameNodeRpc.getAdditionalDatanode(src, fileStatus.getFileId(), locatedBlock.getBlock(), partLocs, partStorageIDs, new DatanodeInfo[0], j, clientMachine);
                    this.doTestLocatedBlock(i + j, additionalLocatedBlock);
                }
            }
        }
    }

    private void shuffle(DatanodeInfo[] locs, String[] storageIDs) {
        int i;
        int length = locs.length;
        Object[][] pairs = new Object[length][];
        for (i = 0; i < length; ++i) {
            pairs[i] = new Object[]{locs[i], storageIDs[i]};
        }
        Collections.shuffle(Arrays.asList(pairs));
        for (i = 0; i < length; ++i) {
            locs[i] = (DatanodeInfo)pairs[i][0];
            storageIDs[i] = (String)pairs[i][1];
        }
    }

    private void doTestLocatedBlock(int replication, LocatedBlock locatedBlock) {
        Assert.assertEquals((long)replication, (long)locatedBlock.getLocations().length);
        HashMap<String, Integer> racksCount = new HashMap<String, Integer>();
        for (DatanodeInfo node : locatedBlock.getLocations()) {
            this.addToRacksCount(node.getNetworkLocation(), racksCount);
        }
        int minCount = Integer.MAX_VALUE;
        int maxCount = Integer.MIN_VALUE;
        for (Integer rackCount : racksCount.values()) {
            minCount = Math.min(minCount, rackCount);
            maxCount = Math.max(maxCount, rackCount);
        }
        Assert.assertTrue((maxCount - minCount <= 1 ? 1 : 0) != 0);
    }

    private void addToRacksCount(String rack, HashMap<String, Integer> racksCount) {
        Integer count = racksCount.get(rack);
        if (count == null) {
            racksCount.put(rack, 1);
        } else {
            racksCount.put(rack, count + 1);
        }
    }
}

