/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.ha;

import java.io.File;
import java.net.URL;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMap;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryLevelDBAliasMapServer;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBootstrapAliasmap {
    private MiniDFSCluster cluster;

    @Before
    public void setup() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster.setupNamenodeProvidedConfiguration(conf);
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        this.cluster.waitActive();
    }

    @Test
    public void testAliasmapBootstrap() throws Exception {
        InMemoryLevelDBAliasMapServer aliasMapServer = this.cluster.getNameNode().getAliasMapServer();
        Block block1 = new Block(1000L);
        Block block2 = new Block(1002L);
        Path path = new Path("/test1.dat");
        aliasMapServer.write(new Block(block1), new ProvidedStorageLocation(path, 0L, 100L, new byte[0]));
        aliasMapServer.write(new Block(block2), new ProvidedStorageLocation(path, 101L, 200L, new byte[0]));
        File newLocation = GenericTestUtils.getRandomizedTestDir();
        NameNode nn = this.cluster.getNameNode();
        Configuration conf = this.cluster.getConfiguration(0);
        String scheme = DFSUtil.getHttpClientScheme((Configuration)conf);
        URL nnHttpURL = DFSUtil.getInfoServerWithDefaultHost((String)nn.getNameNodeAddress().getHostName(), (Configuration)conf, (String)scheme).toURL();
        newLocation.mkdirs();
        TransferFsImage.downloadAliasMap((URL)nnHttpURL, (File)newLocation, (boolean)true);
        Configuration newConfig = new Configuration();
        newConfig.set("dfs.provided.aliasmap.inmemory.leveldb.dir", newLocation.getAbsolutePath());
        newConfig.set("dfs.provided.aliasmap.inmemory.dnrpc-address", "127.0.0.1:" + NetUtils.getFreeSocketPort());
        String blockPoolId = nn.getNamesystem().getBlockPoolId();
        InMemoryLevelDBAliasMapServer newServer = new InMemoryLevelDBAliasMapServer(InMemoryAliasMap::init, blockPoolId);
        newServer.setConf(newConfig);
        newServer.start();
        Assert.assertEquals((long)2L, (long)newServer.list(Optional.empty()).getFileRegions().size());
        Assert.assertNotNull((Object)newServer.read(block1));
        Assert.assertNotNull((Object)newServer.read(block2));
        Assert.assertEquals((Object)blockPoolId, (Object)newServer.getBlockPoolId());
    }
}

