/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.output.WriterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Times;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AggregatedLogFormat {
    private static final Log LOG = LogFactory.getLog(AggregatedLogFormat.class);
    private static final LogKey APPLICATION_ACL_KEY = new LogKey("APPLICATION_ACL");
    private static final LogKey APPLICATION_OWNER_KEY = new LogKey("APPLICATION_OWNER");
    private static final LogKey VERSION_KEY = new LogKey("VERSION");
    private static final Map<String, LogKey> RESERVED_KEYS;
    private static final int VERSION = 1;
    private static final FsPermission APP_LOG_FILE_UMASK;

    static {
        APP_LOG_FILE_UMASK = FsPermission.createImmutable((short)95);
        RESERVED_KEYS = new HashMap<String, LogKey>();
        RESERVED_KEYS.put(APPLICATION_ACL_KEY.toString(), APPLICATION_ACL_KEY);
        RESERVED_KEYS.put(APPLICATION_OWNER_KEY.toString(), APPLICATION_OWNER_KEY);
        RESERVED_KEYS.put(VERSION_KEY.toString(), VERSION_KEY);
    }

    @InterfaceAudience.Private
    public static class ContainerLogsReader {
        private DataInputStream valueStream;
        private String currentLogType = null;
        private long currentLogLength = 0L;
        private BoundedInputStream currentLogData = null;
        private InputStreamReader currentLogISR;

        public ContainerLogsReader(DataInputStream stream) {
            this.valueStream = stream;
        }

        public String nextLog() throws IOException {
            if (this.currentLogData != null && this.currentLogLength > 0L) {
                while (this.currentLogData.skip(this.currentLogLength) >= 0L && this.currentLogData.read() != -1) {
                }
            }
            this.currentLogType = null;
            this.currentLogLength = 0L;
            this.currentLogData = null;
            this.currentLogISR = null;
            try {
                String logType = this.valueStream.readUTF();
                String logLengthStr = this.valueStream.readUTF();
                this.currentLogLength = Long.parseLong(logLengthStr);
                this.currentLogData = new BoundedInputStream((InputStream)this.valueStream, this.currentLogLength);
                this.currentLogData.setPropagateClose(false);
                this.currentLogISR = new InputStreamReader((InputStream)this.currentLogData, Charset.forName("UTF-8"));
                this.currentLogType = logType;
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return this.currentLogType;
        }

        public String getCurrentLogType() {
            return this.currentLogType;
        }

        public long getCurrentLogLength() {
            return this.currentLogLength;
        }

        public long skip(long n) throws IOException {
            return this.currentLogData.skip(n);
        }

        public int read() throws IOException {
            return this.currentLogData.read();
        }

        public int read(byte[] buf, int off, int len) throws IOException {
            return this.currentLogData.read(buf, off, len);
        }

        public int read(char[] buf, int off, int len) throws IOException {
            return this.currentLogISR.read(buf, off, len);
        }
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class LogReader {
        private final FSDataInputStream fsDataIStream;
        private final TFile.Reader.Scanner scanner;
        private final TFile.Reader reader;
        private boolean atBeginning = true;

        public LogReader(Configuration conf, Path remoteAppLogFile) throws IOException {
            FileContext fileContext = FileContext.getFileContext((URI)remoteAppLogFile.toUri(), (Configuration)conf);
            this.fsDataIStream = fileContext.open(remoteAppLogFile);
            this.reader = new TFile.Reader(this.fsDataIStream, fileContext.getFileStatus(remoteAppLogFile).getLen(), conf);
            this.scanner = this.reader.createScanner();
        }

        public String getApplicationOwner() throws IOException {
            TFile.Reader.Scanner ownerScanner = this.reader.createScanner();
            LogKey key = new LogKey();
            while (!ownerScanner.atEnd()) {
                TFile.Reader.Scanner.Entry entry = ownerScanner.entry();
                key.readFields(entry.getKeyStream());
                if (key.toString().equals(APPLICATION_OWNER_KEY.toString())) {
                    DataInputStream valueStream = entry.getValueStream();
                    return valueStream.readUTF();
                }
                ownerScanner.advance();
            }
            return null;
        }

        public Map<ApplicationAccessType, String> getApplicationAcls() throws IOException {
            TFile.Reader.Scanner aclScanner = this.reader.createScanner();
            LogKey key = new LogKey();
            HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>();
            while (!aclScanner.atEnd()) {
                TFile.Reader.Scanner.Entry entry = aclScanner.entry();
                key.readFields(entry.getKeyStream());
                if (key.toString().equals(APPLICATION_ACL_KEY.toString())) {
                    DataInputStream valueStream = entry.getValueStream();
                    while (true) {
                        String appAccessOp = null;
                        String aclString = null;
                        try {
                            appAccessOp = valueStream.readUTF();
                        }
                        catch (EOFException e) {
                            break;
                        }
                        try {
                            aclString = valueStream.readUTF();
                        }
                        catch (EOFException e) {
                            throw new YarnRuntimeException("Error reading ACLs", (Throwable)e);
                        }
                        acls.put(ApplicationAccessType.valueOf((String)appAccessOp), aclString);
                    }
                }
                aclScanner.advance();
            }
            return acls;
        }

        public DataInputStream next(LogKey key) throws IOException {
            if (!this.atBeginning) {
                this.scanner.advance();
            } else {
                this.atBeginning = false;
            }
            if (this.scanner.atEnd()) {
                return null;
            }
            TFile.Reader.Scanner.Entry entry = this.scanner.entry();
            key.readFields(entry.getKeyStream());
            if (RESERVED_KEYS.containsKey(key.toString())) {
                return this.next(key);
            }
            DataInputStream valueStream = entry.getValueStream();
            return valueStream;
        }

        @InterfaceAudience.Private
        public ContainerLogsReader getContainerLogsReader(ContainerId containerId) throws IOException {
            ContainerLogsReader logReader = null;
            LogKey containerKey = new LogKey(containerId);
            LogKey key = new LogKey();
            DataInputStream valueStream = this.next(key);
            while (valueStream != null && !key.equals(containerKey)) {
                valueStream = this.next(key);
            }
            if (valueStream != null) {
                logReader = new ContainerLogsReader(valueStream);
            }
            return logReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void readAcontainerLogs(DataInputStream valueStream, Writer writer, long logUploadedTime) throws IOException {
            WriterOutputStream os = null;
            PrintStream ps = null;
            try {
                os = new WriterOutputStream(writer, Charset.forName("UTF-8"));
                ps = new PrintStream((OutputStream)os);
                try {
                    while (true) {
                        LogReader.readContainerLogs(valueStream, ps, logUploadedTime);
                    }
                }
                catch (EOFException e) {
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{ps});
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{os});
                    return;
                }
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{ps});
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{os});
                throw throwable;
            }
        }

        public static void readAcontainerLogs(DataInputStream valueStream, Writer writer) throws IOException {
            LogReader.readAcontainerLogs(valueStream, writer, -1L);
        }

        private static void readContainerLogs(DataInputStream valueStream, PrintStream out, long logUploadedTime) throws IOException {
            byte[] buf = new byte[65535];
            String fileType = valueStream.readUTF();
            String fileLengthStr = valueStream.readUTF();
            long fileLength = Long.parseLong(fileLengthStr);
            out.print("LogType:");
            out.println(fileType);
            if (logUploadedTime != -1L) {
                out.print("Log Upload Time:");
                out.println(Times.format(logUploadedTime));
            }
            out.print("LogLength:");
            out.println(fileLengthStr);
            out.println("Log Contents:");
            long curRead = 0L;
            long pendingRead = fileLength - curRead;
            int toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
            int len = valueStream.read(buf, 0, toRead);
            while (len != -1 && curRead < fileLength) {
                out.write(buf, 0, len);
                pendingRead = fileLength - (curRead += (long)len);
                toRead = pendingRead > (long)buf.length ? buf.length : (int)pendingRead;
                len = valueStream.read(buf, 0, toRead);
            }
            out.println("End of LogType:" + fileType);
            out.println("");
        }

        public static void readAContainerLogsForALogType(DataInputStream valueStream, PrintStream out, long logUploadedTime) throws IOException {
            LogReader.readContainerLogs(valueStream, out, logUploadedTime);
        }

        public static void readAContainerLogsForALogType(DataInputStream valueStream, PrintStream out) throws IOException {
            LogReader.readAContainerLogsForALogType(valueStream, out, -1L);
        }

        public void close() {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.scanner, this.reader, this.fsDataIStream});
        }
    }

    @InterfaceAudience.Private
    public static class LogWriter {
        private final FSDataOutputStream fsDataOStream;
        private final TFile.Writer writer;
        private FileContext fc;

        public LogWriter(final Configuration conf, final Path remoteAppLogFile, UserGroupInformation userUgi) throws IOException {
            try {
                this.fsDataOStream = (FSDataOutputStream)userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FSDataOutputStream>(){

                    @Override
                    public FSDataOutputStream run() throws Exception {
                        LogWriter.this.fc = FileContext.getFileContext((URI)remoteAppLogFile.toUri(), (Configuration)conf);
                        LogWriter.this.fc.setUMask(APP_LOG_FILE_UMASK);
                        return LogWriter.this.fc.create(remoteAppLogFile, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.writer = new TFile.Writer(this.fsDataOStream, 262144, conf.get("yarn.nodemanager.log-aggregation.compression-type", "none"), null, conf);
            this.writeVersion();
        }

        @VisibleForTesting
        public TFile.Writer getWriter() {
            return this.writer;
        }

        private void writeVersion() throws IOException {
            try (DataOutputStream out = this.writer.prepareAppendKey(-1);){
                VERSION_KEY.write(out);
            }
            out = this.writer.prepareAppendValue(-1);
            var2_2 = null;
            try {
                out.writeInt(1);
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (var2_2 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }

        public void writeApplicationOwner(String user) throws IOException {
            try (DataOutputStream out = this.writer.prepareAppendKey(-1);){
                APPLICATION_OWNER_KEY.write(out);
            }
            out = this.writer.prepareAppendValue(-1);
            var3_3 = null;
            try {
                out.writeUTF(user);
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (var3_3 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }

        public void writeApplicationACLs(Map<ApplicationAccessType, String> appAcls) throws IOException {
            try (DataOutputStream out = this.writer.prepareAppendKey(-1);){
                APPLICATION_ACL_KEY.write(out);
            }
            out = this.writer.prepareAppendValue(-1);
            var3_3 = null;
            try {
                for (Map.Entry<ApplicationAccessType, String> entry : appAcls.entrySet()) {
                    out.writeUTF(entry.getKey().toString());
                    out.writeUTF(entry.getValue());
                }
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (var3_3 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }

        public void append(LogKey logKey, LogValue logValue) throws IOException {
            Set pendingUploadFiles = logValue.getPendingLogFilesToUploadForThisContainer();
            if (pendingUploadFiles.size() == 0) {
                return;
            }
            try (DataOutputStream out = this.writer.prepareAppendKey(-1);){
                logKey.write(out);
            }
            out = this.writer.prepareAppendValue(-1);
            var5_5 = null;
            try {
                logValue.write(out, pendingUploadFiles);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (out != null) {
                    if (var5_5 != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }

        public void close() {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception closing writer", (Throwable)e);
            }
            IOUtils.closeStream((Closeable)this.fsDataOStream);
        }
    }

    @InterfaceAudience.Private
    public static class LogValue {
        private final List<String> rootLogDirs;
        private final ContainerId containerId;
        private final String user;
        private final LogAggregationContext logAggregationContext;
        private Set<File> uploadedFiles = new HashSet<File>();
        private final Set<String> alreadyUploadedLogFiles;
        private Set<String> allExistingFileMeta = new HashSet<String>();
        private final boolean appFinished;

        public LogValue(List<String> rootLogDirs, ContainerId containerId, String user) {
            this(rootLogDirs, containerId, user, null, new HashSet<String>(), true);
        }

        public LogValue(List<String> rootLogDirs, ContainerId containerId, String user, LogAggregationContext logAggregationContext, Set<String> alreadyUploadedLogFiles, boolean appFinished) {
            this.rootLogDirs = new ArrayList<String>(rootLogDirs);
            this.containerId = containerId;
            this.user = user;
            Collections.sort(this.rootLogDirs);
            this.logAggregationContext = logAggregationContext;
            this.alreadyUploadedLogFiles = alreadyUploadedLogFiles;
            this.appFinished = appFinished;
        }

        private Set<File> getPendingLogFilesToUploadForThisContainer() {
            HashSet<File> pendingUploadFiles = new HashSet<File>();
            for (String rootLogDir : this.rootLogDirs) {
                File appLogDir = new File(rootLogDir, ConverterUtils.toString(this.containerId.getApplicationAttemptId().getApplicationId()));
                File containerLogDir = new File(appLogDir, ConverterUtils.toString(this.containerId));
                if (!containerLogDir.isDirectory()) continue;
                pendingUploadFiles.addAll(this.getPendingLogFilesToUpload(containerLogDir));
            }
            return pendingUploadFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(DataOutputStream out, Set<File> pendingUploadFiles) throws IOException {
            ArrayList<File> fileList = new ArrayList<File>(pendingUploadFiles);
            Collections.sort(fileList);
            for (File logFile : fileList) {
                if (logFile.isDirectory()) {
                    LOG.warn((Object)(logFile.getAbsolutePath() + " is a directory. Ignore it."));
                    continue;
                }
                FileInputStream in = null;
                try {
                    in = this.secureOpenFile(logFile);
                }
                catch (IOException e) {
                    LogValue.logErrorMessage(logFile, e);
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
                    continue;
                }
                long fileLength = logFile.length();
                out.writeUTF(logFile.getName());
                out.writeUTF(String.valueOf(fileLength));
                try {
                    long newLength;
                    byte[] buf = new byte[65535];
                    int len = 0;
                    long bytesLeft = fileLength;
                    while ((len = in.read(buf)) != -1) {
                        if ((long)len < bytesLeft) {
                            out.write(buf, 0, len);
                            bytesLeft -= (long)len;
                            continue;
                        }
                        out.write(buf, 0, (int)bytesLeft);
                        break;
                    }
                    if (fileLength < (newLength = logFile.length())) {
                        LOG.warn((Object)("Aggregated logs truncated by approximately " + (newLength - fileLength) + " bytes."));
                    }
                    this.uploadedFiles.add(logFile);
                }
                catch (IOException e) {
                    try {
                        String message = LogValue.logErrorMessage(logFile, e);
                        out.write(message.getBytes(Charset.forName("UTF-8")));
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
                        throw throwable;
                    }
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
                    continue;
                }
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            }
        }

        @VisibleForTesting
        public FileInputStream secureOpenFile(File logFile) throws IOException {
            return SecureIOUtils.openForRead((File)logFile, (String)this.getUser(), null);
        }

        private static String logErrorMessage(File logFile, Exception e) {
            String message = "Error aggregating log file. Log file : " + logFile.getAbsolutePath() + ". " + e.getMessage();
            LOG.error((Object)message, (Throwable)e);
            return message;
        }

        public String getUser() {
            return this.user;
        }

        private Set<File> getPendingLogFilesToUpload(File containerLogDir) {
            HashSet candidates = new HashSet(Arrays.asList(containerLogDir.listFiles()));
            for (File logFile : candidates) {
                this.allExistingFileMeta.add(this.getLogFileMetaData(logFile));
            }
            if (this.logAggregationContext != null && candidates.size() > 0) {
                this.filterFiles(this.appFinished ? this.logAggregationContext.getIncludePattern() : this.logAggregationContext.getRolledLogsIncludePattern(), candidates, false);
                this.filterFiles(this.appFinished ? this.logAggregationContext.getExcludePattern() : this.logAggregationContext.getRolledLogsExcludePattern(), candidates, true);
                Iterable mask = Iterables.filter(candidates, (Predicate)new Predicate<File>(){

                    public boolean apply(File next) {
                        return !LogValue.this.alreadyUploadedLogFiles.contains(LogValue.this.getLogFileMetaData(next));
                    }
                });
                candidates = Sets.newHashSet((Iterable)mask);
            }
            return candidates;
        }

        private void filterFiles(String pattern, Set<File> candidates, boolean exclusion) {
            if (pattern != null && !pattern.isEmpty()) {
                Pattern filterPattern = Pattern.compile(pattern);
                Iterator<File> candidatesItr = candidates.iterator();
                while (candidatesItr.hasNext()) {
                    File candidate = candidatesItr.next();
                    boolean match = filterPattern.matcher(candidate.getName()).find();
                    if ((match || exclusion) && (!match || !exclusion)) continue;
                    candidatesItr.remove();
                }
            }
        }

        public Set<Path> getCurrentUpLoadedFilesPath() {
            HashSet<Path> path = new HashSet<Path>();
            for (File file : this.uploadedFiles) {
                path.add(new Path(file.getAbsolutePath()));
            }
            return path;
        }

        public Set<String> getCurrentUpLoadedFileMeta() {
            HashSet<String> info = new HashSet<String>();
            for (File file : this.uploadedFiles) {
                info.add(this.getLogFileMetaData(file));
            }
            return info;
        }

        public Set<String> getAllExistingFilesMeta() {
            return this.allExistingFileMeta;
        }

        private String getLogFileMetaData(File file) {
            return this.containerId.toString() + "_" + file.getName() + "_" + file.lastModified();
        }
    }

    @InterfaceAudience.Public
    public static class LogKey
    implements Writable {
        private String keyString;

        public LogKey() {
        }

        public LogKey(ContainerId containerId) {
            this.keyString = containerId.toString();
        }

        public LogKey(String keyString) {
            this.keyString = keyString;
        }

        public int hashCode() {
            return this.keyString == null ? 0 : this.keyString.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof LogKey) {
                LogKey other = (LogKey)obj;
                if (this.keyString == null) {
                    return other.keyString == null;
                }
                return this.keyString.equals(other.keyString);
            }
            return false;
        }

        @InterfaceAudience.Private
        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.keyString);
        }

        @InterfaceAudience.Private
        public void readFields(DataInput in) throws IOException {
            this.keyString = in.readUTF();
        }

        public String toString() {
            return this.keyString;
        }
    }
}

