/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.AbstractSchedulerPlanFollower;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerDynamicEditException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ReservationQueue;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapacitySchedulerPlanFollower
extends AbstractSchedulerPlanFollower {
    private static final Logger LOG = LoggerFactory.getLogger(CapacitySchedulerPlanFollower.class);
    private CapacityScheduler cs;

    @Override
    public void init(Clock clock, ResourceScheduler sched, Collection<Plan> plans) {
        super.init(clock, sched, plans);
        LOG.info("Initializing Plan Follower Policy:" + this.getClass().getCanonicalName());
        if (!(sched instanceof CapacityScheduler)) {
            throw new YarnRuntimeException("CapacitySchedulerPlanFollower can only work with CapacityScheduler");
        }
        this.cs = (CapacityScheduler)sched;
    }

    @Override
    protected Queue getPlanQueue(String planQueueName) {
        CSQueue queue = this.cs.getQueue(planQueueName);
        if (!(queue instanceof PlanQueue)) {
            LOG.error("The Plan is not an PlanQueue!");
            return null;
        }
        return queue;
    }

    @Override
    protected List<? extends Queue> getChildReservationQueues(Queue queue) {
        PlanQueue planQueue = (PlanQueue)queue;
        List<CSQueue> childQueues = planQueue.getChildQueues();
        return childQueues;
    }

    @Override
    protected void addReservationQueue(String planQueueName, Queue queue, String currResId) {
        PlanQueue planQueue = (PlanQueue)queue;
        try {
            ReservationQueue resQueue = new ReservationQueue(this.cs, currResId, planQueue);
            this.cs.addQueue(resQueue);
        }
        catch (SchedulerDynamicEditException e) {
            LOG.warn("Exception while trying to activate reservation: {} for plan: {}", new Object[]{currResId, planQueueName, e});
        }
        catch (IOException e) {
            LOG.warn("Exception while trying to activate reservation: {} for plan: {}", new Object[]{currResId, planQueueName, e});
        }
    }

    @Override
    protected void createDefaultReservationQueue(String planQueueName, Queue queue, String defReservationId) {
        PlanQueue planQueue = (PlanQueue)queue;
        if (this.cs.getQueue(defReservationId) == null) {
            try {
                ReservationQueue defQueue = new ReservationQueue(this.cs, defReservationId, planQueue);
                this.cs.addQueue(defQueue);
            }
            catch (SchedulerDynamicEditException e) {
                LOG.warn("Exception while trying to create default reservation queue for plan: {}", (Object)planQueueName, (Object)e);
            }
            catch (IOException e) {
                LOG.warn("Exception while trying to create default reservation queue for plan: {}", (Object)planQueueName, (Object)e);
            }
        }
    }

    @Override
    protected Resource getPlanResources(Plan plan, Queue queue, Resource clusterResources) {
        PlanQueue planQueue = (PlanQueue)queue;
        float planAbsCap = planQueue.getAbsoluteCapacity();
        Resource planResources = Resources.multiply((Resource)clusterResources, (double)planAbsCap);
        plan.setTotalCapacity(planResources);
        return planResources;
    }

    @Override
    protected Resource getReservationQueueResourceIfExists(Plan plan, ReservationId reservationId) {
        CSQueue resQueue = this.cs.getQueue(reservationId.toString());
        Resource reservationResource = null;
        if (resQueue != null) {
            reservationResource = Resources.multiply((Resource)this.cs.getClusterResource(), (double)resQueue.getAbsoluteCapacity());
        }
        return reservationResource;
    }
}

