/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.conf;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SmallTests.class, ClientTests.class})
public class TestConfigurationManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestConfigurationManager.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestConfigurationManager.class);

    @Test
    public void testCheckIfObserversNotified() {
        Configuration conf = new Configuration();
        ConfigurationManager cm = new ConfigurationManager();
        DummyConfigurationObserver d1 = new DummyConfigurationObserver(cm);
        cm.notifyAllObservers(conf);
        Assert.assertTrue((boolean)d1.wasNotifiedOnChange());
        d1.resetNotifiedOnChange();
        DummyConfigurationObserver d2 = new DummyConfigurationObserver(cm);
        cm.notifyAllObservers(conf);
        Assert.assertTrue((boolean)d1.wasNotifiedOnChange());
        d1.resetNotifiedOnChange();
        Assert.assertTrue((boolean)d2.wasNotifiedOnChange());
        d2.resetNotifiedOnChange();
        d2.deregister();
        cm.notifyAllObservers(conf);
        Assert.assertTrue((boolean)d1.wasNotifiedOnChange());
        d1.resetNotifiedOnChange();
        Assert.assertFalse((boolean)d2.wasNotifiedOnChange());
    }

    private void registerLocalObserver(ConfigurationManager cm) {
        new DummyConfigurationObserver(cm);
    }

    @Test
    public void testDeregisterOnOutOfScope() {
        Configuration conf = new Configuration();
        ConfigurationManager cm = new ConfigurationManager();
        boolean outOfScopeObserversDeregistered = false;
        for (int i = 0; i < 100000; ++i) {
            this.registerLocalObserver(cm);
            cm.notifyAllObservers(conf);
            System.gc();
            if (cm.getNumObservers() > i) continue;
            outOfScopeObserversDeregistered = true;
            break;
        }
        if (!outOfScopeObserversDeregistered) {
            LOG.warn("Observers were not GC-ed! Something seems to be wrong.");
        }
        Assert.assertTrue((boolean)outOfScopeObserversDeregistered);
    }

    class DummyConfigurationObserver
    implements ConfigurationObserver {
        private boolean notifiedOnChange = false;
        private ConfigurationManager cm;

        public DummyConfigurationObserver(ConfigurationManager cm) {
            this.cm = cm;
            this.register();
        }

        public void onConfigurationChange(Configuration conf) {
            this.notifiedOnChange = true;
        }

        public boolean wasNotifiedOnChange() {
            return this.notifiedOnChange;
        }

        public void resetNotifiedOnChange() {
            this.notifiedOnChange = false;
        }

        public void register() {
            this.cm.registerObserver((ConfigurationObserver)this);
        }

        public void deregister() {
            this.cm.deregisterObserver((ConfigurationObserver)this);
        }
    }
}

