/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.apache.hadoop.hive.thrift.TFilterTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class TSubjectAssumingTransport
extends TFilterTransport {
    public TSubjectAssumingTransport(TTransport wrapped) {
        super(wrapped);
    }

    public void open() throws TTransportException {
        try {
            AccessControlContext context = AccessController.getContext();
            Subject subject = Subject.getSubject(context);
            Subject.doAs(subject, new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() {
                    try {
                        TSubjectAssumingTransport.this.wrapped.open();
                    }
                    catch (TTransportException tte) {
                        throw new RuntimeException(tte);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException ioe) {
            throw new RuntimeException("Received an ioe we never threw!", ioe);
        }
        catch (RuntimeException rte) {
            if (rte.getCause() instanceof TTransportException) {
                throw (TTransportException)rte.getCause();
            }
            throw rte;
        }
    }
}

