/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.bootstrap;

import java.io.IOException;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.queue.BoundedInMemoryQueueConsumer;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.HoodieBootstrapHandle;

public class BootstrapRecordConsumer
extends BoundedInMemoryQueueConsumer<HoodieRecord, Void> {
    private final HoodieBootstrapHandle bootstrapHandle;

    public BootstrapRecordConsumer(HoodieBootstrapHandle bootstrapHandle) {
        this.bootstrapHandle = bootstrapHandle;
    }

    protected void consumeOneRecord(HoodieRecord record) {
        try {
            this.bootstrapHandle.write(record, (Option<IndexedRecord>)record.getData().getInsertValue(this.bootstrapHandle.getWriterSchemaWithMetaFields()));
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    protected void finish() {
    }

    protected Void getResult() {
        return null;
    }
}

