/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.time.Duration;
import java.time.Instant;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseCommitActionExecutor;

public abstract class AbstractWriteHelper<T extends HoodieRecordPayload, I, K, O, R> {
    public HoodieWriteMetadata<O> write(String instantTime, I inputRecords, HoodieEngineContext context, HoodieTable<T, I, K, O> table, boolean shouldCombine, int shuffleParallelism, BaseCommitActionExecutor<T, I, K, O, R> executor, boolean performTagging) {
        try {
            I dedupedRecords = this.combineOnCondition(shouldCombine, inputRecords, shuffleParallelism, table);
            Instant lookupBegin = Instant.now();
            I taggedRecords = dedupedRecords;
            if (performTagging) {
                taggedRecords = this.tag(dedupedRecords, context, table);
            }
            Duration indexLookupDuration = Duration.between(lookupBegin, Instant.now());
            HoodieWriteMetadata<O> result = executor.execute(taggedRecords);
            result.setIndexLookupDuration(indexLookupDuration);
            return result;
        }
        catch (Throwable e) {
            if (e instanceof HoodieUpsertException) {
                throw (HoodieUpsertException)((Object)e);
            }
            throw new HoodieUpsertException("Failed to upsert for commit time " + instantTime, e);
        }
    }

    protected abstract I tag(I var1, HoodieEngineContext var2, HoodieTable<T, I, K, O> var3);

    public I combineOnCondition(boolean condition, I records, int parallelism, HoodieTable<T, I, K, O> table) {
        return condition ? this.deduplicateRecords(records, table, parallelism) : records;
    }

    public I deduplicateRecords(I records, HoodieTable<T, I, K, O> table, int parallelism) {
        return this.deduplicateRecords(records, table.getIndex(), parallelism);
    }

    public abstract I deduplicateRecords(I var1, HoodieIndex<T, ?, ?, ?> var2, int var3);
}

