/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.jmeter.assertions.DurationAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="duration_assertion_title")
public class DurationAssertionGui
extends AbstractAssertionGui {
    private static final long serialVersionUID = 240L;
    private JTextField duration;

    public DurationAssertionGui() {
        this.init();
    }

    public String getLabelResource() {
        return "duration_assertion_title";
    }

    public String getDurationAttributesTitle() {
        return JMeterUtils.getResString((String)"duration_assertion_duration_test");
    }

    public TestElement createTestElement() {
        DurationAssertion el = new DurationAssertion();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        if (el instanceof DurationAssertion) {
            DurationAssertion assertion = (DurationAssertion)el;
            assertion.setProperty("DurationAssertion.duration", this.duration.getText());
            this.saveScopeSettings((AbstractScopedTestElement)assertion);
        }
    }

    public void clearGui() {
        super.clearGui();
        this.duration.setText("");
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof DurationAssertion) {
            DurationAssertion da = (DurationAssertion)el;
            this.duration.setText(da.getPropertyAsString("DurationAssertion.duration"));
            this.showScopeSettings((AbstractScopedTestElement)da);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 10));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.add(this.createScopePanel());
        VerticalPanel durationPanel = new VerticalPanel();
        durationPanel.setBorder((Border)BorderFactory.createTitledBorder(this.getDurationAttributesTitle()));
        JPanel labelPanel = new JPanel(new BorderLayout(5, 0));
        JLabel durationLabel = new JLabel(JMeterUtils.getResString((String)"duration_assertion_label"));
        labelPanel.add((Component)durationLabel, "West");
        this.duration = new JTextField();
        labelPanel.add((Component)this.duration, "Center");
        durationLabel.setLabelFor(this.duration);
        durationPanel.add((Component)labelPanel);
        mainPanel.add((Component)durationPanel);
        this.add((Component)mainPanel, "Center");
    }
}

