/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.modifiers.gui;

import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.modifiers.SampleTimeout;
import org.apache.jmeter.processor.gui.AbstractPreProcessorGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

@TestElementMetadata(labelResource="sample_timeout_title")
public class SampleTimeoutGui
extends AbstractPreProcessorGui {
    private static final long serialVersionUID = 240L;
    private static final String DEFAULT_TIMEOUT = "10000";
    private JTextField timeoutField;

    public SampleTimeoutGui() {
        this.init();
    }

    public static void error(Exception e, JComponent thrower) {
        JOptionPane.showMessageDialog(thrower, e, "Error", 0);
    }

    public String getLabelResource() {
        return "sample_timeout_title";
    }

    public TestElement createTestElement() {
        SampleTimeout timer = new SampleTimeout();
        this.modifyTestElement((TestElement)timer);
        return timer;
    }

    public void modifyTestElement(TestElement timer) {
        super.configureTestElement(timer);
        ((SampleTimeout)timer).setTimeout(this.timeoutField.getText());
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.timeoutField.setText(((SampleTimeout)el).getTimeout());
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        Box timeoutPanel = Box.createHorizontalBox();
        JLabel timeoutLabel = new JLabel(JMeterUtils.getResString((String)"sample_timeout_timeout"));
        timeoutPanel.add(timeoutLabel);
        this.timeoutField = new JTextField(6);
        this.timeoutField.setText(DEFAULT_TIMEOUT);
        timeoutPanel.add(this.timeoutField);
        this.add(timeoutPanel);
    }

    public void clearGui() {
        this.timeoutField.setText(DEFAULT_TIMEOUT);
        super.clearGui();
    }
}

