/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.Document;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.SamplerResultTab;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderAsDocument
extends SamplerResultTab
implements ResultRenderer {
    private static final Logger log = LoggerFactory.getLogger(RenderAsDocument.class);

    @Override
    public void renderResult(SampleResult sampleResult) {
        try {
            this.showDocumentResponse(sampleResult);
        }
        catch (Exception e) {
            this.results.setText(e.toString());
            log.error("Error while rendering document.", (Throwable)e);
        }
    }

    private void showDocumentResponse(SampleResult sampleResult) {
        String response = Document.getTextFromDocument((byte[])sampleResult.getResponseData());
        this.results.setContentType("text/plain");
        this.setTextOptimized(response);
        this.results.setCaretPosition(0);
        this.resultsScrollPane.setViewportView(this.results);
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString((String)"view_results_render_document");
    }
}

