/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpressionMemberTermURI;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.decl.visit.CSSVisitor;
import com.helger.css.decl.visit.DefaultCSSUrlVisitor;
import com.helger.css.decl.visit.ICSSUrlVisitor;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.reader.CSSReader;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.reader.errorhandler.DoNothingCSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.reader.errorhandler.LoggingCSSParseErrorHandler;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.jmeter.protocol.http.parser.CSSParseExceptionCallback;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.parser.URLString;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssParserCacheLoader
implements CacheLoader<Triple<String, URL, Charset>, URLCollection> {
    private static final Logger LOG = LoggerFactory.getLogger(CssParserCacheLoader.class);
    private static final boolean IGNORE_ALL_CSS_ERRORS = JMeterUtils.getPropDefault((String)"css.parser.ignore_all_css_errors", (boolean)true);

    public URLCollection load(Triple<String, URL, Charset> triple) throws Exception {
        String cssContent = (String)triple.getLeft();
        final URL baseUrl = (URL)triple.getMiddle();
        Charset charset = (Charset)triple.getRight();
        CSSReaderSettings readerSettings = new CSSReaderSettings().setBrowserCompliantMode(true).setFallbackCharset(charset).setCSSVersion(ECSSVersion.CSS30).setCustomErrorHandler((ICSSParseErrorHandler)new LoggingCSSParseErrorHandler()).setCustomExceptionHandler((ICSSParseExceptionCallback)new CSSParseExceptionCallback(baseUrl));
        if (IGNORE_ALL_CSS_ERRORS) {
            readerSettings.setInterpretErrorHandler((ICSSInterpretErrorHandler)new DoNothingCSSInterpretErrorHandler());
        }
        CascadingStyleSheet aCSS = CSSReader.readFromStringReader((String)cssContent, (CSSReaderSettings)readerSettings);
        final URLCollection urls = new URLCollection(new ArrayList<URLString>());
        if (aCSS == null) {
            LOG.warn("Failed parsing CSS: " + baseUrl + ", got null CascadingStyleSheet");
            return urls;
        }
        CSSVisitor.visitCSSUrl((CascadingStyleSheet)aCSS, (ICSSUrlVisitor)new DefaultCSSUrlVisitor(){

            public void onImport(CSSImportRule rule) {
                String location = rule.getLocationString();
                if (!StringUtils.isEmpty((CharSequence)location)) {
                    urls.addURL(location, baseUrl);
                }
            }

            public void onUrlDeclaration(ICSSTopLevelRule aTopLevelRule, CSSDeclaration aDeclaration, CSSExpressionMemberTermURI aURITerm) {
            }
        });
        return urls;
    }
}

