/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.GroupCoordinatorRequest;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.SaslHandshakeRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;

public abstract class AbstractRequest
extends AbstractRequestResponse {
    private final short version;

    public AbstractRequest(Struct struct, short version) {
        super(struct);
        this.version = version;
    }

    public Send toSend(String destination, RequestHeader header) {
        return new NetworkSend(destination, AbstractRequest.serialize(header, this));
    }

    public short version() {
        return this.version;
    }

    public abstract AbstractResponse getErrorResponse(Throwable var1);

    public static AbstractRequest getRequest(int requestId, short versionId, ByteBuffer buffer) {
        ApiKeys apiKey = ApiKeys.forId(requestId);
        switch (apiKey) {
            case PRODUCE: {
                return ProduceRequest.parse(buffer, versionId);
            }
            case FETCH: {
                return FetchRequest.parse(buffer, versionId);
            }
            case LIST_OFFSETS: {
                return ListOffsetRequest.parse(buffer, versionId);
            }
            case METADATA: {
                return MetadataRequest.parse(buffer, versionId);
            }
            case OFFSET_COMMIT: {
                return OffsetCommitRequest.parse(buffer, versionId);
            }
            case OFFSET_FETCH: {
                return OffsetFetchRequest.parse(buffer, versionId);
            }
            case GROUP_COORDINATOR: {
                return GroupCoordinatorRequest.parse(buffer, versionId);
            }
            case JOIN_GROUP: {
                return JoinGroupRequest.parse(buffer, versionId);
            }
            case HEARTBEAT: {
                return HeartbeatRequest.parse(buffer, versionId);
            }
            case LEAVE_GROUP: {
                return LeaveGroupRequest.parse(buffer, versionId);
            }
            case SYNC_GROUP: {
                return SyncGroupRequest.parse(buffer, versionId);
            }
            case STOP_REPLICA: {
                return StopReplicaRequest.parse(buffer, versionId);
            }
            case CONTROLLED_SHUTDOWN_KEY: {
                return ControlledShutdownRequest.parse(buffer, versionId);
            }
            case UPDATE_METADATA_KEY: {
                return UpdateMetadataRequest.parse(buffer, versionId);
            }
            case LEADER_AND_ISR: {
                return LeaderAndIsrRequest.parse(buffer, versionId);
            }
            case DESCRIBE_GROUPS: {
                return DescribeGroupsRequest.parse(buffer, versionId);
            }
            case LIST_GROUPS: {
                return ListGroupsRequest.parse(buffer, versionId);
            }
            case SASL_HANDSHAKE: {
                return SaslHandshakeRequest.parse(buffer, versionId);
            }
            case API_VERSIONS: {
                return ApiVersionsRequest.parse(buffer, versionId);
            }
            case CREATE_TOPICS: {
                return CreateTopicsRequest.parse(buffer, versionId);
            }
            case DELETE_TOPICS: {
                return DeleteTopicsRequest.parse(buffer, versionId);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `getRequest`, the code should be updated to do so.", new Object[]{apiKey}));
    }

    public static abstract class Builder<T extends AbstractRequest> {
        private final ApiKeys apiKey;
        private short version;

        public Builder(ApiKeys apiKey) {
            this.apiKey = apiKey;
            this.version = ProtoUtils.latestVersion(apiKey.id);
        }

        public ApiKeys apiKey() {
            return this.apiKey;
        }

        public Builder<T> setVersion(short version) {
            this.version = version;
            return this;
        }

        public short version() {
            return this.version;
        }

        public abstract T build();
    }
}

