/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class ProduceResponse
extends AbstractResponse {
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String PARTITION_RESPONSES_KEY_NAME = "partition_responses";
    public static final long INVALID_OFFSET = -1L;
    private static final String BASE_OFFSET_KEY_NAME = "base_offset";
    private static final String LOG_APPEND_TIME_KEY_NAME = "log_append_time";
    private static final String LOG_START_OFFSET_KEY_NAME = "log_start_offset";
    private static final String RECORD_ERRORS_KEY_NAME = "record_errors";
    private static final String BATCH_INDEX_KEY_NAME = "batch_index";
    private static final String BATCH_INDEX_ERROR_MESSAGE_KEY_NAME = "batch_index_error_message";
    private static final String ERROR_MESSAGE_KEY_NAME = "error_message";
    private static final Field.Int64 LOG_START_OFFSET_FIELD = new Field.Int64("log_start_offset", "The start offset of the log at the time this produce response was created", -1L);
    private static final Field.NullableStr BATCH_INDEX_ERROR_MESSAGE_FIELD = new Field.NullableStr("batch_index_error_message", "The error message of the record that caused the batch to be dropped");
    private static final Field.NullableStr ERROR_MESSAGE_FIELD = new Field.NullableStr("error_message", "The global error message summarizing the common root cause of the records that caused the batch to be dropped");
    private static final Schema PRODUCE_RESPONSE_V0 = new Schema(new Field("responses", new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field("partition_responses", new ArrayOf(new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field("base_offset", Type.INT64))))))));
    private static final Schema PRODUCE_RESPONSE_V1 = new Schema(new Field("responses", new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field("partition_responses", new ArrayOf(new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field("base_offset", Type.INT64))))))), CommonFields.THROTTLE_TIME_MS);
    private static final Schema PRODUCE_RESPONSE_V2;
    private static final Schema PRODUCE_RESPONSE_V3;
    private static final Schema PRODUCE_RESPONSE_V4;
    public static final Schema PRODUCE_RESPONSE_V5;
    private static final Schema PRODUCE_RESPONSE_V6;
    private static final Schema PRODUCE_RESPONSE_V7;
    public static final Schema PRODUCE_RESPONSE_V8;
    private final Map<TopicPartition, PartitionResponse> responses;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{PRODUCE_RESPONSE_V0, PRODUCE_RESPONSE_V1, PRODUCE_RESPONSE_V2, PRODUCE_RESPONSE_V3, PRODUCE_RESPONSE_V4, PRODUCE_RESPONSE_V5, PRODUCE_RESPONSE_V6, PRODUCE_RESPONSE_V7, PRODUCE_RESPONSE_V8};
    }

    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses) {
        this(responses, 0);
    }

    public ProduceResponse(Map<TopicPartition, PartitionResponse> responses, int throttleTimeMs) {
        this.responses = responses;
        this.throttleTimeMs = throttleTimeMs;
    }

    public ProduceResponse(Struct struct) {
        this.responses = new HashMap<TopicPartition, PartitionResponse>();
        for (Object topicResponse : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicRespStruct = (Struct)topicResponse;
            String topic = topicRespStruct.get(CommonFields.TOPIC_NAME);
            for (Object partResponse : topicRespStruct.getArray(PARTITION_RESPONSES_KEY_NAME)) {
                Object[] recordErrorsArray;
                Struct partRespStruct = (Struct)partResponse;
                int partition = partRespStruct.get(CommonFields.PARTITION_ID);
                Errors error = Errors.forCode(partRespStruct.get(CommonFields.ERROR_CODE));
                long offset = partRespStruct.getLong(BASE_OFFSET_KEY_NAME);
                long logAppendTime = partRespStruct.getLong(LOG_APPEND_TIME_KEY_NAME);
                long logStartOffset = partRespStruct.getOrElse(LOG_START_OFFSET_FIELD, -1L);
                List<RecordError> recordErrors = Collections.emptyList();
                if (partRespStruct.hasField(RECORD_ERRORS_KEY_NAME) && (recordErrorsArray = partRespStruct.getArray(RECORD_ERRORS_KEY_NAME)).length > 0) {
                    recordErrors = new ArrayList(recordErrorsArray.length);
                    for (Object indexAndMessage : recordErrorsArray) {
                        Struct indexAndMessageStruct = (Struct)indexAndMessage;
                        recordErrors.add(new RecordError(indexAndMessageStruct.getInt(BATCH_INDEX_KEY_NAME), indexAndMessageStruct.get(BATCH_INDEX_ERROR_MESSAGE_FIELD)));
                    }
                }
                String errorMessage = partRespStruct.getOrElse(ERROR_MESSAGE_FIELD, null);
                TopicPartition tp = new TopicPartition(topic, partition);
                this.responses.put(tp, new PartitionResponse(error, offset, logAppendTime, logStartOffset, recordErrors, errorMessage));
            }
        }
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.PRODUCE.responseSchema(version));
        Map<String, Map<Integer, PartitionResponse>> responseByTopic = CollectionUtils.groupPartitionDataByTopic(this.responses);
        ArrayList<Struct> topicDatas = new ArrayList<Struct>(responseByTopic.size());
        for (Map.Entry<String, Map<Integer, PartitionResponse>> entry : responseByTopic.entrySet()) {
            Struct topicData = struct.instance(RESPONSES_KEY_NAME);
            topicData.set(CommonFields.TOPIC_NAME, entry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionResponse> partitionEntry : entry.getValue().entrySet()) {
                PartitionResponse part = partitionEntry.getValue();
                short errorCode = part.error.code();
                if (errorCode == Errors.KAFKA_STORAGE_ERROR.code() && version <= 3) {
                    errorCode = Errors.NOT_LEADER_FOR_PARTITION.code();
                }
                Struct partStruct = topicData.instance(PARTITION_RESPONSES_KEY_NAME).set(CommonFields.PARTITION_ID, partitionEntry.getKey()).set(CommonFields.ERROR_CODE, errorCode).set(BASE_OFFSET_KEY_NAME, (Object)part.baseOffset);
                partStruct.setIfExists(LOG_APPEND_TIME_KEY_NAME, (Object)part.logAppendTime);
                partStruct.setIfExists(LOG_START_OFFSET_FIELD, (Object)part.logStartOffset);
                List recordErrors = Collections.emptyList();
                if (!part.recordErrors.isEmpty()) {
                    recordErrors = new ArrayList();
                    for (RecordError indexAndMessage : part.recordErrors) {
                        Struct indexAndMessageStruct = partStruct.instance(RECORD_ERRORS_KEY_NAME).set(BATCH_INDEX_KEY_NAME, (Object)indexAndMessage.batchIndex).set(BATCH_INDEX_ERROR_MESSAGE_FIELD, indexAndMessage.message);
                        recordErrors.add(indexAndMessageStruct);
                    }
                }
                partStruct.setIfExists(RECORD_ERRORS_KEY_NAME, (Object)recordErrors.toArray());
                partStruct.setIfExists(ERROR_MESSAGE_FIELD, (Object)part.errorMessage);
                partitionArray.add(partStruct);
            }
            topicData.set(PARTITION_RESPONSES_KEY_NAME, (Object)partitionArray.toArray());
            topicDatas.add(topicData);
        }
        struct.set(RESPONSES_KEY_NAME, (Object)topicDatas.toArray());
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        return struct;
    }

    public Map<TopicPartition, PartitionResponse> responses() {
        return this.responses;
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (PartitionResponse response : this.responses.values()) {
            this.updateErrorCounts(errorCounts, response.error);
        }
        return errorCounts;
    }

    public static ProduceResponse parse(ByteBuffer buffer, short version) {
        return new ProduceResponse(ApiKeys.PRODUCE.responseSchema(version).read(buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 6;
    }

    static {
        PRODUCE_RESPONSE_V4 = PRODUCE_RESPONSE_V3 = (PRODUCE_RESPONSE_V2 = new Schema(new Field(RESPONSES_KEY_NAME, new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field(PARTITION_RESPONSES_KEY_NAME, new ArrayOf(new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field(BASE_OFFSET_KEY_NAME, Type.INT64), new Field(LOG_APPEND_TIME_KEY_NAME, Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1. If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended."))))))), CommonFields.THROTTLE_TIME_MS));
        PRODUCE_RESPONSE_V7 = PRODUCE_RESPONSE_V6 = (PRODUCE_RESPONSE_V5 = new Schema(new Field(RESPONSES_KEY_NAME, new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field(PARTITION_RESPONSES_KEY_NAME, new ArrayOf(new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field(BASE_OFFSET_KEY_NAME, Type.INT64), new Field(LOG_APPEND_TIME_KEY_NAME, Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1. If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended."), LOG_START_OFFSET_FIELD)))))), CommonFields.THROTTLE_TIME_MS));
        PRODUCE_RESPONSE_V8 = new Schema(new Field(RESPONSES_KEY_NAME, new ArrayOf(new Schema(CommonFields.TOPIC_NAME, new Field(PARTITION_RESPONSES_KEY_NAME, new ArrayOf(new Schema(CommonFields.PARTITION_ID, CommonFields.ERROR_CODE, new Field(BASE_OFFSET_KEY_NAME, Type.INT64), new Field(LOG_APPEND_TIME_KEY_NAME, Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1. If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended."), LOG_START_OFFSET_FIELD, new Field(RECORD_ERRORS_KEY_NAME, new ArrayOf(new Schema(new Field.Int32(BATCH_INDEX_KEY_NAME, "The batch index of the record that caused the batch to be dropped"), BATCH_INDEX_ERROR_MESSAGE_FIELD)), "The batch indices of records that caused the batch to be dropped"), ERROR_MESSAGE_FIELD)))))), CommonFields.THROTTLE_TIME_MS);
    }

    public static final class RecordError {
        public final int batchIndex;
        public final String message;

        public RecordError(int batchIndex, String message) {
            this.batchIndex = batchIndex;
            this.message = message;
        }

        public RecordError(int batchIndex) {
            this.batchIndex = batchIndex;
            this.message = null;
        }
    }

    public static final class PartitionResponse {
        public Errors error;
        public long baseOffset;
        public long logAppendTime;
        public long logStartOffset;
        public List<RecordError> recordErrors;
        public String errorMessage;

        public PartitionResponse(Errors error) {
            this(error, -1L, -1L, -1L);
        }

        public PartitionResponse(Errors error, long baseOffset, long logAppendTime, long logStartOffset) {
            this(error, baseOffset, logAppendTime, logStartOffset, Collections.emptyList(), null);
        }

        public PartitionResponse(Errors error, long baseOffset, long logAppendTime, long logStartOffset, List<RecordError> recordErrors) {
            this(error, baseOffset, logAppendTime, logStartOffset, recordErrors, null);
        }

        public PartitionResponse(Errors error, long baseOffset, long logAppendTime, long logStartOffset, List<RecordError> recordErrors, String errorMessage) {
            this.error = error;
            this.baseOffset = baseOffset;
            this.logAppendTime = logAppendTime;
            this.logStartOffset = logStartOffset;
            this.recordErrors = recordErrors;
            this.errorMessage = errorMessage;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append('{');
            b.append("error: ");
            b.append((Object)this.error);
            b.append(",offset: ");
            b.append(this.baseOffset);
            b.append(",logAppendTime: ");
            b.append(this.logAppendTime);
            b.append(", logStartOffset: ");
            b.append(this.logStartOffset);
            b.append(", recordErrors: ");
            b.append(this.recordErrors);
            b.append(", errorMessage: ");
            if (this.errorMessage != null) {
                b.append(this.errorMessage);
            } else {
                b.append("null");
            }
            b.append('}');
            return b.toString();
        }
    }
}

