/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util.timer;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.timer.Timer;
import org.apache.kafka.server.util.timer.TimerTask;
import org.apache.kafka.server.util.timer.TimerTaskEntry;

public class MockTimer
implements Timer {
    private final MockTime time;
    private final PriorityQueue<TimerTaskEntry> taskQueue = new PriorityQueue<TimerTaskEntry>(Comparator.comparingLong(entry -> entry.expirationMs));

    public MockTimer() {
        this(new MockTime());
    }

    public MockTimer(MockTime time) {
        this.time = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TimerTask timerTask) {
        if (timerTask.delayMs <= 0L) {
            timerTask.run();
        } else {
            PriorityQueue<TimerTaskEntry> priorityQueue = this.taskQueue;
            synchronized (priorityQueue) {
                this.taskQueue.add(new TimerTaskEntry(timerTask, timerTask.delayMs + this.time.milliseconds()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean advanceClock(long timeoutMs) throws InterruptedException {
        this.time.sleep(timeoutMs);
        long now = this.time.milliseconds();
        boolean executed = false;
        boolean hasMore = true;
        while (hasMore) {
            hasMore = false;
            TimerTaskEntry taskEntry = null;
            PriorityQueue<TimerTaskEntry> priorityQueue = this.taskQueue;
            synchronized (priorityQueue) {
                if (!this.taskQueue.isEmpty() && now > this.taskQueue.peek().expirationMs) {
                    taskEntry = this.taskQueue.poll();
                    hasMore = !this.taskQueue.isEmpty();
                }
            }
            if (taskEntry == null || taskEntry.cancelled()) continue;
            taskEntry.timerTask.run();
            executed = true;
        }
        return executed;
    }

    public MockTime time() {
        return this.time;
    }

    public int size() {
        return this.taskQueue.size();
    }

    public void close() throws Exception {
    }
}

