/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.common;

import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

class MetadataVersionTest {
    MetadataVersionTest() {
    }

    @Test
    public void testKRaftFeatureLevelsBefore3_0_IV1() {
        for (int i = 0; i < MetadataVersion.IBP_3_0_IV1.ordinal(); ++i) {
            Assertions.assertEquals((int)-1, (int)MetadataVersion.VERSIONS[i].featureLevel());
        }
    }

    @Test
    public void testKRaftFeatureLevelsAtAndAfter3_0_IV1() {
        for (int i = MetadataVersion.IBP_3_0_IV1.ordinal(); i < MetadataVersion.VERSIONS.length; ++i) {
            int expectedLevel = i - MetadataVersion.IBP_3_0_IV1.ordinal() + 1;
            Assertions.assertEquals((int)expectedLevel, (int)MetadataVersion.VERSIONS[i].featureLevel());
        }
    }

    @Test
    public void testFromVersionString() {
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_0, (Object)MetadataVersion.fromVersionString((String)"0.8.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_0, (Object)MetadataVersion.fromVersionString((String)"0.8.0.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_0, (Object)MetadataVersion.fromVersionString((String)"0.8.0.1"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromVersionString((String)"8.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_1, (Object)MetadataVersion.fromVersionString((String)"0.8.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_1, (Object)MetadataVersion.fromVersionString((String)"0.8.1.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_1, (Object)MetadataVersion.fromVersionString((String)"0.8.1.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_2, (Object)MetadataVersion.fromVersionString((String)"0.8.2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_2, (Object)MetadataVersion.fromVersionString((String)"0.8.2.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_2, (Object)MetadataVersion.fromVersionString((String)"0.8.2.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_9_0, (Object)MetadataVersion.fromVersionString((String)"0.9.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_9_0, (Object)MetadataVersion.fromVersionString((String)"0.9.0.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_9_0, (Object)MetadataVersion.fromVersionString((String)"0.9.0.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV0, (Object)MetadataVersion.fromVersionString((String)"0.10.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV1, (Object)MetadataVersion.fromVersionString((String)"0.10.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV1, (Object)MetadataVersion.fromVersionString((String)"0.10.0.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV1, (Object)MetadataVersion.fromVersionString((String)"0.10.0.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV1, (Object)MetadataVersion.fromVersionString((String)"0.10.0.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV0, (Object)MetadataVersion.fromVersionString((String)"0.10.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV1, (Object)MetadataVersion.fromVersionString((String)"0.10.1-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV2, (Object)MetadataVersion.fromVersionString((String)"0.10.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV2, (Object)MetadataVersion.fromVersionString((String)"0.10.1.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV2, (Object)MetadataVersion.fromVersionString((String)"0.10.1-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_1_IV2, (Object)MetadataVersion.fromVersionString((String)"0.10.1.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_2_IV0, (Object)MetadataVersion.fromVersionString((String)"0.10.2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_2_IV0, (Object)MetadataVersion.fromVersionString((String)"0.10.2.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_2_IV0, (Object)MetadataVersion.fromVersionString((String)"0.10.2-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_2_IV0, (Object)MetadataVersion.fromVersionString((String)"0.10.2.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV0, (Object)MetadataVersion.fromVersionString((String)"0.11.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV1, (Object)MetadataVersion.fromVersionString((String)"0.11.0-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV2, (Object)MetadataVersion.fromVersionString((String)"0.11.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV2, (Object)MetadataVersion.fromVersionString((String)"0.11.0.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV2, (Object)MetadataVersion.fromVersionString((String)"0.11.0-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV2, (Object)MetadataVersion.fromVersionString((String)"0.11.0.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_0_IV0, (Object)MetadataVersion.fromVersionString((String)"1.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_0_IV0, (Object)MetadataVersion.fromVersionString((String)"1.0.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_0_IV0, (Object)MetadataVersion.fromVersionString((String)"1.0.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_0_IV0, (Object)MetadataVersion.fromVersionString((String)"1.0.1"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromVersionString((String)"0.1.0"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromVersionString((String)"0.1.0.0"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromVersionString((String)"0.1.0-IV0"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> MetadataVersion.fromVersionString((String)"0.1.0.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_1_1_IV0, (Object)MetadataVersion.fromVersionString((String)"1.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_0_IV1, (Object)MetadataVersion.fromVersionString((String)"2.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_0_IV0, (Object)MetadataVersion.fromVersionString((String)"2.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_0_IV1, (Object)MetadataVersion.fromVersionString((String)"2.0-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_1_IV2, (Object)MetadataVersion.fromVersionString((String)"2.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_1_IV0, (Object)MetadataVersion.fromVersionString((String)"2.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_1_IV1, (Object)MetadataVersion.fromVersionString((String)"2.1-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_1_IV2, (Object)MetadataVersion.fromVersionString((String)"2.1-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_2_IV1, (Object)MetadataVersion.fromVersionString((String)"2.2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_2_IV0, (Object)MetadataVersion.fromVersionString((String)"2.2-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_2_IV1, (Object)MetadataVersion.fromVersionString((String)"2.2-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_3_IV1, (Object)MetadataVersion.fromVersionString((String)"2.3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_3_IV0, (Object)MetadataVersion.fromVersionString((String)"2.3-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_3_IV1, (Object)MetadataVersion.fromVersionString((String)"2.3-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_4_IV1, (Object)MetadataVersion.fromVersionString((String)"2.4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_4_IV0, (Object)MetadataVersion.fromVersionString((String)"2.4-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_4_IV1, (Object)MetadataVersion.fromVersionString((String)"2.4-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_5_IV0, (Object)MetadataVersion.fromVersionString((String)"2.5"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_5_IV0, (Object)MetadataVersion.fromVersionString((String)"2.5-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_6_IV0, (Object)MetadataVersion.fromVersionString((String)"2.6"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_6_IV0, (Object)MetadataVersion.fromVersionString((String)"2.6-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_7_IV2, (Object)MetadataVersion.fromVersionString((String)"2.7"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_7_IV0, (Object)MetadataVersion.fromVersionString((String)"2.7-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_7_IV1, (Object)MetadataVersion.fromVersionString((String)"2.7-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_7_IV2, (Object)MetadataVersion.fromVersionString((String)"2.7-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_8_IV1, (Object)MetadataVersion.fromVersionString((String)"2.8"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_8_IV0, (Object)MetadataVersion.fromVersionString((String)"2.8-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_2_8_IV1, (Object)MetadataVersion.fromVersionString((String)"2.8-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)MetadataVersion.fromVersionString((String)"3.0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV0, (Object)MetadataVersion.fromVersionString((String)"3.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1, (Object)MetadataVersion.fromVersionString((String)"3.0-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_1_IV0, (Object)MetadataVersion.fromVersionString((String)"3.1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_1_IV0, (Object)MetadataVersion.fromVersionString((String)"3.1-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_2_IV0, (Object)MetadataVersion.fromVersionString((String)"3.2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_2_IV0, (Object)MetadataVersion.fromVersionString((String)"3.2-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromVersionString((String)"3.3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV0, (Object)MetadataVersion.fromVersionString((String)"3.3-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV1, (Object)MetadataVersion.fromVersionString((String)"3.3-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV2, (Object)MetadataVersion.fromVersionString((String)"3.3-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_3_IV3, (Object)MetadataVersion.fromVersionString((String)"3.3-IV3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromVersionString((String)"3.4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_4_IV0, (Object)MetadataVersion.fromVersionString((String)"3.4-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV2, (Object)MetadataVersion.fromVersionString((String)"3.5"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV0, (Object)MetadataVersion.fromVersionString((String)"3.5-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV1, (Object)MetadataVersion.fromVersionString((String)"3.5-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_5_IV2, (Object)MetadataVersion.fromVersionString((String)"3.5-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV2, (Object)MetadataVersion.fromVersionString((String)"3.6"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV0, (Object)MetadataVersion.fromVersionString((String)"3.6-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV1, (Object)MetadataVersion.fromVersionString((String)"3.6-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_6_IV2, (Object)MetadataVersion.fromVersionString((String)"3.6-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV4, (Object)MetadataVersion.fromVersionString((String)"3.7"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV0, (Object)MetadataVersion.fromVersionString((String)"3.7-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV1, (Object)MetadataVersion.fromVersionString((String)"3.7-IV1"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV2, (Object)MetadataVersion.fromVersionString((String)"3.7-IV2"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV3, (Object)MetadataVersion.fromVersionString((String)"3.7-IV3"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_7_IV4, (Object)MetadataVersion.fromVersionString((String)"3.7-IV4"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0, (Object)MetadataVersion.fromVersionString((String)"3.8"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_8_IV0, (Object)MetadataVersion.fromVersionString((String)"3.8-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_9_IV0, (Object)MetadataVersion.fromVersionString((String)"3.9"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_9_IV0, (Object)MetadataVersion.fromVersionString((String)"3.9-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV0, (Object)MetadataVersion.fromVersionString((String)"4.0-IV0"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_4_0_IV1, (Object)MetadataVersion.fromVersionString((String)"4.0-IV1"));
    }

    @Test
    public void testMinSupportedVersionFor() {
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_8_0, (Object)MetadataVersion.minSupportedFor((RecordVersion)RecordVersion.V0));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_10_0_IV0, (Object)MetadataVersion.minSupportedFor((RecordVersion)RecordVersion.V1));
        Assertions.assertEquals((Object)MetadataVersion.IBP_0_11_0_IV0, (Object)MetadataVersion.minSupportedFor((RecordVersion)RecordVersion.V2));
        for (RecordVersion recordVersion : RecordVersion.values()) {
            Assertions.assertNotNull((Object)MetadataVersion.minSupportedFor((RecordVersion)recordVersion));
        }
    }

    @Test
    public void testShortVersion() {
        Assertions.assertEquals((Object)"0.8.0", (Object)MetadataVersion.IBP_0_8_0.shortVersion());
        Assertions.assertEquals((Object)"0.10.0", (Object)MetadataVersion.IBP_0_10_0_IV0.shortVersion());
        Assertions.assertEquals((Object)"0.10.0", (Object)MetadataVersion.IBP_0_10_0_IV1.shortVersion());
        Assertions.assertEquals((Object)"0.11.0", (Object)MetadataVersion.IBP_0_11_0_IV0.shortVersion());
        Assertions.assertEquals((Object)"0.11.0", (Object)MetadataVersion.IBP_0_11_0_IV1.shortVersion());
        Assertions.assertEquals((Object)"0.11.0", (Object)MetadataVersion.IBP_0_11_0_IV2.shortVersion());
        Assertions.assertEquals((Object)"1.0", (Object)MetadataVersion.IBP_1_0_IV0.shortVersion());
        Assertions.assertEquals((Object)"1.1", (Object)MetadataVersion.IBP_1_1_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.0", (Object)MetadataVersion.IBP_2_0_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.0", (Object)MetadataVersion.IBP_2_0_IV1.shortVersion());
        Assertions.assertEquals((Object)"2.1", (Object)MetadataVersion.IBP_2_1_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.1", (Object)MetadataVersion.IBP_2_1_IV1.shortVersion());
        Assertions.assertEquals((Object)"2.1", (Object)MetadataVersion.IBP_2_1_IV2.shortVersion());
        Assertions.assertEquals((Object)"2.2", (Object)MetadataVersion.IBP_2_2_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.2", (Object)MetadataVersion.IBP_2_2_IV1.shortVersion());
        Assertions.assertEquals((Object)"2.3", (Object)MetadataVersion.IBP_2_3_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.3", (Object)MetadataVersion.IBP_2_3_IV1.shortVersion());
        Assertions.assertEquals((Object)"2.4", (Object)MetadataVersion.IBP_2_4_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.5", (Object)MetadataVersion.IBP_2_5_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.6", (Object)MetadataVersion.IBP_2_6_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.7", (Object)MetadataVersion.IBP_2_7_IV2.shortVersion());
        Assertions.assertEquals((Object)"2.8", (Object)MetadataVersion.IBP_2_8_IV0.shortVersion());
        Assertions.assertEquals((Object)"2.8", (Object)MetadataVersion.IBP_2_8_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.0", (Object)MetadataVersion.IBP_3_0_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.0", (Object)MetadataVersion.IBP_3_0_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.1", (Object)MetadataVersion.IBP_3_1_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.2", (Object)MetadataVersion.IBP_3_2_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.3", (Object)MetadataVersion.IBP_3_3_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.3", (Object)MetadataVersion.IBP_3_3_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.3", (Object)MetadataVersion.IBP_3_3_IV2.shortVersion());
        Assertions.assertEquals((Object)"3.3", (Object)MetadataVersion.IBP_3_3_IV3.shortVersion());
        Assertions.assertEquals((Object)"3.4", (Object)MetadataVersion.IBP_3_4_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.5", (Object)MetadataVersion.IBP_3_5_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.5", (Object)MetadataVersion.IBP_3_5_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.5", (Object)MetadataVersion.IBP_3_5_IV2.shortVersion());
        Assertions.assertEquals((Object)"3.6", (Object)MetadataVersion.IBP_3_6_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.6", (Object)MetadataVersion.IBP_3_6_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.6", (Object)MetadataVersion.IBP_3_6_IV2.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV1.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV2.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV3.shortVersion());
        Assertions.assertEquals((Object)"3.7", (Object)MetadataVersion.IBP_3_7_IV4.shortVersion());
        Assertions.assertEquals((Object)"3.8", (Object)MetadataVersion.IBP_3_8_IV0.shortVersion());
        Assertions.assertEquals((Object)"3.9", (Object)MetadataVersion.IBP_3_9_IV0.shortVersion());
        Assertions.assertEquals((Object)"4.0", (Object)MetadataVersion.IBP_4_0_IV0.shortVersion());
        Assertions.assertEquals((Object)"4.0", (Object)MetadataVersion.IBP_4_0_IV1.shortVersion());
    }

    @Test
    public void testVersion() {
        Assertions.assertEquals((Object)"0.8.0", (Object)MetadataVersion.IBP_0_8_0.version());
        Assertions.assertEquals((Object)"0.8.2", (Object)MetadataVersion.IBP_0_8_2.version());
        Assertions.assertEquals((Object)"0.10.0-IV0", (Object)MetadataVersion.IBP_0_10_0_IV0.version());
        Assertions.assertEquals((Object)"0.10.0-IV1", (Object)MetadataVersion.IBP_0_10_0_IV1.version());
        Assertions.assertEquals((Object)"0.11.0-IV0", (Object)MetadataVersion.IBP_0_11_0_IV0.version());
        Assertions.assertEquals((Object)"0.11.0-IV1", (Object)MetadataVersion.IBP_0_11_0_IV1.version());
        Assertions.assertEquals((Object)"0.11.0-IV2", (Object)MetadataVersion.IBP_0_11_0_IV2.version());
        Assertions.assertEquals((Object)"1.0-IV0", (Object)MetadataVersion.IBP_1_0_IV0.version());
        Assertions.assertEquals((Object)"1.1-IV0", (Object)MetadataVersion.IBP_1_1_IV0.version());
        Assertions.assertEquals((Object)"2.0-IV0", (Object)MetadataVersion.IBP_2_0_IV0.version());
        Assertions.assertEquals((Object)"2.0-IV1", (Object)MetadataVersion.IBP_2_0_IV1.version());
        Assertions.assertEquals((Object)"2.1-IV0", (Object)MetadataVersion.IBP_2_1_IV0.version());
        Assertions.assertEquals((Object)"2.1-IV1", (Object)MetadataVersion.IBP_2_1_IV1.version());
        Assertions.assertEquals((Object)"2.1-IV2", (Object)MetadataVersion.IBP_2_1_IV2.version());
        Assertions.assertEquals((Object)"2.2-IV0", (Object)MetadataVersion.IBP_2_2_IV0.version());
        Assertions.assertEquals((Object)"2.2-IV1", (Object)MetadataVersion.IBP_2_2_IV1.version());
        Assertions.assertEquals((Object)"2.3-IV0", (Object)MetadataVersion.IBP_2_3_IV0.version());
        Assertions.assertEquals((Object)"2.3-IV1", (Object)MetadataVersion.IBP_2_3_IV1.version());
        Assertions.assertEquals((Object)"2.4-IV0", (Object)MetadataVersion.IBP_2_4_IV0.version());
        Assertions.assertEquals((Object)"2.5-IV0", (Object)MetadataVersion.IBP_2_5_IV0.version());
        Assertions.assertEquals((Object)"2.6-IV0", (Object)MetadataVersion.IBP_2_6_IV0.version());
        Assertions.assertEquals((Object)"2.7-IV2", (Object)MetadataVersion.IBP_2_7_IV2.version());
        Assertions.assertEquals((Object)"2.8-IV0", (Object)MetadataVersion.IBP_2_8_IV0.version());
        Assertions.assertEquals((Object)"2.8-IV1", (Object)MetadataVersion.IBP_2_8_IV1.version());
        Assertions.assertEquals((Object)"3.0-IV0", (Object)MetadataVersion.IBP_3_0_IV0.version());
        Assertions.assertEquals((Object)"3.0-IV1", (Object)MetadataVersion.IBP_3_0_IV1.version());
        Assertions.assertEquals((Object)"3.1-IV0", (Object)MetadataVersion.IBP_3_1_IV0.version());
        Assertions.assertEquals((Object)"3.2-IV0", (Object)MetadataVersion.IBP_3_2_IV0.version());
        Assertions.assertEquals((Object)"3.3-IV0", (Object)MetadataVersion.IBP_3_3_IV0.version());
        Assertions.assertEquals((Object)"3.3-IV1", (Object)MetadataVersion.IBP_3_3_IV1.version());
        Assertions.assertEquals((Object)"3.3-IV2", (Object)MetadataVersion.IBP_3_3_IV2.version());
        Assertions.assertEquals((Object)"3.3-IV3", (Object)MetadataVersion.IBP_3_3_IV3.version());
        Assertions.assertEquals((Object)"3.4-IV0", (Object)MetadataVersion.IBP_3_4_IV0.version());
        Assertions.assertEquals((Object)"3.5-IV0", (Object)MetadataVersion.IBP_3_5_IV0.version());
        Assertions.assertEquals((Object)"3.5-IV1", (Object)MetadataVersion.IBP_3_5_IV1.version());
        Assertions.assertEquals((Object)"3.5-IV2", (Object)MetadataVersion.IBP_3_5_IV2.version());
        Assertions.assertEquals((Object)"3.6-IV0", (Object)MetadataVersion.IBP_3_6_IV0.version());
        Assertions.assertEquals((Object)"3.6-IV1", (Object)MetadataVersion.IBP_3_6_IV1.version());
        Assertions.assertEquals((Object)"3.6-IV2", (Object)MetadataVersion.IBP_3_6_IV2.version());
        Assertions.assertEquals((Object)"3.7-IV0", (Object)MetadataVersion.IBP_3_7_IV0.version());
        Assertions.assertEquals((Object)"3.7-IV1", (Object)MetadataVersion.IBP_3_7_IV1.version());
        Assertions.assertEquals((Object)"3.7-IV2", (Object)MetadataVersion.IBP_3_7_IV2.version());
        Assertions.assertEquals((Object)"3.7-IV3", (Object)MetadataVersion.IBP_3_7_IV3.version());
        Assertions.assertEquals((Object)"3.7-IV4", (Object)MetadataVersion.IBP_3_7_IV4.version());
        Assertions.assertEquals((Object)"3.8-IV0", (Object)MetadataVersion.IBP_3_8_IV0.version());
        Assertions.assertEquals((Object)"3.9-IV0", (Object)MetadataVersion.IBP_3_9_IV0.version());
        Assertions.assertEquals((Object)"4.0-IV0", (Object)MetadataVersion.IBP_4_0_IV0.version());
        Assertions.assertEquals((Object)"4.0-IV1", (Object)MetadataVersion.IBP_4_0_IV1.version());
    }

    @Test
    public void testPrevious() {
        for (int i = 1; i < MetadataVersion.VERSIONS.length - 2; ++i) {
            MetadataVersion version = MetadataVersion.VERSIONS[i];
            Assertions.assertTrue((boolean)version.previous().isPresent(), (String)version.toString());
            Assertions.assertEquals((Object)MetadataVersion.VERSIONS[i - 1], version.previous().get());
        }
    }

    @Test
    public void testMetadataChanged() {
        Assertions.assertFalse((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_2_IV0, (MetadataVersion)MetadataVersion.IBP_3_2_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_2_IV0, (MetadataVersion)MetadataVersion.IBP_3_1_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_2_IV0, (MetadataVersion)MetadataVersion.IBP_3_0_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_2_IV0, (MetadataVersion)MetadataVersion.IBP_3_0_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_2_IV0, (MetadataVersion)MetadataVersion.IBP_2_8_IV1));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_3_IV1, (MetadataVersion)MetadataVersion.IBP_3_3_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_3_0_IV0, (MetadataVersion)MetadataVersion.IBP_3_2_IV0));
        Assertions.assertTrue((boolean)MetadataVersion.checkIfMetadataChanged((MetadataVersion)MetadataVersion.IBP_2_8_IV1, (MetadataVersion)MetadataVersion.IBP_3_2_IV0));
    }

    @Test
    public void testKRaftVersions() {
        for (MetadataVersion metadataVersion : MetadataVersion.VERSIONS) {
            if (metadataVersion.isKRaftSupported()) {
                Assertions.assertTrue((metadataVersion.featureLevel() > 0 ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertEquals((int)-1, (int)metadataVersion.featureLevel());
        }
        for (MetadataVersion metadataVersion : MetadataVersion.VERSIONS) {
            if (metadataVersion.isAtLeast(MetadataVersion.IBP_3_0_IV1)) {
                Assertions.assertTrue((boolean)metadataVersion.isKRaftSupported(), (String)metadataVersion.toString());
                continue;
            }
            Assertions.assertFalse((boolean)metadataVersion.isKRaftSupported());
        }
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsInControlledShutdownStateSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_3_3_IV3), (Object)metadataVersion.isInControlledShutdownStateSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsDelegationTokenSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_3_6_IV2), (Object)metadataVersion.isDelegationTokenSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testDirectoryAssignmentSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_3_7_IV2), (Object)metadataVersion.isDirectoryAssignmentSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testIsElrSupported(MetadataVersion metadataVersion) {
        Assertions.assertEquals((Object)metadataVersion.isAtLeast(MetadataVersion.IBP_4_0_IV0), (Object)metadataVersion.isElrSupported());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testPartitionRecordVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isElrSupported() ? (short)2 : (metadataVersion.isDirectoryAssignmentSupported() ? (short)1 : 0);
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.partitionRecordVersion());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testPartitionChangeRecordVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isElrSupported() ? (short)2 : (metadataVersion.isDirectoryAssignmentSupported() ? (short)1 : 0);
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.partitionChangeRecordVersion());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testRegisterBrokerRecordVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_3_7_IV2) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_3_4_IV0) ? (short)2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_3_3_IV3) ? (short)1 : 0));
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.registerBrokerRecordVersion());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testGroupMetadataValueVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_2_3_IV0) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_1_IV0) ? (short)2 : (metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_1_IV0) ? (short)1 : 0));
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.groupMetadataValueVersion());
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testOffsetCommitValueVersion(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isAtLeast(MetadataVersion.IBP_2_1_IV1) ? (short)3 : (metadataVersion.isAtLeast(MetadataVersion.IBP_2_1_IV0) ? (short)2 : 1);
        Assertions.assertEquals((short)expectedVersion, (short)metadataVersion.offsetCommitValueVersion(false));
    }

    @ParameterizedTest
    @EnumSource(value=MetadataVersion.class)
    public void testOffsetCommitValueVersionWithExpiredTimestamp(MetadataVersion metadataVersion) {
        Assertions.assertEquals((short)1, (short)metadataVersion.offsetCommitValueVersion(true));
    }

    @Test
    public void assertLatestProductionIsLessThanLatest() {
        Assertions.assertTrue((MetadataVersion.LATEST_PRODUCTION.ordinal() < MetadataVersion.latestTesting().ordinal() ? 1 : 0) != 0, (String)("Expected LATEST_PRODUCTION " + MetadataVersion.LATEST_PRODUCTION + " to be less than the latest of " + MetadataVersion.latestTesting()));
    }

    @Test
    public void testProductionMetadataDontUseUnstableApiVersion() {
        MetadataVersion mv = MetadataVersion.latestProduction();
        Assertions.assertTrue((mv.listOffsetRequestVersion() <= ApiKeys.LIST_OFFSETS.latestVersion(false) ? 1 : 0) != 0);
        Assertions.assertTrue((mv.fetchRequestVersion() <= ApiKeys.FETCH.latestVersion(false) ? 1 : 0) != 0);
        Assertions.assertTrue((mv.offsetForLeaderEpochRequestVersion() <= ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(false) ? 1 : 0) != 0);
        Assertions.assertTrue((mv.writeTxnMarkersRequestVersion() <= ApiKeys.WRITE_TXN_MARKERS.latestVersion(false) ? 1 : 0) != 0);
    }

    @Test
    public void assertLatestProductionIsProduction() {
        Assertions.assertTrue((boolean)MetadataVersion.LATEST_PRODUCTION.isProduction());
    }

    @Test
    public void assertLatestIsNotProduction() {
        Assertions.assertFalse((boolean)MetadataVersion.latestTesting().isProduction());
    }
}

