/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.SinkNode;
import org.apache.kafka.streams.processor.internals.SourceNode;

public class ProcessorTopology {
    private final List<ProcessorNode> processorNodes;
    private final List<StateStore> stateStores;
    private final List<StateStore> globalStateStores;
    private final Map<String, SourceNode> sourceByTopics;
    private final Map<String, SinkNode> sinkByTopics;
    private final Map<String, String> storeToChangelogTopic;

    public ProcessorTopology(List<ProcessorNode> processorNodes, Map<String, SourceNode> sourceByTopics, Map<String, SinkNode> sinkByTopics, List<StateStore> stateStores, Map<String, String> storeToChangelogTopic, List<StateStore> globalStateStores) {
        this.processorNodes = Collections.unmodifiableList(processorNodes);
        this.sourceByTopics = Collections.unmodifiableMap(sourceByTopics);
        this.sinkByTopics = Collections.unmodifiableMap(sinkByTopics);
        this.stateStores = Collections.unmodifiableList(stateStores);
        this.storeToChangelogTopic = Collections.unmodifiableMap(storeToChangelogTopic);
        this.globalStateStores = Collections.unmodifiableList(globalStateStores);
    }

    public Set<String> sourceTopics() {
        return this.sourceByTopics.keySet();
    }

    public SourceNode source(String topic) {
        return this.sourceByTopics.get(topic);
    }

    public Set<SourceNode> sources() {
        return new HashSet<SourceNode>(this.sourceByTopics.values());
    }

    public Set<String> sinkTopics() {
        return this.sinkByTopics.keySet();
    }

    public SinkNode sink(String topic) {
        return this.sinkByTopics.get(topic);
    }

    public Set<SinkNode> sinks() {
        return new HashSet<SinkNode>(this.sinkByTopics.values());
    }

    public List<ProcessorNode> processors() {
        return this.processorNodes;
    }

    public List<StateStore> stateStores() {
        return this.stateStores;
    }

    public Map<String, String> storeToChangelogTopic() {
        return this.storeToChangelogTopic;
    }

    public List<StateStore> globalStateStores() {
        return this.globalStateStores;
    }

    private String childrenToString(String indent, List<ProcessorNode<?, ?>> children) {
        if (children == null || children.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(indent + "\tchildren:\t[");
        for (ProcessorNode<?, ?> child : children) {
            sb.append(child.name());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]\n");
        for (ProcessorNode<?, ?> child : children) {
            sb.append(child.toString(indent)).append(this.childrenToString(indent, child.children()));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder(indent + "ProcessorTopology:\n");
        for (SourceNode source : this.sourceByTopics.values()) {
            sb.append(source.toString(indent + "\t")).append(this.childrenToString(indent + "\t", source.children()));
        }
        return sb.toString();
    }

    public Set<String> processorConnectedStateStores(String processorName) {
        for (ProcessorNode node : this.processorNodes) {
            if (!node.name().equals(processorName)) continue;
            return node.stateStores;
        }
        return Collections.emptySet();
    }
}

