/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.suppress;

import java.time.Duration;
import java.util.Objects;
import org.apache.kafka.streams.kstream.Suppressed;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.suppress.NamedSuppressed;
import org.apache.kafka.streams.kstream.internals.suppress.SuppressedInternal;
import org.apache.kafka.streams.kstream.internals.suppress.TimeDefinitions;

public class FinalResultsSuppressionBuilder<K extends Windowed>
implements Suppressed<K>,
NamedSuppressed<K> {
    private final String name;
    private final Suppressed.StrictBufferConfig bufferConfig;

    public FinalResultsSuppressionBuilder(String name, Suppressed.StrictBufferConfig bufferConfig) {
        this.name = name;
        this.bufferConfig = bufferConfig;
    }

    public SuppressedInternal<K> buildFinalResultsSuppression(Duration gracePeriod) {
        return new SuppressedInternal(this.name, gracePeriod, this.bufferConfig, TimeDefinitions.WindowEndTimeDefinition.instance(), true);
    }

    @Override
    public Suppressed<K> withName(String name) {
        return new FinalResultsSuppressionBuilder<K>(name, this.bufferConfig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinalResultsSuppressionBuilder that = (FinalResultsSuppressionBuilder)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.bufferConfig, that.bufferConfig);
    }

    @Override
    public String name() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.bufferConfig);
    }

    public String toString() {
        return "FinalResultsSuppressionBuilder{name='" + this.name + '\'' + ", bufferConfig=" + this.bufferConfig + '}';
    }
}

