/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.slf4j.Logger;

public class CopartitionedTopicsEnforcer {
    private final String logPrefix;
    private final Logger log;

    public CopartitionedTopicsEnforcer(String logPrefix) {
        this.logPrefix = logPrefix;
        LogContext logContext = new LogContext(logPrefix);
        this.log = logContext.logger(this.getClass());
    }

    public void enforce(Set<String> copartitionGroup, Map<String, InternalTopicConfig> allRepartitionTopicsNumPartitions, Cluster metadata) {
        if (copartitionGroup.isEmpty()) {
            return;
        }
        Map<Object, InternalTopicConfig> repartitionTopicConfigs = copartitionGroup.stream().filter(allRepartitionTopicsNumPartitions::containsKey).collect(Collectors.toMap(topic -> topic, allRepartitionTopicsNumPartitions::get));
        Map<String, Integer> nonRepartitionTopicPartitions = copartitionGroup.stream().filter(topic -> !allRepartitionTopicsNumPartitions.containsKey(topic)).collect(Collectors.toMap(topic -> topic, topic -> {
            Integer partitions = metadata.partitionCountForTopic(topic);
            if (partitions == null) {
                String str = String.format("%sTopic not found: %s", this.logPrefix, topic);
                this.log.error(str);
                throw new IllegalStateException(str);
            }
            return partitions;
        }));
        int numPartitionsToUseForRepartitionTopics = copartitionGroup.equals(repartitionTopicConfigs.keySet()) ? this.getMaxPartitions(repartitionTopicConfigs) : this.getSamePartitions(nonRepartitionTopicPartitions);
        for (InternalTopicConfig config : repartitionTopicConfigs.values()) {
            config.setNumberOfPartitions(numPartitionsToUseForRepartitionTopics);
        }
    }

    private int getSamePartitions(Map<String, Integer> nonRepartitionTopicsInCopartitionGroup) {
        int partitions = nonRepartitionTopicsInCopartitionGroup.values().iterator().next();
        for (Map.Entry<String, Integer> entry : nonRepartitionTopicsInCopartitionGroup.entrySet()) {
            if (entry.getValue() == partitions) continue;
            TreeMap<String, Integer> sorted = new TreeMap<String, Integer>(nonRepartitionTopicsInCopartitionGroup);
            throw new TopologyException(String.format("%sTopics not co-partitioned: [%s]", this.logPrefix, sorted));
        }
        return partitions;
    }

    private int getMaxPartitions(Map<Object, InternalTopicConfig> repartitionTopicsInCopartitionGroup) {
        int maxPartitions = 0;
        for (InternalTopicConfig config : repartitionTopicsInCopartitionGroup.values()) {
            Optional<Integer> partitions = config.numberOfPartitions();
            maxPartitions = Integer.max(maxPartitions, partitions.orElse(maxPartitions));
        }
        if (maxPartitions <= 0) {
            throw new IllegalStateException(this.logPrefix + "Could not validate the copartitioning of topics: " + repartitionTopicsInCopartitionGroup.keySet());
        }
        return maxPartitions;
    }
}

