/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.streams.state.internals.metrics.RocksDBMetricsRecorder;

public class RocksDBMetricsRecordingTrigger
implements Runnable {
    private final Map<String, RocksDBMetricsRecorder> metricsRecordersToTrigger = new ConcurrentHashMap<String, RocksDBMetricsRecorder>();

    public void addMetricsRecorder(RocksDBMetricsRecorder metricsRecorder) {
        String metricsRecorderName = this.metricsRecorderName(metricsRecorder);
        if (this.metricsRecordersToTrigger.containsKey(metricsRecorderName)) {
            throw new IllegalStateException("RocksDB metrics recorder for store \"" + metricsRecorder.storeName() + "\" of task " + metricsRecorder.taskId().toString() + " has already been added. This is a bug in Kafka Streams.");
        }
        this.metricsRecordersToTrigger.put(metricsRecorderName, metricsRecorder);
    }

    public void removeMetricsRecorder(RocksDBMetricsRecorder metricsRecorder) {
        RocksDBMetricsRecorder removedMetricsRecorder = this.metricsRecordersToTrigger.remove(this.metricsRecorderName(metricsRecorder));
        if (removedMetricsRecorder == null) {
            throw new IllegalStateException("No RocksDB metrics recorder for store \"" + metricsRecorder.storeName() + "\" of task " + metricsRecorder.taskId() + " could be found. This is a bug in Kafka Streams.");
        }
    }

    private String metricsRecorderName(RocksDBMetricsRecorder metricsRecorder) {
        return metricsRecorder.taskId().toString() + "-" + metricsRecorder.storeName();
    }

    @Override
    public void run() {
        for (RocksDBMetricsRecorder metricsRecorder : this.metricsRecordersToTrigger.values()) {
            metricsRecorder.record();
        }
    }
}

