/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.StringJoiner;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.OptionChecker;
import javax.tools.ToolProvider;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.Language;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.PathType;
import org.apache.maven.api.Project;
import org.apache.maven.api.ProjectScope;
import org.apache.maven.api.Session;
import org.apache.maven.api.SourceRoot;
import org.apache.maven.api.Toolchain;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.Mojo;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.DependencyResolver;
import org.apache.maven.api.services.DependencyResolverRequest;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.api.services.MessageBuilder;
import org.apache.maven.api.services.MessageBuilderFactory;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.api.services.ToolchainManager;
import org.apache.maven.plugin.compiler.ByteCodeTransformer;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.DependencyCoordinate;
import org.apache.maven.plugin.compiler.DiagnosticLogger;
import org.apache.maven.plugin.compiler.ForkedCompiler;
import org.apache.maven.plugin.compiler.IncrementalBuild;
import org.apache.maven.plugin.compiler.Options;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.SourcePathType;
import org.apache.maven.plugin.compiler.SourcesForRelease;
import org.apache.maven.plugin.compiler.ToolExecutor;

public abstract class AbstractCompilerMojo
implements Mojo {
    static final boolean SUPPORT_LEGACY = true;
    private static final String DEFAULT_EXECUTABLE = "javac";
    @Parameter(property="maven.compiler.moduleVersion", defaultValue="${project.version}")
    protected String moduleVersion;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="maven.compiler.source")
    protected String source;
    @Parameter(property="maven.compiler.target")
    protected String target;
    @Parameter(property="maven.compiler.release")
    protected String release;
    private boolean targetOrReleaseSet;
    private SourceVersion supportedVersion;
    @Parameter(property="maven.compiler.enablePreview", defaultValue="false")
    protected boolean enablePreview;
    @Parameter
    @Deprecated(since="4.0.0")
    protected List<String> compileSourceRoots;
    @Parameter
    protected List<String> compilerArgs;
    @Parameter
    @Deprecated(since="4.0.0")
    protected String compilerArgument;
    @Parameter(property="maven.compiler.proc")
    protected String proc;
    @Parameter
    protected String[] annotationProcessors;
    @Parameter
    @Deprecated(since="4.0.0")
    protected List<DependencyCoordinate> annotationProcessorPaths;
    @Deprecated(since="4.0.0")
    @Parameter(defaultValue="false")
    protected boolean annotationProcessorPathsUseDepMgmt;
    @Parameter(property="maven.compiler.createMissingPackageInfoClass", defaultValue="false")
    protected boolean createMissingPackageInfoClass;
    @Parameter(property="maven.compiler.implicit")
    protected String implicit;
    @Parameter(property="maven.compiler.parameters", defaultValue="false")
    protected boolean parameters;
    @Deprecated(since="4.0.0")
    @Parameter(property="maven.compiler.debug", defaultValue="true")
    protected boolean debug = true;
    @Parameter(property="maven.compiler.debuglevel")
    protected String debuglevel;
    @Deprecated(forRemoval=true)
    @Parameter(property="maven.compiler.optimize")
    protected Boolean optimize;
    @Parameter(property="maven.compiler.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="maven.compiler.showCompilationChanges", defaultValue="false")
    protected boolean showCompilationChanges;
    @Parameter(property="maven.compiler.showDeprecation", defaultValue="false")
    protected boolean showDeprecation;
    @Parameter(property="maven.compiler.showWarnings", defaultValue="true")
    protected boolean showWarnings = true;
    @Parameter(property="maven.compiler.failOnWarning", defaultValue="false")
    protected boolean failOnWarning;
    @Parameter(property="maven.compiler.failOnError", defaultValue="true")
    protected boolean failOnError = true;
    @Parameter
    @Deprecated(since="4.0.0", forRemoval=true)
    protected String outputFileName;
    @Deprecated(since="4.0.0", forRemoval=true)
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    protected String outputTimestamp;
    @Parameter(property="maven.compiler.incrementalCompilation")
    protected String incrementalCompilation;
    @Deprecated(since="4.0.0")
    @Parameter(property="maven.compiler.useIncrementalCompilation")
    protected Boolean useIncrementalCompilation;
    @Parameter(defaultValue="class,jar")
    protected List<String> fileExtensions;
    @Parameter(property="lastModGranularityMs", defaultValue="0")
    protected int staleMillis;
    @Parameter(property="maven.compiler.fork", defaultValue="false")
    protected boolean fork;
    @Parameter
    protected Map<String, String> jdkToolchain;
    @Parameter(property="maven.compiler.compilerId")
    protected String compilerId;
    @Deprecated(since="4.0.0", forRemoval=true)
    @Parameter(property="maven.compiler.compilerVersion")
    protected String compilerVersion;
    @Deprecated(since="4.0.0", forRemoval=true)
    @Parameter(property="maven.compiler.forceLegacyJavacApi")
    protected Boolean forceLegacyJavacApi;
    @Deprecated(since="4.0.0", forRemoval=true)
    @Parameter(property="maven.compiler.forceJavacCompilerUse")
    protected Boolean forceJavacCompilerUse;
    @Deprecated(since="4.0.0", forRemoval=true)
    @Parameter(property="maven.compiler.compilerReuseStrategy")
    protected String compilerReuseStrategy;
    @Deprecated(since="4.0.0", forRemoval=true)
    @Parameter(property="maven.compiler.skipMultiThreadWarning")
    protected Boolean skipMultiThreadWarning;
    @Parameter(property="maven.compiler.executable")
    protected String executable;
    @Parameter(property="maven.compiler.meminitial")
    protected String meminitial;
    @Parameter(property="maven.compiler.maxmem")
    protected String maxmem;
    @Parameter(defaultValue="${project.basedir}", required=true, readonly=true)
    protected Path basedir;
    @Parameter(defaultValue="${project.build.directory}/maven-status/${mojo.plugin.descriptor.artifactId}/${mojo.executionId}.cache", required=true, readonly=true)
    protected Path mojoStatusPath;
    @Inject
    protected Session session;
    @Inject
    protected Project project;
    @Inject
    protected ProjectManager projectManager;
    @Inject
    protected ArtifactManager artifactManager;
    @Inject
    protected ToolchainManager toolchainManager;
    @Inject
    protected MessageBuilderFactory messageBuilderFactory;
    @Inject
    protected Log logger;
    private String mavenCompilerPluginVersion;
    private String tipForCommandLineCompilation;
    final PathScope compileScope;

    final Charset charset() {
        if (this.encoding != null) {
            try {
                return Charset.forName(this.encoding);
            }
            catch (UnsupportedCharsetException e) {
                throw new CompilationFailureException("Invalid 'encoding' option: " + this.encoding, e);
            }
        }
        return null;
    }

    final EnumSet<IncrementalBuild.Aspect> incrementalCompilationConfiguration() {
        if (this.incrementalCompilation == null || this.incrementalCompilation.isBlank()) {
            if (this.useIncrementalCompilation != null) {
                return this.useIncrementalCompilation != false ? EnumSet.of(IncrementalBuild.Aspect.DEPENDENCIES, IncrementalBuild.Aspect.SOURCES, IncrementalBuild.Aspect.REBUILD_ON_ADD) : EnumSet.of(IncrementalBuild.Aspect.CLASSES);
            }
            EnumSet<IncrementalBuild.Aspect> aspects = EnumSet.of(IncrementalBuild.Aspect.OPTIONS, IncrementalBuild.Aspect.DEPENDENCIES, IncrementalBuild.Aspect.SOURCES);
            if (this.hasAnnotationProcessor(false)) {
                aspects.add(IncrementalBuild.Aspect.REBUILD_ON_ADD);
                aspects.add(IncrementalBuild.Aspect.REBUILD_ON_CHANGE);
            }
            return aspects;
        }
        return IncrementalBuild.Aspect.parse(this.incrementalCompilation);
    }

    protected AbstractCompilerMojo(PathScope compileScope) {
        this.compileScope = compileScope;
    }

    protected abstract Set<String> getIncludes();

    protected abstract Set<String> getExcludes();

    protected abstract Set<String> getIncrementalExcludes();

    final boolean hasNoFileMatchers() {
        return this.getIncludes().isEmpty() && this.getExcludes().isEmpty() && this.getIncrementalExcludes().isEmpty();
    }

    @Nonnull
    protected abstract Path getOutputDirectory();

    @Nullable
    protected String getSource() {
        return this.source;
    }

    @Nullable
    protected String getTarget() {
        return this.target;
    }

    @Nullable
    protected String getRelease() {
        return this.release;
    }

    final Stream<SourceRoot> getSourceRoots(ProjectScope scope) {
        return this.projectManager.getEnabledSourceRoots(this.project, scope, Language.JAVA_FAMILY);
    }

    final List<SourceDirectory> getSourceDirectories(Path outputDirectory) throws IOException {
        if (this.compileSourceRoots == null || this.compileSourceRoots.isEmpty()) {
            Stream<SourceRoot> roots = this.getSourceRoots(this.compileScope.projectScope());
            return SourceDirectory.fromProject(roots, this.getRelease(), outputDirectory);
        }
        return SourceDirectory.fromPluginConfiguration(this.compileSourceRoots, this.moduleOfPreviousExecution(), this.getRelease(), outputDirectory);
    }

    @Nullable
    protected abstract Path getGeneratedSourcesDirectory();

    @Deprecated(since="4.0.0")
    String moduleOfPreviousExecution() throws IOException {
        return null;
    }

    boolean hasModuleDeclaration(List<SourceDirectory> roots) throws IOException {
        return switch (this.project.getPackaging().type().id()) {
            case "classpath-jar" -> false;
            case "modular-jar" -> true;
            default -> {
                for (SourceDirectory root : roots) {
                    if (!root.getModuleInfo().isPresent()) continue;
                    yield true;
                }
                yield false;
            }
        };
    }

    @Nullable
    protected abstract String getDebugFileName();

    final Path getDebugFilePath() {
        String filename = this.getDebugFileName();
        if (filename == null || filename.isBlank()) {
            return null;
        }
        return Path.of(this.project.getBuild().getOutputDirectory(), new String[0]).resolveSibling(filename);
    }

    final boolean shouldWriteDebugFile() {
        return this.verbose || this.logger.isDebugEnabled();
    }

    public void execute() throws MojoException {
        JavaCompiler compiler = this.compiler();
        for (SourceVersion version : compiler.getSourceVersions()) {
            if (this.supportedVersion != null && version.compareTo(this.supportedVersion) < 0) continue;
            this.supportedVersion = version;
        }
        Options configuration = this.parseParameters(compiler);
        try {
            this.compile(compiler, configuration);
        }
        catch (RuntimeException e) {
            int s;
            String message = e.getLocalizedMessage();
            if (message == null) {
                message = e.getClass().getSimpleName();
            } else if (e instanceof MojoException && (s = message.indexOf(System.lineSeparator())) >= 0) {
                message = message.substring(0, s);
            }
            MessageBuilder mb = this.messageBuilderFactory.builder().strong((Object)"COMPILATION ERROR: ").a((CharSequence)message);
            this.logger.error((CharSequence)mb.toString(), (Throwable)(this.verbose ? e : null));
            if (this.tipForCommandLineCompilation != null) {
                this.logger.info((CharSequence)this.tipForCommandLineCompilation);
                this.tipForCommandLineCompilation = null;
            }
            if (this.failOnError) {
                throw e;
            }
        }
        catch (IOException e) {
            this.logger.error((CharSequence)"I/O error while compiling the project.", (Throwable)e);
            throw new CompilationFailureException("I/O error while compiling the project.", e);
        }
    }

    public ToolExecutor createExecutor(DiagnosticListener<? super JavaFileObject> listener) throws IOException {
        ToolExecutor executor = new ToolExecutor(this, listener);
        if (!this.targetOrReleaseSet && !executor.isReleaseSpecifiedForAll()) {
            MessageBuilder mb = this.messageBuilderFactory.builder().a((CharSequence)"No explicit value set for --release or --target. To ensure the same result in different environments, please add").newline().newline();
            this.writePlugin(mb, "release", String.valueOf(Runtime.version().feature()));
            this.logger.warn((CharSequence)mb.build());
        }
        return executor;
    }

    public JavaCompiler compiler() throws MojoException {
        this.getToolchain().ifPresent(tc -> {
            this.logger.info((CharSequence)("Toolchain in maven-compiler-plugin is \"" + String.valueOf(tc) + "\"."));
            if (this.executable != null) {
                this.logger.warn((CharSequence)("Toolchains are ignored because the 'executable' parameter is set to \"" + this.executable + "\"."));
            } else {
                this.fork = true;
                if (this.compilerId == null) {
                    this.compilerId = DEFAULT_EXECUTABLE;
                }
                this.executable = tc.findTool(this.compilerId);
            }
        });
        if (this.fork) {
            if (this.executable == null) {
                this.executable = DEFAULT_EXECUTABLE;
            }
            return new ForkedCompiler(this);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("Using " + (String)(this.compilerId != null ? "compiler \"" + this.compilerId + "\"" : "system compiler") + "."));
        }
        if (this.compilerId == null) {
            this.compilerId = DEFAULT_EXECUTABLE;
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler != null) {
                return compiler;
            }
        } else {
            for (JavaCompiler t : ServiceLoader.load(JavaCompiler.class)) {
                if (!this.compilerId.equals(t.name())) continue;
                return t;
            }
        }
        throw new CompilationFailureException("No such \"" + this.compilerId + "\" compiler.");
    }

    public Options parseParameters(OptionChecker compiler) {
        Options configuration = new Options(compiler, this.logger);
        configuration.addIfNonBlank("--source", this.getSource());
        this.targetOrReleaseSet = configuration.addIfNonBlank("--target", this.getTarget());
        this.targetOrReleaseSet |= configuration.setRelease(this.getRelease());
        configuration.addIfTrue("--enable-preview", this.enablePreview);
        configuration.addComaSeparated("-proc", this.proc, List.of("none", "only", "full"), null);
        if (this.annotationProcessors != null) {
            StringJoiner list = new StringJoiner(",");
            for (String p : this.annotationProcessors) {
                list.add(p);
            }
            configuration.addIfNonBlank("-processor", list.toString());
        }
        configuration.addComaSeparated("-implicit", this.implicit, List.of("none", "class"), null);
        configuration.addIfTrue("-parameters", this.parameters);
        configuration.addIfTrue("-Xpkginfo:always", this.createMissingPackageInfoClass);
        if (this.debug) {
            configuration.addComaSeparated("-g", this.debuglevel, List.of("lines", "vars", "source", "all", "none"), options -> Arrays.asList(options).contains("all") ? new String[]{} : options);
        } else {
            configuration.addIfTrue("-g:none", true);
        }
        configuration.addIfNonBlank("--module-version", this.moduleVersion);
        configuration.addIfTrue("-deprecation", this.showDeprecation);
        configuration.addIfTrue("-nowarn", !this.showWarnings);
        configuration.addIfTrue("-Werror", this.failOnWarning);
        configuration.addIfTrue("-verbose", this.verbose);
        if (this.fork) {
            configuration.addMemoryValue("-J-Xms", "meminitial", this.meminitial, true);
            configuration.addMemoryValue("-J-Xmx", "maxmem", this.maxmem, true);
        }
        return configuration;
    }

    private void compile(JavaCompiler compiler, Options configuration) throws IOException {
        byte[] oridinal;
        byte[] modified;
        Path moduleDescriptor;
        boolean success;
        ToolExecutor executor = this.createExecutor(null);
        if (!executor.applyIncrementalBuild(this, configuration)) {
            return;
        }
        Exception failureCause = null;
        StringWriter compilerOutput = new StringWriter();
        try {
            success = executor.compile(compiler, configuration, compilerOutput);
        }
        catch (Exception e) {
            success = false;
            failureCause = e;
        }
        String additionalMessage = compilerOutput.toString();
        if (!additionalMessage.isBlank()) {
            if (success || failureCause != null) {
                this.logger.warn((CharSequence)additionalMessage);
            } else {
                this.logger.error((CharSequence)additionalMessage);
            }
        }
        if (failureCause != null) {
            String message = failureCause.getMessage();
            if (message != null) {
                this.logger.error((CharSequence)message);
            } else {
                this.logger.error((Throwable)failureCause);
            }
        }
        if (!success || this.shouldWriteDebugFile()) {
            IOException suppressed = null;
            try {
                this.writeDebugFile(executor, configuration, success);
                if (success && this.tipForCommandLineCompilation != null) {
                    this.logger.debug((CharSequence)this.tipForCommandLineCompilation);
                    this.tipForCommandLineCompilation = null;
                }
            }
            catch (IOException e) {
                suppressed = e;
            }
            if (!success) {
                StringBuilder message = new StringBuilder(100).append("Cannot compile ").append(this.project.getId()).append(' ').append(this.compileScope.projectScope().id()).append(" classes.");
                DiagnosticListener<? super JavaFileObject> diagnosticListener = executor.listener;
                if (diagnosticListener instanceof DiagnosticLogger) {
                    DiagnosticLogger diagnostic = (DiagnosticLogger)diagnosticListener;
                    diagnostic.firstError(failureCause).ifPresent(c -> message.append(System.lineSeparator()).append("The first error is: ").append((String)c));
                }
                CompilationFailureException failure = new CompilationFailureException(message.toString(), failureCause);
                if (suppressed != null) {
                    failure.addSuppressed(suppressed);
                }
                throw failure;
            }
            if (suppressed != null) {
                throw suppressed;
            }
        }
        if (!this.isVersionEqualOrNewer("RELEASE_22") && Files.isRegularFile(moduleDescriptor = executor.outputDirectory.resolve("module-info.class"), new LinkOption[0]) && (modified = ByteCodeTransformer.patchJdkModuleVersion(oridinal = Files.readAllBytes(moduleDescriptor), this.getRelease(), this.logger)) != null) {
            Files.write(moduleDescriptor, modified, new OpenOption[0]);
        }
    }

    private boolean isVersionEqualOrNewer(String sourceVersion) {
        SourceVersion requested;
        try {
            requested = SourceVersion.valueOf(sourceVersion);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        if (this.supportedVersion == null) {
            this.supportedVersion = SourceVersion.latestSupported();
        }
        return this.supportedVersion.compareTo(requested) >= 0;
    }

    private Optional<Toolchain> getToolchain() {
        List tcs;
        if (this.jdkToolchain != null && (tcs = this.toolchainManager.getToolchains(this.session, "jdk", this.jdkToolchain)) != null && !tcs.isEmpty()) {
            return Optional.of((Toolchain)tcs.get(0));
        }
        return this.toolchainManager.getToolchainFromBuildContext(this.session, "jdk");
    }

    final String parseModuleInfoName(Path source) throws IOException {
        if (source != null && Files.exists(source, new LinkOption[0])) {
            Charset charset = this.charset();
            try (BufferedReader in = charset != null ? Files.newBufferedReader(source, charset) : Files.newBufferedReader(source);){
                int t;
                StreamTokenizer tokenizer = new StreamTokenizer(in);
                tokenizer.slashSlashComments(true);
                tokenizer.slashStarComments(true);
                while ((t = tokenizer.nextToken()) != -1) {
                    if (t != -3 || !"module".equals(tokenizer.sval)) continue;
                    while ((t = tokenizer.nextToken()) == 10) {
                    }
                    if (t != -3) break;
                    String string = tokenizer.sval;
                    return string;
                }
            }
        }
        return null;
    }

    final DependencyResolverResult resolveDependencies(boolean hasModuleDeclaration) throws IOException {
        String warning;
        DependencyResolver resolver = (DependencyResolver)this.session.getService(DependencyResolver.class);
        if (resolver == null) {
            return null;
        }
        EnumSet<JavaPathType> allowedTypes = EnumSet.of(JavaPathType.CLASSES, JavaPathType.PROCESSOR_CLASSES);
        if (hasModuleDeclaration) {
            allowedTypes.add(JavaPathType.MODULES);
            allowedTypes.add(JavaPathType.PROCESSOR_MODULES);
        }
        DependencyResolverResult dependencies = resolver.resolve(DependencyResolverRequest.builder().session(this.session).project(this.project).requestType(DependencyResolverRequest.RequestType.RESOLVE).pathScope(this.compileScope).pathTypeFilter(allowedTypes).build());
        Object exception = null;
        for (Exception cause : dependencies.getExceptions()) {
            if (exception != null) {
                exception.addSuppressed(cause);
                continue;
            }
            if (cause instanceof UncheckedIOException) {
                UncheckedIOException e = (UncheckedIOException)cause;
                exception = e.getCause();
                continue;
            }
            if (cause instanceof RuntimeException || cause instanceof IOException) {
                exception = cause;
                continue;
            }
            exception = new CompilationFailureException("Cannot collect the compile-time dependencies.", cause);
        }
        if (exception != null) {
            if (exception instanceof IOException) {
                IOException e = (IOException)exception;
                throw e;
            }
            throw (RuntimeException)exception;
        }
        if (ProjectScope.MAIN.equals((Object)this.compileScope.projectScope()) && (warning = (String)dependencies.warningForFilenameBasedAutomodules().orElse(null)) != null) {
            this.logger.warn((CharSequence)warning);
        }
        return dependencies;
    }

    @Deprecated(since="4.0.0")
    final void resolveProcessorPathEntries(Map<PathType, List<Path>> addTo) throws MojoException {
        List<DependencyCoordinate> dependencies = this.annotationProcessorPaths;
        if (dependencies != null && !dependencies.isEmpty()) {
            try {
                List<DependencyCoordinates> coords = dependencies.stream().map(coord -> coord.toCoordinate(this.project, this.session)).toList();
                Session sessionWithRepo = this.session.withRemoteRepositories(this.projectManager.getRemoteProjectRepositories(this.project));
                addTo.merge((PathType)JavaPathType.PROCESSOR_CLASSES, ((DependencyResolver)sessionWithRepo.getService(DependencyResolver.class)).resolve(DependencyResolverRequest.builder().session(sessionWithRepo).dependencies(coords).managedDependencies(this.project.getManagedDependencies()).requestType(DependencyResolverRequest.RequestType.RESOLVE).pathScope(PathScope.MAIN_RUNTIME).build()).getPaths(), (oldPaths, newPaths) -> {
                    oldPaths.addAll(newPaths);
                    return oldPaths;
                });
            }
            catch (MojoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CompilationFailureException("Resolution of annotationProcessorPath dependencies failed: " + e.getMessage(), e);
            }
        }
    }

    private boolean hasAnnotationProcessor(boolean strict) {
        if ("none".equalsIgnoreCase(this.proc)) {
            return false;
        }
        if (this.proc == null || this.proc.isBlank()) {
            if (strict && !this.isVersionEqualOrNewer("RELEASE_23")) {
                return true;
            }
            if (!(this.annotationProcessors != null && this.annotationProcessors.length != 0 || this.annotationProcessorPaths != null && !this.annotationProcessorPaths.isEmpty())) {
                DependencyResolver resolver = (DependencyResolver)this.session.getService(DependencyResolver.class);
                if (resolver == null) {
                    return false;
                }
                EnumSet<JavaPathType> allowedTypes = EnumSet.of(JavaPathType.PROCESSOR_CLASSES, JavaPathType.PROCESSOR_MODULES);
                DependencyResolverResult dependencies = resolver.resolve(DependencyResolverRequest.builder().session(this.session).project(this.project).requestType(DependencyResolverRequest.RequestType.COLLECT).pathScope(this.compileScope).pathTypeFilter(allowedTypes).build());
                return !dependencies.getDependencies().isEmpty();
            }
        }
        return true;
    }

    final Set<Path> addGeneratedSourceDirectory() throws IOException {
        Path generatedSourcesDirectory = this.getGeneratedSourcesDirectory();
        if (generatedSourcesDirectory == null) {
            return Set.of();
        }
        if (this.hasAnnotationProcessor(true)) {
            generatedSourcesDirectory = Files.createDirectories(generatedSourcesDirectory, new FileAttribute[0]);
        } else if (Files.notExists(generatedSourcesDirectory, new LinkOption[0])) {
            return Set.of();
        }
        ProjectScope scope = this.compileScope.projectScope();
        this.projectManager.addSourceRoot(this.project, scope, Language.JAVA_FAMILY, generatedSourcesDirectory.toAbsolutePath());
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Adding \"").append(generatedSourcesDirectory).append("\" to ").append(scope.id()).append("-compile source roots. New roots are:");
            this.projectManager.getEnabledSourceRoots(this.project, scope, Language.JAVA_FAMILY).forEach(p -> sb.append(System.lineSeparator()).append("    ").append(p.directory()));
            this.logger.debug((CharSequence)sb.toString());
        }
        return Set.of(generatedSourcesDirectory);
    }

    private void writePlugin(MessageBuilder mb, String option, String value) {
        if (this.mavenCompilerPluginVersion == null) {
            try (InputStream is = AbstractCompilerMojo.class.getResourceAsStream("/META-INF/MANIFEST.MF");){
                if (is != null) {
                    this.mavenCompilerPluginVersion = new Manifest(is).getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.mavenCompilerPluginVersion == null) {
                this.mavenCompilerPluginVersion = "";
            }
        }
        mb.a((CharSequence)"    <plugin>").newline();
        mb.a((CharSequence)"      <groupId>org.apache.maven.plugins</groupId>").newline();
        mb.a((CharSequence)"      <artifactId>maven-compiler-plugin</artifactId>").newline();
        if (this.mavenCompilerPluginVersion != null && !this.mavenCompilerPluginVersion.isBlank()) {
            mb.a((CharSequence)"      <version>").a((CharSequence)this.mavenCompilerPluginVersion).a((CharSequence)"</version>").newline();
        }
        mb.a((CharSequence)"      <configuration>").newline();
        mb.a((CharSequence)"        <").a((CharSequence)option).a((Object)Character.valueOf('>')).a((CharSequence)value).a((CharSequence)"</").a((CharSequence)option).a((Object)Character.valueOf('>')).newline();
        mb.a((CharSequence)"      </configuration>").newline();
        mb.a((CharSequence)"    </plugin>").newline();
    }

    private void writeDebugFile(ToolExecutor executor, Options configuration, boolean showBaseVersion) throws IOException {
        String chdir;
        Path debugFilePath = this.getDebugFilePath();
        if (debugFilePath == null) {
            this.logger.warn((CharSequence)"The <debugFileName> parameter should not be empty.");
            return;
        }
        StringBuilder commandLine = new StringBuilder("For trying to compile from the command-line, use:");
        Path dir = this.basedir;
        if (dir != null && !(chdir = (dir = Path.of(System.getProperty("user.dir"), new String[0]).relativize(dir)).toString()).isEmpty()) {
            boolean isWindows = File.separatorChar == '\\';
            commandLine.append(System.lineSeparator()).append("    ").append(isWindows ? "chdir " : "cd ").append(chdir);
        }
        commandLine.append(System.lineSeparator()).append("    ").append(this.executable != null ? this.executable : this.compilerId);
        Path pathForRelease = debugFilePath;
        int count = executor.sourcesForDebugFile.size();
        int indexToShow = showBaseVersion ? 0 : count - 1;
        for (int i = 0; i < count; ++i) {
            SourcesForRelease sources = executor.sourcesForDebugFile.get(i);
            if (i != 0) {
                String version = sources.outputForRelease.getFileName().toString();
                Object filename = debugFilePath.getFileName().toString();
                int n = ((String)filename).lastIndexOf(46);
                filename = n >= 0 ? ((String)filename).substring(0, n) + "-" + version + ((String)filename).substring(n) : (String)filename + "-" + version;
                pathForRelease = debugFilePath.resolveSibling((String)filename);
            }
            try (BufferedWriter out = Files.newBufferedWriter(pathForRelease, new OpenOption[0]);){
                configuration.setRelease(sources.getReleaseString());
                configuration.format(i == indexToShow ? commandLine : null, out);
                for (Map.Entry<PathType, List<Path>> entry : sources.dependencySnapshot.entrySet()) {
                    this.writeOption(out, entry.getKey(), (Collection<Path>)entry.getValue());
                }
                for (Map.Entry<Object, Collection<Path>> entry : sources.roots.entrySet()) {
                    String moduleName = (String)entry.getKey();
                    this.writeOption(out, SourcePathType.valueOf(moduleName), entry.getValue());
                }
                out.write("-d \"");
                out.write(this.relativize(sources.outputForRelease).toString());
                out.write(34);
                out.newLine();
                for (Path path : sources.files) {
                    out.write(34);
                    out.write(this.relativize(path).toString());
                    out.write(34);
                    out.newLine();
                }
                continue;
            }
        }
        Path path = this.relativize(showBaseVersion ? debugFilePath : pathForRelease);
        this.tipForCommandLineCompilation = commandLine.append(" @").append(path).toString();
    }

    private void writeOption(BufferedWriter out, PathType type, Collection<Path> files) throws IOException {
        if (!files.isEmpty()) {
            files = files.stream().map(this::relativize).toList();
            String separator = "";
            for (String element : type.option(files)) {
                out.write(separator);
                out.write(element);
                separator = " ";
            }
            out.newLine();
        }
    }

    private Path relativize(Path file) {
        Path root;
        Path dir = this.basedir;
        if (dir != null && (root = this.project.getRootDirectory()) != null && file.startsWith(root)) {
            try {
                file = dir.relativize(file);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return file;
    }
}

