/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.failsafe.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.maven.surefire.api.suite.RunResult;
import org.apache.maven.surefire.shared.lang3.StringEscapeUtils;
import org.apache.maven.surefire.shared.utils.StringUtils;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class FailsafeSummaryXmlUtils {
    private static final String FAILSAFE_SUMMARY_XML_SCHEMA_LOCATION = "https://maven.apache.org/surefire/maven-surefire-plugin/xsd/failsafe-summary.xsd";
    private static final String MESSAGE_NIL_ELEMENT = "<failureMessage xsi:nil=\"true\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"/>";
    private static final String MESSAGE_ELEMENT = "<failureMessage>%s</failureMessage>";
    private static final String FAILSAFE_SUMMARY_XML_TEMPLATE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<failsafe-summary xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"https://maven.apache.org/surefire/maven-surefire-plugin/xsd/failsafe-summary.xsd\" result=\"%s\" timeout=\"%s\">\n    <completed>%d</completed>\n    <errors>%d</errors>\n    <failures>%d</failures>\n    <skipped>%d</skipped>\n    %s\n</failsafe-summary>";

    private FailsafeSummaryXmlUtils() {
        throw new IllegalStateException("No instantiable constructor.");
    }

    public static RunResult toRunResult(File failsafeSummaryXml) throws Exception {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(failsafeSummaryXml), StandardCharsets.UTF_8);){
            Node root = (Node)xpath.evaluate("/", new InputSource(reader), XPathConstants.NODE);
            String completed = xpath.evaluate("/failsafe-summary/completed", root);
            String errors = xpath.evaluate("/failsafe-summary/errors", root);
            String failures = xpath.evaluate("/failsafe-summary/failures", root);
            String skipped = xpath.evaluate("/failsafe-summary/skipped", root);
            String failureMessage = xpath.evaluate("/failsafe-summary/failureMessage", root);
            String timeout = xpath.evaluate("/failsafe-summary/@timeout", root);
            RunResult runResult = new RunResult(Integer.parseInt(completed), Integer.parseInt(errors), Integer.parseInt(failures), Integer.parseInt(skipped), StringUtils.isBlank((String)failureMessage) ? null : StringEscapeUtils.unescapeXml((String)failureMessage), Boolean.parseBoolean(timeout));
            return runResult;
        }
    }

    public static void fromRunResultToFile(RunResult fromRunResult, File toFailsafeSummaryXml) throws IOException {
        String failure = fromRunResult.getFailure();
        String msg = StringUtils.isBlank((String)failure) ? MESSAGE_NIL_ELEMENT : String.format(MESSAGE_ELEMENT, StringEscapeUtils.escapeXml10((String)failure));
        String xml = String.format(Locale.ROOT, FAILSAFE_SUMMARY_XML_TEMPLATE, fromRunResult.getFailsafeCode(), fromRunResult.isTimeout(), fromRunResult.getCompletedCount(), fromRunResult.getErrors(), fromRunResult.getFailures(), fromRunResult.getSkipped(), msg);
        Files.write(toFailsafeSummaryXml.toPath(), xml.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
    }

    public static void writeSummary(RunResult mergedSummary, File mergedSummaryFile, boolean inProgress) throws Exception {
        if (!mergedSummaryFile.getParentFile().isDirectory()) {
            mergedSummaryFile.getParentFile().mkdirs();
        }
        if (mergedSummaryFile.exists() && inProgress) {
            RunResult runResult = FailsafeSummaryXmlUtils.toRunResult(mergedSummaryFile);
            mergedSummary = mergedSummary.aggregate(runResult);
        }
        FailsafeSummaryXmlUtils.fromRunResultToFile(mergedSummary, mergedSummaryFile);
    }
}

