/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.javadoc;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.library.OrderedClassLibraryBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaConstructor;
import com.thoughtworks.qdox.model.JavaExecutable;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaGenericDeclaration;
import com.thoughtworks.qdox.model.JavaMember;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaTypeVariable;
import com.thoughtworks.qdox.parser.ParseException;
import com.thoughtworks.qdox.type.TypeResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.javadoc.JavadocUtil;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.languages.java.version.JavaVersion;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractFixJavadocMojo
extends AbstractMojo {
    private static final String EOL = System.getProperty("line.separator");
    private static final String AUTHOR_TAG = "author";
    private static final String VERSION_TAG = "version";
    private static final String SINCE_TAG = "since";
    private static final String PARAM_TAG = "param";
    private static final String RETURN_TAG = "return";
    private static final String THROWS_TAG = "throws";
    private static final String LINK_TAG = "link";
    private static final String INHERITED_TAG = "{@inheritDoc}";
    private static final String START_JAVADOC = "/**";
    private static final String END_JAVADOC = "*/";
    private static final String SEPARATOR_JAVADOC = " * ";
    private static final String INHERITED_JAVADOC = "/** {@inheritDoc} */";
    private static final String FIX_TAGS_ALL = "all";
    private static final String LEVEL_PUBLIC = "public";
    private static final String LEVEL_PROTECTED = "protected";
    private static final String LEVEL_PACKAGE = "package";
    private static final String LEVEL_PRIVATE = "private";
    private static final String CLIRR_MAVEN_PLUGIN_GROUPID = "org.codehaus.mojo";
    private static final String CLIRR_MAVEN_PLUGIN_ARTIFACTID = "clirr-maven-plugin";
    private static final String CLIRR_MAVEN_PLUGIN_VERSION = "2.2.2";
    private static final String CLIRR_MAVEN_PLUGIN_GOAL = "check";
    public static final String JAVA_FILES = "**\\/*.java";
    public static final String DEFAULT_VERSION_VALUE = "$Id: $Id";
    @Component
    private InputHandler inputHandler;
    @Parameter(property="comparisonVersion", defaultValue="(,${project.version})")
    private String comparisonVersion;
    @Parameter(property="defaultAuthor")
    private String defaultAuthor;
    @Parameter(property="defaultSince", defaultValue="${project.version}")
    private String defaultSince;
    @Parameter(property="defaultVersion", defaultValue="$Id: $Id")
    private String defaultVersion = "$Id: $";
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="excludes")
    private String excludes;
    @Parameter(property="fixTags", defaultValue="all")
    private String fixTags;
    @Parameter(property="fixClassComment", defaultValue="true")
    private boolean fixClassComment;
    @Parameter(property="fixFieldComment", defaultValue="true")
    private boolean fixFieldComment;
    @Parameter(property="fixMethodComment", defaultValue="true")
    private boolean fixMethodComment;
    @Parameter(property="removeUnknownThrows", defaultValue="true")
    private boolean removeUnknownThrows;
    @Parameter(property="force")
    private boolean force;
    @Parameter(property="ignoreClirr", defaultValue="false")
    protected boolean ignoreClirr;
    @Parameter(property="includes", defaultValue="**\\/*.java")
    private String includes;
    @Parameter(property="level", defaultValue="protected")
    private String level;
    @Parameter(property="outputDirectory", defaultValue="${project.build.sourceDirectory}")
    private File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    private ClassLoader projectClassLoader;
    private String[] fixTagsSplitted;
    private List<String> clirrNewClasses;
    private Map<String, List<String>> clirrNewMethods;
    private List<String> sinceClasses;
    private static final Pattern REPLACE_LINK_TAGS_PATTERN = Pattern.compile("\\{@link\\s");

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!(this.fixClassComment || this.fixFieldComment || this.fixMethodComment)) {
            this.getLog().info((CharSequence)"Specified to NOT fix classes, fields and methods. Nothing to do.");
            return;
        }
        this.init();
        if (this.fixTagsSplitted.length == 0) {
            this.getLog().info((CharSequence)"No fix tag specified. Nothing to do.");
            return;
        }
        if (!this.preCheck()) {
            return;
        }
        try {
            this.executeClirr();
        }
        catch (MavenInvocationException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().error((CharSequence)("MavenInvocationException: " + e.getMessage()), (Throwable)e);
            } else {
                this.getLog().error((CharSequence)("MavenInvocationException: " + e.getMessage()));
            }
            this.getLog().info((CharSequence)"Clirr is ignored.");
        }
        try {
            Collection<JavaClass> javaClasses = this.getQdoxClasses();
            if (javaClasses != null) {
                for (JavaClass javaClass : javaClasses) {
                    this.processFix(javaClass);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException: " + e.getMessage(), (Exception)e);
        }
    }

    protected final MavenProject getProject() {
        return this.project;
    }

    protected String getArtifactType(MavenProject p) {
        return p.getArtifact().getType();
    }

    protected List<String> getProjectSourceRoots(MavenProject p) {
        return p.getCompileSourceRoots() == null ? Collections.emptyList() : new LinkedList(p.getCompileSourceRoots());
    }

    protected List<String> getCompileClasspathElements(MavenProject p) throws DependencyResolutionRequiredException {
        return p.getCompileClasspathElements() == null ? Collections.emptyList() : new LinkedList(p.getCompileClasspathElements());
    }

    protected static String getJavaMethodAsString(JavaExecutable javaExecutable) {
        return javaExecutable.getDeclaringClass().getFullyQualifiedName() + "#" + javaExecutable.getCallSignature();
    }

    private void init() {
        int i;
        if (this.defaultAuthor == null || this.defaultAuthor.isEmpty()) {
            this.defaultAuthor = System.getProperty("user.name");
        }
        if ((i = this.defaultSince.indexOf("-SNAPSHOT")) != -1) {
            this.defaultSince = this.defaultSince.substring(0, i);
        }
        if (!FIX_TAGS_ALL.equalsIgnoreCase(this.fixTags.trim())) {
            String[] split = StringUtils.split((String)this.fixTags, (String)",");
            LinkedList<String> filtered = new LinkedList<String>();
            for (String aSplit : split) {
                String s = aSplit.trim();
                if (JavadocUtil.equalsIgnoreCase(s, FIX_TAGS_ALL, AUTHOR_TAG, VERSION_TAG, SINCE_TAG, PARAM_TAG, THROWS_TAG, LINK_TAG, RETURN_TAG)) {
                    filtered.add(s);
                    continue;
                }
                if (!this.getLog().isWarnEnabled()) continue;
                this.getLog().warn((CharSequence)("Unrecognized '" + s + "' for fixTags parameter. Ignored it!"));
            }
            this.fixTags = StringUtils.join(filtered.iterator(), (String)",");
        }
        this.fixTagsSplitted = StringUtils.split((String)this.fixTags, (String)",");
        if (this.encoding == null || this.encoding.isEmpty()) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!"));
            }
            this.encoding = ReaderFactory.FILE_ENCODING;
        }
        this.level = this.level.trim();
        if (!JavadocUtil.equalsIgnoreCase(this.level, LEVEL_PUBLIC, LEVEL_PROTECTED, LEVEL_PACKAGE, LEVEL_PRIVATE)) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Unrecognized '" + this.level + "' for level parameter, using 'protected' level."));
            }
            this.level = LEVEL_PROTECTED;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean preCheck() throws MojoExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File getProjectSourceDirectory() {
        return new File(this.project.getBuild().getSourceDirectory());
    }

    private void executeClirr() throws MavenInvocationException {
        if (this.ignoreClirr) {
            this.getLog().info((CharSequence)"Clirr is ignored.");
            return;
        }
        String clirrGoal = AbstractFixJavadocMojo.getFullClirrGoal();
        File clirrTextOutputFile = FileUtils.createTempFile((String)"clirr", (String)".txt", (File)new File(this.project.getBuild().getDirectory()));
        Properties properties = new Properties();
        properties.put("textOutputFile", clirrTextOutputFile.getAbsolutePath());
        properties.put("comparisonVersion", this.comparisonVersion);
        properties.put("failOnError", "false");
        if (JavaVersion.JAVA_SPECIFICATION_VERSION.isBefore("8")) {
            properties.put("https.protocols", "TLSv1.2");
        }
        File invokerDir = new File(this.project.getBuild().getDirectory(), "invoker");
        invokerDir.mkdirs();
        File invokerLogFile = FileUtils.createTempFile((String)CLIRR_MAVEN_PLUGIN_ARTIFACTID, (String)".txt", (File)invokerDir);
        JavadocUtil.invokeMaven(this.getLog(), this.session.getRepositorySession().getLocalRepository().getBasedir(), this.project.getFile(), Collections.singletonList(clirrGoal), properties, invokerLogFile, this.session.getRequest().getGlobalSettingsFile());
        try {
            if (invokerLogFile.exists()) {
                String invokerLogContent = StringUtils.unifyLineSeparators((String)FileUtils.fileRead((File)invokerLogFile, (String)"UTF-8"));
                String artifactNotFoundMsg = "Unable to find a previous version of the project in the repository";
                if (invokerLogContent.contains("Unable to find a previous version of the project in the repository")) {
                    this.getLog().warn((CharSequence)"No previous artifact has been deployed, Clirr is ignored.");
                    return;
                }
            }
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("IOException: " + e.getMessage()));
        }
        try {
            this.parseClirrTextOutputFile(clirrTextOutputFile);
        }
        catch (IOException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("IOException: " + e.getMessage()), (Throwable)e);
            }
            this.getLog().info((CharSequence)("IOException when parsing Clirr output '" + clirrTextOutputFile.getAbsolutePath() + "', Clirr is ignored."));
        }
    }

    private void parseClirrTextOutputFile(File clirrTextOutputFile) throws IOException {
        if (!clirrTextOutputFile.exists()) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("No Clirr output file '" + clirrTextOutputFile.getAbsolutePath() + "' exists, Clirr is ignored."));
            }
            return;
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Clirr output file was created: " + clirrTextOutputFile.getAbsolutePath()));
        }
        this.clirrNewClasses = new LinkedList<String>();
        this.clirrNewMethods = new LinkedHashMap<String, List<String>>();
        try (BufferedReader reader = new BufferedReader(ReaderFactory.newReader((File)clirrTextOutputFile, (String)"UTF-8"));){
            String line = reader.readLine();
            while (line != null) {
                block22: {
                    String[] split = StringUtils.split((String)line, (String)":");
                    if (split.length != 4) {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((CharSequence)("Unable to parse the clirr line: " + line));
                        }
                    } else {
                        int code;
                        try {
                            code = Integer.parseInt(split[1].trim());
                        }
                        catch (NumberFormatException e) {
                            if (this.getLog().isDebugEnabled()) {
                                this.getLog().debug((CharSequence)("Unable to parse the clirr line: " + line));
                            }
                            break block22;
                        }
                        switch (code) {
                            case 7011: {
                                this.methodAdded(split);
                                break;
                            }
                            case 7012: {
                                this.methodAdded(split);
                                break;
                            }
                            case 8000: {
                                this.clirrNewClasses.add(split[2].trim());
                                break;
                            }
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        if (this.clirrNewClasses.isEmpty() && this.clirrNewMethods.isEmpty()) {
            this.getLog().info((CharSequence)"Clirr NOT found API differences.");
        } else {
            this.getLog().info((CharSequence)"Clirr found API differences, i.e. new classes/interfaces or methods.");
        }
    }

    private void methodAdded(String[] split) {
        String[] splits2;
        List<String> list = this.clirrNewMethods.get(split[2].trim());
        if (list == null) {
            list = new ArrayList<String>();
        }
        if ((splits2 = StringUtils.split((String)split[3].trim(), (String)"'")).length != 3) {
            return;
        }
        list.add(splits2[1].trim());
        this.clirrNewMethods.put(split[2].trim(), list);
    }

    private boolean fixTag(String tag) {
        if (this.fixTagsSplitted.length == 1 && this.fixTagsSplitted[0].equals(FIX_TAGS_ALL)) {
            return true;
        }
        for (String aFixTagsSplitted : this.fixTagsSplitted) {
            if (!aFixTagsSplitted.trim().equals(tag)) continue;
            return true;
        }
        return false;
    }

    private Collection<JavaClass> getQdoxClasses() throws IOException, MojoExecutionException {
        if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
            this.getLog().warn((CharSequence)"This project has 'pom' packaging, no Java sources is available.");
            return null;
        }
        LinkedList javaFiles = new LinkedList();
        for (String sourceRoot : this.getProjectSourceRoots(this.project)) {
            File f = new File(sourceRoot);
            if (f.isDirectory()) {
                javaFiles.addAll(FileUtils.getFiles((File)f, (String)this.includes, (String)this.excludes, (boolean)true));
                continue;
            }
            if (!this.getLog().isWarnEnabled()) continue;
            this.getLog().warn((CharSequence)(f + " doesn't exist. Ignored it."));
        }
        OrderedClassLibraryBuilder classLibraryBuilder = new OrderedClassLibraryBuilder();
        classLibraryBuilder.appendClassLoader(this.getProjectClassLoader());
        JavaProjectBuilder builder = new JavaProjectBuilder((ClassLibraryBuilder)classLibraryBuilder);
        builder.setEncoding(this.encoding);
        for (File f : javaFiles) {
            if (!f.getAbsolutePath().toLowerCase(Locale.ENGLISH).endsWith(".java") && this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("'" + f + "' is not a Java file. Ignored it."));
                continue;
            }
            try {
                builder.addSource(f);
            }
            catch (ParseException e) {
                if (!this.getLog().isWarnEnabled()) continue;
                this.getLog().warn((CharSequence)("QDOX ParseException: " + e.getMessage() + ". Can't fix it."));
            }
        }
        return builder.getClasses();
    }

    private ClassLoader getProjectClassLoader() throws MojoExecutionException {
        if (this.projectClassLoader == null) {
            List<String> classPath;
            try {
                classPath = this.getCompileClasspathElements(this.project);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("DependencyResolutionRequiredException: " + e.getMessage(), (Exception)((Object)e));
            }
            ArrayList<URL> urls = new ArrayList<URL>(classPath.size());
            for (String filename : classPath) {
                try {
                    urls.add(new File(filename).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("MalformedURLException: " + e.getMessage(), (Exception)e);
                }
            }
            this.projectClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        }
        return this.projectClassLoader;
    }

    private void processFix(JavaClass javaClass) throws IOException, MojoExecutionException {
        File javaFile;
        if (javaClass.isInner()) {
            return;
        }
        try {
            javaFile = Paths.get(javaClass.getSource().getURL().toURI()).toFile();
        }
        catch (URISyntaxException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        String originalContent = StringUtils.unifyLineSeparators((String)FileUtils.fileRead((File)javaFile, (String)this.encoding));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Analyzing " + javaClass.getFullyQualifiedName()));
        }
        StringWriter stringWriter = new StringWriter();
        boolean changeDetected = false;
        try (BufferedReader reader = new BufferedReader(new StringReader(originalContent));){
            int lineNumber = 0;
            String line = reader.readLine();
            while (line != null) {
                ++lineNumber;
                String indent = AbstractFixJavadocMojo.autodetectIndentation(line);
                if (javaClass.getComment() == null && javaClass.getAnnotations() != null && !javaClass.getAnnotations().isEmpty()) {
                    if (lineNumber == ((JavaAnnotation)javaClass.getAnnotations().get(0)).getLineNumber()) {
                        changeDetected |= this.fixClassComment(stringWriter, originalContent, javaClass, indent);
                        this.takeCareSingleComment(stringWriter, originalContent, (JavaAnnotatedElement)javaClass);
                    }
                } else if (lineNumber == javaClass.getLineNumber()) {
                    changeDetected |= this.fixClassComment(stringWriter, originalContent, javaClass, indent);
                    this.takeCareSingleComment(stringWriter, originalContent, (JavaAnnotatedElement)javaClass);
                }
                if (javaClass.getFields() != null) {
                    for (JavaField field : javaClass.getFields()) {
                        if (lineNumber != field.getLineNumber()) continue;
                        changeDetected |= this.fixFieldComment(stringWriter, javaClass, field, indent);
                    }
                }
                if (javaClass.getConstructors() != null) {
                    for (JavaConstructor method : javaClass.getConstructors()) {
                        if (lineNumber != method.getLineNumber()) continue;
                        boolean commentUpdated = this.fixMethodComment(stringWriter, originalContent, (JavaExecutable)method, indent);
                        if (commentUpdated) {
                            this.takeCareSingleComment(stringWriter, originalContent, (JavaAnnotatedElement)method);
                        }
                        changeDetected |= commentUpdated;
                    }
                }
                for (JavaConstructor method : javaClass.getMethods()) {
                    int methodLineNumber = method.getComment() == null && !method.getAnnotations().isEmpty() ? ((JavaAnnotation)method.getAnnotations().get(0)).getLineNumber() : method.getLineNumber();
                    if (lineNumber != methodLineNumber) continue;
                    boolean commentUpdated = this.fixMethodComment(stringWriter, originalContent, (JavaExecutable)method, indent);
                    if (commentUpdated) {
                        this.takeCareSingleComment(stringWriter, originalContent, (JavaAnnotatedElement)method);
                    }
                    changeDetected |= commentUpdated;
                }
                stringWriter.write(line);
                stringWriter.write(EOL);
                line = reader.readLine();
            }
        }
        if (changeDetected) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)("Saving changes to " + javaClass.getFullyQualifiedName()));
            }
            if (this.outputDirectory != null && !this.outputDirectory.getAbsolutePath().equals(this.getProjectSourceDirectory().getAbsolutePath())) {
                String path = StringUtils.replace((String)javaFile.getAbsolutePath().replaceAll("\\\\", "/"), (String)this.project.getBuild().getSourceDirectory().replaceAll("\\\\", "/"), (String)"");
                javaFile = new File(this.outputDirectory, path);
                javaFile.getParentFile().mkdirs();
            }
            AbstractFixJavadocMojo.writeFile(javaFile, this.encoding, stringWriter.toString());
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("No changes made to " + javaClass.getFullyQualifiedName()));
        }
    }

    private void takeCareSingleComment(StringWriter stringWriter, String originalContent, JavaAnnotatedElement entity) throws IOException {
        if (entity.getComment() == null) {
            return;
        }
        String javadocComment = AbstractFixJavadocMojo.trimRight(AbstractFixJavadocMojo.extractOriginalJavadoc(originalContent, entity));
        String extraComment = javadocComment.substring(javadocComment.indexOf(END_JAVADOC) + END_JAVADOC.length());
        if (extraComment != null && !extraComment.isEmpty()) {
            if (extraComment.contains(EOL)) {
                stringWriter.write(extraComment.substring(extraComment.indexOf(EOL) + EOL.length()));
            } else {
                stringWriter.write(extraComment);
            }
            stringWriter.write(EOL);
        }
    }

    private boolean fixClassComment(StringWriter stringWriter, String originalContent, JavaClass javaClass, String indent) throws MojoExecutionException, IOException {
        if (!this.fixClassComment) {
            return false;
        }
        if (!this.isInLevel(javaClass.getModifiers())) {
            return false;
        }
        if (javaClass.getComment() == null) {
            this.addDefaultClassComment(stringWriter, javaClass, indent);
            return true;
        }
        return this.updateEntityComment(stringWriter, originalContent, (JavaAnnotatedElement)javaClass, indent);
    }

    private boolean isInLevel(List<String> modifiers) {
        if (LEVEL_PUBLIC.equalsIgnoreCase(this.level.trim())) {
            return modifiers.contains(LEVEL_PUBLIC);
        }
        if (LEVEL_PROTECTED.equalsIgnoreCase(this.level.trim())) {
            return modifiers.contains(LEVEL_PUBLIC) || modifiers.contains(LEVEL_PROTECTED);
        }
        if (LEVEL_PACKAGE.equalsIgnoreCase(this.level.trim())) {
            return !modifiers.contains(LEVEL_PRIVATE);
        }
        return true;
    }

    private void addDefaultClassComment(StringWriter stringWriter, JavaClass javaClass, String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append(START_JAVADOC);
        sb.append(EOL);
        sb.append(indent).append(SEPARATOR_JAVADOC);
        sb.append(AbstractFixJavadocMojo.getDefaultClassJavadocComment(javaClass));
        sb.append(EOL);
        this.appendSeparator(sb, indent);
        this.appendDefaultAuthorTag(sb, indent);
        this.appendDefaultVersionTag(sb, indent);
        if (this.fixTag(SINCE_TAG)) {
            if (!this.ignoreClirr) {
                if (this.isNewClassFromLastVersion(javaClass)) {
                    this.appendDefaultSinceTag(sb, indent);
                }
            } else {
                this.appendDefaultSinceTag(sb, indent);
                this.addSinceClasses(javaClass);
            }
        }
        sb.append(indent).append(" ").append(END_JAVADOC);
        sb.append(EOL);
        stringWriter.write(sb.toString());
    }

    private boolean fixFieldComment(StringWriter stringWriter, JavaClass javaClass, JavaField field, String indent) throws IOException {
        if (!this.fixFieldComment) {
            return false;
        }
        if (!(javaClass.isInterface() || this.isInLevel(field.getModifiers()) && field.isStatic())) {
            return false;
        }
        if (field.getComment() == null) {
            this.addDefaultFieldComment(stringWriter, field, indent);
            return true;
        }
        return false;
    }

    private void addDefaultFieldComment(StringWriter stringWriter, JavaField field, String indent) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(indent).append(START_JAVADOC).append(" ");
        sb.append("Constant <code>").append(field.getName());
        if (StringUtils.isNotEmpty((String)field.getInitializationExpression())) {
            String qualifiedName = field.getType().getFullyQualifiedName();
            if (qualifiedName.equals(Byte.TYPE.toString()) || qualifiedName.equals(Short.TYPE.toString()) || qualifiedName.equals(Integer.TYPE.toString()) || qualifiedName.equals(Long.TYPE.toString()) || qualifiedName.equals(Float.TYPE.toString()) || qualifiedName.equals(Double.TYPE.toString()) || qualifiedName.equals(Boolean.TYPE.toString()) || qualifiedName.equals(Character.TYPE.toString())) {
                sb.append("=");
                sb.append(StringEscapeUtils.escapeHtml4((String)field.getInitializationExpression().trim()));
            }
            if (qualifiedName.equals(String.class.getName())) {
                String[] lines;
                StringBuilder value = new StringBuilder();
                for (String line : lines = AbstractFixJavadocMojo.getLines(field.getInitializationExpression())) {
                    StringTokenizer token = new StringTokenizer(line.trim(), "\"\n\r");
                    while (token.hasMoreTokens()) {
                        String s = token.nextToken();
                        if (s.trim().equals("+")) continue;
                        if (s.trim().endsWith("\\")) {
                            s = s + "\"";
                        }
                        value.append(s);
                    }
                }
                sb.append("=\"");
                String escapedValue = StringEscapeUtils.escapeHtml4((String)value.toString());
                if (escapedValue.length() < 40) {
                    sb.append(escapedValue).append("\"");
                } else {
                    sb.append(escapedValue, 0, 39).append("\"{trunked}");
                }
            }
        }
        sb.append("</code> ").append(END_JAVADOC);
        sb.append(EOL);
        stringWriter.write(sb.toString());
    }

    private boolean fixMethodComment(StringWriter stringWriter, String originalContent, JavaExecutable javaExecutable, String indent) throws MojoExecutionException, IOException {
        if (!this.fixMethodComment) {
            return false;
        }
        if (!javaExecutable.getDeclaringClass().isInterface() && !this.isInLevel(javaExecutable.getModifiers())) {
            return false;
        }
        if (javaExecutable.getComment() == null) {
            this.addDefaultMethodComment(stringWriter, javaExecutable, indent);
            return true;
        }
        return this.updateEntityComment(stringWriter, originalContent, (JavaAnnotatedElement)javaExecutable, indent);
    }

    private void addDefaultMethodComment(StringWriter stringWriter, JavaExecutable javaExecutable, String indent) throws MojoExecutionException {
        StringBuilder sb = new StringBuilder();
        if (this.isInherited(javaExecutable)) {
            sb.append(indent).append(INHERITED_JAVADOC);
            sb.append(EOL);
            stringWriter.write(sb.toString());
            return;
        }
        sb.append(indent).append(START_JAVADOC);
        sb.append(EOL);
        sb.append(indent).append(SEPARATOR_JAVADOC);
        sb.append(AbstractFixJavadocMojo.getDefaultMethodJavadocComment(javaExecutable));
        sb.append(EOL);
        boolean separatorAdded = false;
        if (this.fixTag(PARAM_TAG)) {
            if (javaExecutable.getParameters() != null) {
                for (JavaParameter javaParameter : javaExecutable.getParameters()) {
                    separatorAdded = this.appendDefaultParamTag(sb, indent, separatorAdded, javaParameter);
                }
            }
            if (javaExecutable.getTypeParameters() != null) {
                for (JavaTypeVariable typeParam : javaExecutable.getTypeParameters()) {
                    separatorAdded = this.appendDefaultParamTag(sb, indent, separatorAdded, (JavaTypeVariable<JavaGenericDeclaration>)typeParam);
                }
            }
        }
        if (javaExecutable instanceof JavaMethod) {
            JavaMethod javaMethod = (JavaMethod)javaExecutable;
            if (this.fixTag(RETURN_TAG) && javaMethod.getReturns() != null && !javaMethod.getReturns().isVoid()) {
                separatorAdded = this.appendDefaultReturnTag(sb, indent, separatorAdded, javaMethod);
            }
        }
        if (this.fixTag(THROWS_TAG) && javaExecutable.getExceptions() != null) {
            for (JavaType exception : javaExecutable.getExceptions()) {
                separatorAdded = this.appendDefaultThrowsTag(sb, indent, separatorAdded, exception);
            }
        }
        if (this.fixTag(SINCE_TAG) && this.isNewMethodFromLastRevision(javaExecutable)) {
            separatorAdded = this.appendDefaultSinceTag(sb, indent, separatorAdded);
        }
        sb.append(indent).append(" ").append(END_JAVADOC);
        sb.append(EOL);
        stringWriter.write(sb.toString());
    }

    private boolean updateEntityComment(StringWriter stringWriter, String originalContent, JavaAnnotatedElement entity, String indent) throws MojoExecutionException, IOException {
        boolean changeDetected = false;
        String old = null;
        String s = stringWriter.toString();
        int i = s.lastIndexOf(START_JAVADOC);
        if (i != -1) {
            String tmp = s.substring(0, i);
            if (tmp.lastIndexOf(EOL) != -1) {
                tmp = tmp.substring(0, tmp.lastIndexOf(EOL));
            }
            old = stringWriter.getBuffer().substring(i);
            stringWriter.getBuffer().delete(0, stringWriter.getBuffer().length());
            stringWriter.write(tmp);
            stringWriter.write(EOL);
        } else {
            changeDetected = true;
        }
        this.updateJavadocComment(stringWriter, originalContent, entity, indent);
        if (changeDetected) {
            return true;
        }
        return !stringWriter.getBuffer().substring(i).equals(old);
    }

    private void updateJavadocComment(StringWriter stringWriter, String originalContent, JavaAnnotatedElement entity, String indent) throws MojoExecutionException, IOException {
        JavaExecutable javaMethod;
        if (entity.getComment() == null && (entity.getTags() == null || entity.getTags().isEmpty())) {
            return;
        }
        boolean isJavaExecutable = entity instanceof JavaExecutable;
        StringBuilder sb = new StringBuilder();
        if (isJavaExecutable && this.isInherited(javaMethod = (JavaExecutable)entity)) {
            if (StringUtils.isEmpty((String)javaMethod.getComment())) {
                sb.append(indent).append(INHERITED_JAVADOC);
                sb.append(EOL);
                stringWriter.write(sb.toString());
                return;
            }
            String javadoc = AbstractFixJavadocMojo.getJavadocComment(originalContent, (JavaAnnotatedElement)javaMethod);
            if (AbstractFixJavadocMojo.hasInheritedTag(javadoc) && (javaMethod.getTags() == null || javaMethod.getTags().isEmpty())) {
                sb.append(indent).append(INHERITED_JAVADOC);
                sb.append(EOL);
                stringWriter.write(sb.toString());
                return;
            }
            if (javadoc.contains(START_JAVADOC)) {
                javadoc = javadoc.substring(javadoc.indexOf(START_JAVADOC) + START_JAVADOC.length());
            }
            if (javadoc.contains(END_JAVADOC)) {
                javadoc = javadoc.substring(0, javadoc.indexOf(END_JAVADOC));
            }
            sb.append(indent).append(START_JAVADOC);
            sb.append(EOL);
            if (!javadoc.contains(INHERITED_TAG)) {
                sb.append(indent).append(SEPARATOR_JAVADOC).append(INHERITED_TAG);
                sb.append(EOL);
                this.appendSeparator(sb, indent);
            }
            javadoc = AbstractFixJavadocMojo.removeLastEmptyJavadocLines(javadoc);
            javadoc = AbstractFixJavadocMojo.alignIndentationJavadocLines(javadoc, indent);
            sb.append(javadoc);
            sb.append(EOL);
            if (javaMethod.getTags() != null) {
                for (DocletTag docletTag : javaMethod.getTags()) {
                    if (JavadocUtil.equals(docletTag.getName(), PARAM_TAG, RETURN_TAG, THROWS_TAG)) continue;
                    String s = this.getJavadocComment(originalContent, entity, docletTag);
                    s = AbstractFixJavadocMojo.removeLastEmptyJavadocLines(s);
                    s = AbstractFixJavadocMojo.alignIndentationJavadocLines(s, indent);
                    sb.append(s);
                    sb.append(EOL);
                }
            }
            sb.append(indent).append(" ").append(END_JAVADOC);
            sb.append(EOL);
            if (AbstractFixJavadocMojo.hasInheritedTag(sb.toString().trim())) {
                sb = new StringBuilder();
                sb.append(indent).append(INHERITED_JAVADOC);
                sb.append(EOL);
                stringWriter.write(sb.toString());
                return;
            }
            stringWriter.write(sb.toString());
            return;
        }
        sb.append(indent).append(START_JAVADOC);
        sb.append(EOL);
        if (StringUtils.isNotEmpty((String)entity.getComment())) {
            this.updateJavadocComment(sb, originalContent, entity, indent);
        } else {
            this.addDefaultJavadocComment(sb, entity, indent, isJavaExecutable);
        }
        this.updateJavadocTags(sb, originalContent, entity, indent, isJavaExecutable);
        sb = new StringBuilder(AbstractFixJavadocMojo.removeLastEmptyJavadocLines(sb.toString())).append(EOL);
        sb.append(indent).append(" ").append(END_JAVADOC);
        sb.append(EOL);
        stringWriter.write(sb.toString());
    }

    private void updateJavadocComment(StringBuilder sb, String originalContent, JavaAnnotatedElement entity, String indent) throws IOException {
        String[] lines;
        String comment = AbstractFixJavadocMojo.getJavadocComment(originalContent, entity);
        comment = AbstractFixJavadocMojo.removeLastEmptyJavadocLines(comment);
        if ((comment = AbstractFixJavadocMojo.alignIndentationJavadocLines(comment, indent)).contains(START_JAVADOC)) {
            comment = comment.substring(comment.indexOf(START_JAVADOC) + START_JAVADOC.length());
            comment = indent + SEPARATOR_JAVADOC + comment.trim();
        }
        if (comment.contains(END_JAVADOC)) {
            comment = comment.substring(0, comment.indexOf(END_JAVADOC));
        }
        if (this.fixTag(LINK_TAG)) {
            comment = AbstractFixJavadocMojo.replaceLinkTags(comment, entity);
        }
        for (String line : lines = AbstractFixJavadocMojo.getLines(comment)) {
            sb.append(indent).append(" ").append(line.trim());
            sb.append(EOL);
        }
    }

    static String replaceLinkTags(String comment, JavaAnnotatedElement entity) {
        StringBuilder resolvedComment = new StringBuilder();
        Matcher linktagMatcher = REPLACE_LINK_TAGS_PATTERN.matcher(comment);
        int startIndex = 0;
        while (linktagMatcher.find()) {
            int startName = linktagMatcher.end();
            resolvedComment.append(comment, startIndex, startName);
            int endName = comment.indexOf("}", startName);
            if (endName >= 0) {
                String link = comment.substring(startName, endName);
                int hashIndex = link.indexOf(35);
                String name = hashIndex >= 0 ? link.substring(0, hashIndex) : link;
                if (StringUtils.isNotBlank((String)name)) {
                    String typeName;
                    JavaClass clazz;
                    if (entity instanceof JavaClass) {
                        clazz = (JavaClass)entity;
                        typeName = TypeResolver.byClassName((String)clazz.getBinaryName(), (ClassLibrary)clazz.getJavaClassLibrary(), (Collection)clazz.getSource().getImports()).resolveType(name.trim());
                    } else if (entity instanceof JavaMember) {
                        clazz = ((JavaMember)entity).getDeclaringClass();
                        typeName = TypeResolver.byClassName((String)clazz.getBinaryName(), (ClassLibrary)clazz.getJavaClassLibrary(), (Collection)clazz.getSource().getImports()).resolveType(name.trim());
                    } else {
                        typeName = null;
                    }
                    typeName = typeName == null ? name.trim() : typeName.replaceAll("\\$", ".");
                    resolvedComment.append(typeName);
                }
                if (hashIndex >= 0) {
                    resolvedComment.append(link.substring(hashIndex).trim());
                }
                startIndex = endName;
                continue;
            }
            startIndex = startName;
        }
        resolvedComment.append(comment.substring(startIndex));
        return resolvedComment.toString();
    }

    private void addDefaultJavadocComment(StringBuilder sb, JavaAnnotatedElement entity, String indent, boolean isJavaExecutable) {
        sb.append(indent).append(SEPARATOR_JAVADOC);
        if (isJavaExecutable) {
            sb.append(AbstractFixJavadocMojo.getDefaultMethodJavadocComment((JavaExecutable)entity));
        } else {
            sb.append(AbstractFixJavadocMojo.getDefaultClassJavadocComment((JavaClass)entity));
        }
        sb.append(EOL);
    }

    private void updateJavadocTags(StringBuilder sb, String originalContent, JavaAnnotatedElement entity, String indent, boolean isJavaExecutable) throws IOException, MojoExecutionException {
        this.appendSeparator(sb, indent);
        JavaEntityTags javaEntityTags = this.parseJavadocTags(originalContent, entity, indent, isJavaExecutable);
        this.updateJavadocTags(sb, entity, isJavaExecutable, javaEntityTags);
        this.addMissingJavadocTags(sb, entity, indent, isJavaExecutable, javaEntityTags);
    }

    JavaEntityTags parseJavadocTags(String originalContent, JavaAnnotatedElement entity, String indent, boolean isJavaMethod) throws IOException {
        JavaEntityTags javaEntityTags = new JavaEntityTags(entity, isJavaMethod);
        for (DocletTag docletTag : entity.getTags()) {
            String originalJavadocTag = this.getJavadocComment(originalContent, entity, docletTag);
            originalJavadocTag = AbstractFixJavadocMojo.removeLastEmptyJavadocLines(originalJavadocTag);
            originalJavadocTag = AbstractFixJavadocMojo.alignIndentationJavadocLines(originalJavadocTag, indent);
            javaEntityTags.getNamesTags().add(docletTag.getName());
            if (isJavaMethod) {
                List params = docletTag.getParameters();
                if (params.size() < 1) continue;
                String paramName = (String)params.get(0);
                switch (docletTag.getName()) {
                    case "param": {
                        javaEntityTags.putJavadocParamTag(paramName, docletTag.getValue(), originalJavadocTag);
                        break;
                    }
                    case "return": {
                        javaEntityTags.setJavadocReturnTag(originalJavadocTag);
                        break;
                    }
                    case "throws": {
                        javaEntityTags.putJavadocThrowsTag(paramName, originalJavadocTag);
                        break;
                    }
                    default: {
                        javaEntityTags.getUnknownTags().add(originalJavadocTag);
                        break;
                    }
                }
                continue;
            }
            javaEntityTags.getUnknownTags().add(originalJavadocTag);
        }
        return javaEntityTags;
    }

    private void updateJavadocTags(StringBuilder sb, JavaAnnotatedElement entity, boolean isJavaExecutable, JavaEntityTags javaEntityTags) {
        for (DocletTag docletTag : entity.getTags()) {
            if (isJavaExecutable) {
                JavaExecutable javaExecutable = (JavaExecutable)entity;
                List params = docletTag.getParameters();
                if (params.size() < 1) continue;
                if (docletTag.getName().equals(PARAM_TAG)) {
                    this.writeParamTag(sb, javaExecutable, javaEntityTags, (String)params.get(0), docletTag.getValue());
                } else if (docletTag.getName().equals(RETURN_TAG) && javaExecutable instanceof JavaMethod) {
                    this.writeReturnTag(sb, (JavaMethod)javaExecutable, javaEntityTags);
                } else if (docletTag.getName().equals(THROWS_TAG)) {
                    this.writeThrowsTag(sb, javaExecutable, javaEntityTags, params);
                } else {
                    Iterator<String> it = javaEntityTags.getUnknownTags().iterator();
                    while (it.hasNext()) {
                        String originalJavadocTag = it.next();
                        String simplified = StringUtils.removeDuplicateWhitespace((String)originalJavadocTag).trim();
                        if (!simplified.contains("@" + docletTag.getName())) continue;
                        it.remove();
                        sb.append(originalJavadocTag);
                        sb.append(EOL);
                    }
                }
            } else {
                Iterator<String> it = javaEntityTags.getUnknownTags().iterator();
                while (it.hasNext()) {
                    String originalJavadocTag = it.next();
                    String simplified = StringUtils.removeDuplicateWhitespace((String)originalJavadocTag).trim();
                    if (!simplified.contains("@" + docletTag.getName())) continue;
                    it.remove();
                    sb.append(originalJavadocTag);
                    sb.append(EOL);
                }
            }
            if (sb.toString().endsWith(EOL)) {
                sb.delete(sb.toString().lastIndexOf(EOL), sb.toString().length());
            }
            sb.append(EOL);
        }
    }

    private void writeParamTag(StringBuilder sb, JavaExecutable javaExecutable, JavaEntityTags javaEntityTags, String paramName, String paramValue) {
        if (!this.fixTag(PARAM_TAG)) {
            String originalJavadocTag = javaEntityTags.getJavadocParamTag(paramValue);
            if (originalJavadocTag != null) {
                sb.append(originalJavadocTag);
            }
            return;
        }
        boolean found = false;
        JavaParameter javaParam = javaExecutable.getParameterByName(paramName);
        if (javaParam == null) {
            List typeParams = javaExecutable.getTypeParameters();
            for (JavaTypeVariable typeParam : typeParams) {
                if (!("<" + typeParam.getName() + ">").equals(paramName)) continue;
                found = true;
            }
        } else {
            found = true;
        }
        if (!found) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn((CharSequence)("Fixed unknown param '" + paramName + "' defined in " + AbstractFixJavadocMojo.getJavaMethodAsString(javaExecutable)));
            }
            if (sb.toString().endsWith(EOL)) {
                sb.delete(sb.toString().lastIndexOf(EOL), sb.toString().length());
            }
        } else {
            String originalJavadocTag = javaEntityTags.getJavadocParamTag(paramValue);
            if (originalJavadocTag != null) {
                sb.append(originalJavadocTag);
                String s = "@param " + paramName;
                if (StringUtils.removeDuplicateWhitespace((String)originalJavadocTag).trim().endsWith(s)) {
                    sb.append(" ");
                    sb.append(this.getDefaultJavadocForType(javaParam.getJavaClass()));
                }
            }
        }
    }

    private void writeReturnTag(StringBuilder sb, JavaMethod javaMethod, JavaEntityTags javaEntityTags) {
        String originalJavadocTag = javaEntityTags.getJavadocReturnTag();
        if (originalJavadocTag == null) {
            return;
        }
        if (!this.fixTag(RETURN_TAG)) {
            sb.append(originalJavadocTag);
            return;
        }
        if (originalJavadocTag != null && !originalJavadocTag.isEmpty() && javaMethod.getReturns() != null && !javaMethod.getReturns().isVoid()) {
            sb.append(originalJavadocTag);
            if (originalJavadocTag.trim().endsWith("@return")) {
                sb.append(" ");
                sb.append(this.getDefaultJavadocForType(javaMethod.getReturns()));
            }
        }
    }

    void writeThrowsTag(StringBuilder sb, JavaExecutable javaExecutable, JavaEntityTags javaEntityTags, List<String> params) {
        Class<?> clazz;
        String exceptionClassName = params.get(0);
        String originalJavadocTag = javaEntityTags.getJavadocThrowsTag(exceptionClassName);
        if (originalJavadocTag == null) {
            return;
        }
        if (!this.fixTag(THROWS_TAG)) {
            sb.append(originalJavadocTag);
            return;
        }
        if (javaExecutable.getExceptions() != null) {
            for (JavaType exception : javaExecutable.getExceptions()) {
                if (!exception.getFullyQualifiedName().endsWith(exceptionClassName)) continue;
                if (StringUtils.removeDuplicateWhitespace((String)(originalJavadocTag = StringUtils.replace((String)originalJavadocTag, (String)exceptionClassName, (String)exception.getFullyQualifiedName()))).trim().endsWith("@throws " + exception.getValue())) {
                    originalJavadocTag = originalJavadocTag + " if any.";
                }
                sb.append(originalJavadocTag);
                javaEntityTags.putJavadocThrowsTag(exception.getValue(), originalJavadocTag);
                return;
            }
        }
        if ((clazz = this.getClass(javaExecutable.getDeclaringClass(), exceptionClassName)) != null) {
            if (RuntimeException.class.isAssignableFrom(clazz)) {
                sb.append(StringUtils.replace((String)originalJavadocTag, (String)exceptionClassName, (String)clazz.getName()));
                javaEntityTags.putJavadocThrowsTag(clazz.getName(), originalJavadocTag);
            } else if (Throwable.class.isAssignableFrom(clazz)) {
                this.getLog().debug((CharSequence)("Removing '" + originalJavadocTag + "'; Throwable not specified by " + AbstractFixJavadocMojo.getJavaMethodAsString(javaExecutable) + " and it is not a RuntimeException."));
            } else {
                this.getLog().debug((CharSequence)("Removing '" + originalJavadocTag + "'; It is not a Throwable"));
            }
        } else if (this.removeUnknownThrows) {
            this.getLog().warn((CharSequence)("Ignoring unknown throws '" + exceptionClassName + "' defined on " + AbstractFixJavadocMojo.getJavaMethodAsString(javaExecutable)));
        } else {
            this.getLog().warn((CharSequence)("Found unknown throws '" + exceptionClassName + "' defined on " + AbstractFixJavadocMojo.getJavaMethodAsString(javaExecutable)));
            sb.append(originalJavadocTag);
            if (params.size() == 1) {
                sb.append(" if any.");
            }
            javaEntityTags.putJavadocThrowsTag(exceptionClassName, originalJavadocTag);
        }
    }

    private void addMissingJavadocTags(StringBuilder sb, JavaAnnotatedElement entity, String indent, boolean isJavaExecutable, JavaEntityTags javaEntityTags) throws MojoExecutionException {
        if (isJavaExecutable) {
            JavaExecutable javaExecutable = (JavaExecutable)entity;
            if (this.fixTag(PARAM_TAG)) {
                if (javaExecutable.getParameters() != null) {
                    for (JavaParameter javaParameter : javaExecutable.getParameters()) {
                        if (javaEntityTags.hasJavadocParamTag(javaParameter.getName())) continue;
                        this.appendDefaultParamTag(sb, indent, javaParameter);
                    }
                }
                if (javaExecutable.getTypeParameters() != null) {
                    for (JavaTypeVariable typeParam : javaExecutable.getTypeParameters()) {
                        if (javaEntityTags.hasJavadocParamTag("<" + typeParam.getName() + ">")) continue;
                        this.appendDefaultParamTag(sb, indent, (JavaTypeVariable<JavaGenericDeclaration>)typeParam);
                    }
                }
            }
            if (javaExecutable instanceof JavaMethod) {
                JavaMethod javaMethod = (JavaMethod)javaExecutable;
                if (this.fixTag(RETURN_TAG) && StringUtils.isEmpty((String)javaEntityTags.getJavadocReturnTag()) && javaMethod.getReturns() != null && !javaMethod.getReturns().isVoid()) {
                    this.appendDefaultReturnTag(sb, indent, javaMethod);
                }
            }
            if (this.fixTag(THROWS_TAG) && javaExecutable.getExceptions() != null) {
                for (JavaType exception : javaExecutable.getExceptions()) {
                    if (javaEntityTags.getJavadocThrowsTag(exception.getValue(), true) != null) continue;
                    this.appendDefaultThrowsTag(sb, indent, exception);
                }
            }
        } else {
            if (!javaEntityTags.getNamesTags().contains(AUTHOR_TAG)) {
                this.appendDefaultAuthorTag(sb, indent);
            }
            if (!javaEntityTags.getNamesTags().contains(VERSION_TAG)) {
                this.appendDefaultVersionTag(sb, indent);
            }
        }
        if (this.fixTag(SINCE_TAG) && !javaEntityTags.getNamesTags().contains(SINCE_TAG)) {
            if (!isJavaExecutable) {
                if (!this.ignoreClirr) {
                    if (this.isNewClassFromLastVersion((JavaClass)entity)) {
                        this.appendDefaultSinceTag(sb, indent);
                    }
                } else {
                    this.appendDefaultSinceTag(sb, indent);
                    this.addSinceClasses((JavaClass)entity);
                }
            } else if (!this.ignoreClirr) {
                if (this.isNewMethodFromLastRevision((JavaExecutable)entity)) {
                    this.appendDefaultSinceTag(sb, indent);
                }
            } else if (this.sinceClasses != null) {
                if (entity instanceof JavaMember && !this.sinceClassesContains(((JavaMember)entity).getDeclaringClass())) {
                    this.appendDefaultSinceTag(sb, indent);
                } else if (entity instanceof JavaClass && !this.sinceClassesContains(((JavaClass)entity).getDeclaringClass())) {
                    this.appendDefaultSinceTag(sb, indent);
                }
            }
        }
    }

    private void appendDefaultAuthorTag(StringBuilder sb, String indent) {
        if (!this.fixTag(AUTHOR_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(AUTHOR_TAG).append(" ");
        sb.append(this.defaultAuthor);
        sb.append(EOL);
    }

    private boolean appendDefaultSinceTag(StringBuilder sb, String indent, boolean separatorAdded) {
        if (!this.fixTag(SINCE_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultSinceTag(sb, indent);
        return separatorAdded;
    }

    private void appendDefaultSinceTag(StringBuilder sb, String indent) {
        if (!this.fixTag(SINCE_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(SINCE_TAG).append(" ");
        sb.append(this.defaultSince);
        sb.append(EOL);
    }

    private boolean appendDefaultVersionTag(StringBuilder sb, String indent, boolean separatorAdded) {
        if (!this.fixTag(VERSION_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultVersionTag(sb, indent);
        return separatorAdded;
    }

    private void appendDefaultVersionTag(StringBuilder sb, String indent) {
        if (!this.fixTag(VERSION_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(VERSION_TAG).append(" ");
        sb.append(this.defaultVersion);
        sb.append(EOL);
    }

    private boolean appendDefaultParamTag(StringBuilder sb, String indent, boolean separatorAdded, JavaParameter typeParam) {
        if (!this.fixTag(PARAM_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultParamTag(sb, indent, typeParam);
        return separatorAdded;
    }

    private boolean appendDefaultParamTag(StringBuilder sb, String indent, boolean separatorAdded, JavaTypeVariable<JavaGenericDeclaration> typeParameter) {
        if (!this.fixTag(PARAM_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultParamTag(sb, indent, typeParameter);
        return separatorAdded;
    }

    private void appendDefaultParamTag(StringBuilder sb, String indent, JavaParameter typeParam) {
        if (!this.fixTag(PARAM_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(PARAM_TAG).append(" ");
        sb.append(typeParam.getName());
        sb.append(" ");
        sb.append(this.getDefaultJavadocForType(typeParam.getJavaClass()));
        sb.append(EOL);
    }

    private void appendDefaultParamTag(StringBuilder sb, String indent, JavaTypeVariable<JavaGenericDeclaration> typeParameter) {
        if (!this.fixTag(PARAM_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(PARAM_TAG).append(" ");
        sb.append("<").append(typeParameter.getName()).append(">");
        sb.append(" ");
        sb.append(this.getDefaultJavadocForType(typeParameter));
        sb.append(EOL);
    }

    private boolean appendDefaultReturnTag(StringBuilder sb, String indent, boolean separatorAdded, JavaMethod javaMethod) {
        if (!this.fixTag(RETURN_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultReturnTag(sb, indent, javaMethod);
        return separatorAdded;
    }

    private void appendDefaultReturnTag(StringBuilder sb, String indent, JavaMethod javaMethod) {
        if (!this.fixTag(RETURN_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(RETURN_TAG).append(" ");
        sb.append(this.getDefaultJavadocForType(javaMethod.getReturns()));
        sb.append(EOL);
    }

    private boolean appendDefaultThrowsTag(StringBuilder sb, String indent, boolean separatorAdded, JavaType exception) {
        if (!this.fixTag(THROWS_TAG)) {
            return separatorAdded;
        }
        if (!separatorAdded) {
            this.appendSeparator(sb, indent);
            separatorAdded = true;
        }
        this.appendDefaultThrowsTag(sb, indent, exception);
        return separatorAdded;
    }

    private void appendDefaultThrowsTag(StringBuilder sb, String indent, JavaType exception) {
        if (!this.fixTag(THROWS_TAG)) {
            return;
        }
        sb.append(indent).append(" * @").append(THROWS_TAG).append(" ");
        sb.append(exception.getFullyQualifiedName());
        sb.append(" if any.");
        sb.append(EOL);
    }

    private void appendSeparator(StringBuilder sb, String indent) {
        sb.append(indent).append(" *");
        sb.append(EOL);
    }

    private boolean isInherited(JavaExecutable javaMethod) throws MojoExecutionException {
        if (javaMethod.getAnnotations() != null) {
            for (JavaAnnotation annotation : javaMethod.getAnnotations()) {
                if (!annotation.toString().equals("@java.lang.Override()")) continue;
                return true;
            }
        }
        Class<?> clazz = this.getClass(javaMethod.getDeclaringClass().getFullyQualifiedName());
        List interfaces = ClassUtils.getAllInterfaces(clazz);
        for (Class intface : interfaces) {
            if (!this.isInherited(intface, javaMethod)) continue;
            return true;
        }
        List classes = ClassUtils.getAllSuperclasses(clazz);
        for (Class superClass : classes) {
            if (!this.isInherited(superClass, javaMethod)) continue;
            return true;
        }
        return false;
    }

    private boolean isInherited(Class<?> clazz, JavaExecutable javaMethod) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(javaMethod.getName()) || method.getParameterTypes().length != javaMethod.getParameters().size()) continue;
            boolean found = false;
            int j = 0;
            for (Class<?> paramType : method.getParameterTypes()) {
                String name1 = paramType.getName();
                String name2 = ((JavaParameter)javaMethod.getParameters().get(j++)).getType().getFullyQualifiedName();
                found = name1.equals(name2);
            }
            return found;
        }
        return false;
    }

    private String getDefaultJavadocForType(JavaClass clazz) {
        StringBuilder sb = new StringBuilder();
        if (!JavaTypeVariable.class.isAssignableFrom(clazz.getClass()) && clazz.isPrimitive()) {
            if (clazz.isArray()) {
                sb.append("an array of ").append(clazz.getComponentType().getCanonicalName());
            } else {
                sb.append("a ").append(clazz.getCanonicalName());
            }
            return sb.toString();
        }
        StringBuilder javadocLink = new StringBuilder();
        try {
            this.getClass(clazz.getCanonicalName());
            javadocLink.append("{@link ");
            if (clazz.isArray()) {
                javadocLink.append(clazz.getComponentType().getCanonicalName());
            } else {
                javadocLink.append(clazz.getCanonicalName());
            }
            javadocLink.append("}");
        }
        catch (Exception e) {
            javadocLink.append(clazz.getValue());
        }
        if (clazz.isArray()) {
            sb.append("an array of ").append((CharSequence)javadocLink).append(" objects");
        } else {
            sb.append("a ").append((CharSequence)javadocLink).append(" object");
        }
        return sb.toString();
    }

    private String getDefaultJavadocForType(JavaTypeVariable<JavaGenericDeclaration> typeParameter) {
        return "a " + typeParameter.getName() + " class";
    }

    private boolean isNewClassFromLastVersion(JavaClass javaClass) {
        return this.clirrNewClasses != null && this.clirrNewClasses.contains(javaClass.getFullyQualifiedName());
    }

    private boolean isNewMethodFromLastRevision(JavaExecutable javaExecutable) throws MojoExecutionException {
        if (this.clirrNewMethods == null) {
            return false;
        }
        List<String> clirrMethods = this.clirrNewMethods.get(javaExecutable.getDeclaringClass().getFullyQualifiedName());
        if (clirrMethods == null) {
            return false;
        }
        for (String clirrMethod : clirrMethods) {
            String retrn = "";
            if (javaExecutable instanceof JavaMethod && ((JavaMethod)javaExecutable).getReturns() != null) {
                retrn = ((JavaMethod)javaExecutable).getReturns().getFullyQualifiedName();
            }
            StringBuilder params = new StringBuilder();
            for (JavaParameter parameter : javaExecutable.getParameters()) {
                if (params.length() > 0) {
                    params.append(", ");
                }
                params.append(parameter.getResolvedFullyQualifiedName());
            }
            if (!clirrMethod.contains(retrn + " ") || !clirrMethod.contains(javaExecutable.getName() + "(") || !clirrMethod.contains("(" + params.toString() + ")")) continue;
            return true;
        }
        return false;
    }

    private Class<?> getClass(String className) throws MojoExecutionException {
        try {
            return ClassUtils.getClass((ClassLoader)this.getProjectClassLoader(), (String)className, (boolean)false);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("ClassNotFoundException: " + e.getMessage(), (Exception)e);
        }
    }

    private Class<?> getClass(JavaClass currentClass, String exceptionClassName) {
        String[] potentialClassNames = new String[]{exceptionClassName, currentClass.getPackage().getName() + "." + exceptionClassName, currentClass.getPackage().getName() + "." + currentClass.getName() + "$" + exceptionClassName, "java.lang." + exceptionClassName};
        Class<?> clazz = null;
        for (String potentialClassName : potentialClassNames) {
            try {
                clazz = this.getClass(potentialClassName);
            }
            catch (MojoExecutionException mojoExecutionException) {
                // empty catch block
            }
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    private void addSinceClasses(JavaClass javaClass) {
        if (this.sinceClasses == null) {
            this.sinceClasses = new ArrayList<String>();
        }
        this.sinceClasses.add(javaClass.getFullyQualifiedName());
    }

    private boolean sinceClassesContains(JavaClass javaClass) {
        return this.sinceClasses.contains(javaClass.getFullyQualifiedName());
    }

    private static void writeFile(File javaFile, String encoding, String content) throws IOException {
        String unified = StringUtils.unifyLineSeparators((String)content);
        FileUtils.fileWrite((File)javaFile, (String)encoding, (String)unified);
    }

    private static String getFullClirrGoal() {
        StringBuilder sb = new StringBuilder();
        sb.append(CLIRR_MAVEN_PLUGIN_GROUPID).append(":").append(CLIRR_MAVEN_PLUGIN_ARTIFACTID).append(":");
        String clirrVersion = CLIRR_MAVEN_PLUGIN_VERSION;
        String resource = "META-INF/maven/org.codehaus.mojo/clirr-maven-plugin/pom.properties";
        try (InputStream resourceAsStream = AbstractFixJavadocMojo.class.getClassLoader().getResourceAsStream(resource);){
            if (resourceAsStream != null) {
                Properties properties = new Properties();
                properties.load(resourceAsStream);
                if (StringUtils.isNotEmpty((String)properties.getProperty(VERSION_TAG))) {
                    clirrVersion = properties.getProperty(VERSION_TAG);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sb.append(clirrVersion).append(":").append(CLIRR_MAVEN_PLUGIN_GOAL);
        return sb.toString();
    }

    private static String getDefaultClassJavadocComment(JavaClass javaClass) {
        StringBuilder sb = new StringBuilder();
        sb.append("<p>");
        if (javaClass.isAbstract()) {
            sb.append("Abstract ");
        }
        sb.append(javaClass.getName());
        if (!javaClass.isInterface()) {
            sb.append(" class.");
        } else {
            sb.append(" interface.");
        }
        sb.append("</p>");
        return sb.toString();
    }

    private static String getDefaultMethodJavadocComment(JavaExecutable javaExecutable) {
        if (javaExecutable instanceof JavaConstructor) {
            return "<p>Constructor for " + javaExecutable.getName() + ".</p>";
        }
        if (javaExecutable.getName().length() > 3 && (javaExecutable.getName().startsWith("get") || javaExecutable.getName().startsWith("set"))) {
            String field = StringUtils.lowercaseFirstLetter((String)javaExecutable.getName().substring(3));
            JavaClass clazz = javaExecutable.getDeclaringClass();
            if (clazz.getFieldByName(field) == null) {
                return "<p>" + javaExecutable.getName() + ".</p>";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<p>");
            if (javaExecutable.getName().startsWith("get")) {
                sb.append("Getter ");
            } else if (javaExecutable.getName().startsWith("set")) {
                sb.append("Setter ");
            }
            sb.append("for the field <code>").append(field).append("</code>.</p>");
            return sb.toString();
        }
        return "<p>" + javaExecutable.getName() + ".</p>";
    }

    private static boolean hasInheritedTag(String content) {
        String inheritedTagPattern = "^\\s*(\\/\\*\\*)?(\\s*(\\*)?)*(\\{)@inheritDoc\\s*(\\})(\\s*(\\*)?)*(\\*\\/)?$";
        return Pattern.matches("^\\s*(\\/\\*\\*)?(\\s*(\\*)?)*(\\{)@inheritDoc\\s*(\\})(\\s*(\\*)?)*(\\*\\/)?$", StringUtils.removeDuplicateWhitespace((String)content));
    }

    static String getJavadocComment(String javaClassContent, JavaAnnotatedElement entity) throws IOException {
        String l;
        String line;
        if (entity.getComment() == null) {
            return "";
        }
        String originalJavadoc = AbstractFixJavadocMojo.extractOriginalJavadocContent(javaClassContent, entity);
        StringBuilder sb = new StringBuilder();
        BufferedReader lr = new BufferedReader(new StringReader(originalJavadoc));
        while ((line = lr.readLine()) != null && !(l = StringUtils.removeDuplicateWhitespace((String)line.trim())).startsWith("* @") && !l.startsWith("*@")) {
            sb.append(line).append(EOL);
        }
        return AbstractFixJavadocMojo.trimRight(sb.toString());
    }

    String getJavadocComment(String javaClassContent, JavaAnnotatedElement entity, DocletTag docletTag) throws IOException {
        String line;
        if (docletTag.getValue() == null || docletTag.getParameters().isEmpty()) {
            return "";
        }
        String originalJavadoc = AbstractFixJavadocMojo.extractOriginalJavadocContent(javaClassContent, entity);
        StringBuilder sb = new StringBuilder();
        BufferedReader lr = new BufferedReader(new StringReader(originalJavadoc));
        boolean found = false;
        Pattern p = Pattern.compile("(\\s*\\*\\s?@" + docletTag.getName() + ")\\s+(\\Q" + docletTag.getValue().split("\r\n|\r|\n")[0] + "\\E)");
        while ((line = lr.readLine()) != null) {
            Matcher m = p.matcher(line);
            if (m.matches()) {
                if (this.fixTag(LINK_TAG)) {
                    line = AbstractFixJavadocMojo.replaceLinkTags(line, entity);
                }
                sb.append(line).append(EOL);
                found = true;
                continue;
            }
            if (line.trim().startsWith("* @") || line.trim().startsWith("*@")) {
                found = false;
            }
            if (!found) continue;
            if (this.fixTag(LINK_TAG)) {
                line = AbstractFixJavadocMojo.replaceLinkTags(line, entity);
            }
            sb.append(line).append(EOL);
        }
        return AbstractFixJavadocMojo.trimRight(sb.toString());
    }

    static String extractOriginalJavadoc(String javaClassContent, JavaAnnotatedElement entity) throws IOException {
        if (entity.getComment() == null) {
            return "";
        }
        String[] javaClassContentLines = AbstractFixJavadocMojo.getLines(javaClassContent);
        LinkedList<String> list = new LinkedList<String>();
        for (int i = entity.getLineNumber() - 2; i >= 0; --i) {
            String line = javaClassContentLines[i];
            list.add(AbstractFixJavadocMojo.trimRight(line));
            if (line.trim().startsWith(START_JAVADOC)) break;
        }
        Collections.reverse(list);
        return StringUtils.join(list.iterator(), (String)EOL);
    }

    static String extractOriginalJavadocContent(String javaClassContent, JavaAnnotatedElement entity) throws IOException {
        if (entity.getComment() == null) {
            return "";
        }
        String originalJavadoc = AbstractFixJavadocMojo.extractOriginalJavadoc(javaClassContent, entity);
        int index = originalJavadoc.indexOf(START_JAVADOC);
        if (index != -1) {
            originalJavadoc = originalJavadoc.substring(index + START_JAVADOC.length());
        }
        if ((index = originalJavadoc.indexOf(END_JAVADOC)) != -1) {
            originalJavadoc = originalJavadoc.substring(0, index);
        }
        if (originalJavadoc.startsWith("\r\n")) {
            originalJavadoc = originalJavadoc.substring(2);
        } else if (originalJavadoc.startsWith("\n") || originalJavadoc.startsWith("\r")) {
            originalJavadoc = originalJavadoc.substring(1);
        }
        return AbstractFixJavadocMojo.trimRight(originalJavadoc);
    }

    private static String removeLastEmptyJavadocLines(String content) throws IOException {
        String line;
        if (!content.contains(EOL)) {
            return content;
        }
        String[] lines = AbstractFixJavadocMojo.getLines(content);
        if (lines.length == 1) {
            return content;
        }
        LinkedList<String> linesList = new LinkedList<String>(Arrays.asList(lines));
        Collections.reverse(linesList);
        Iterator it = linesList.iterator();
        while (it.hasNext() && (line = (String)it.next()).trim().equals("*")) {
            it.remove();
        }
        Collections.reverse(linesList);
        return StringUtils.join(linesList.iterator(), (String)EOL);
    }

    private static String alignIndentationJavadocLines(String content, String indent) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String line : AbstractFixJavadocMojo.getLines(content)) {
            if (sb.length() > 0) {
                sb.append(EOL);
            }
            if (!line.trim().startsWith("*")) {
                line = "*" + line;
            }
            sb.append(indent).append(" ").append(AbstractFixJavadocMojo.trimLeft(line));
        }
        return sb.toString();
    }

    private static String autodetectIndentation(String line) {
        if (line == null || line.isEmpty()) {
            return "";
        }
        return line.substring(0, line.indexOf(AbstractFixJavadocMojo.trimLeft(line)));
    }

    private static String[] getLines(String content) throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(content));
        String line = reader.readLine();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        return lines.toArray(new String[lines.size()]);
    }

    private static String trimLeft(String text) {
        if (text == null || text.isEmpty() || StringUtils.isEmpty((String)text.trim())) {
            return "";
        }
        String textTrimmed = text.trim();
        return text.substring(text.indexOf(textTrimmed));
    }

    private static String trimRight(String text) {
        if (text == null || text.isEmpty() || StringUtils.isEmpty((String)text.trim())) {
            return "";
        }
        String textTrimmed = text.trim();
        return text.substring(0, text.indexOf(textTrimmed) + textTrimmed.length());
    }

    class JavaEntityTags {
        private final JavaAnnotatedElement entity;
        private final boolean isJavaMethod;
        private List<String> namesTags;
        private Map<String, String> tagParams;
        private Set<String> documentedParams = new HashSet<String>();
        private String tagReturn;
        private Map<String, String> tagThrows;
        private List<String> unknownsTags;

        JavaEntityTags(JavaAnnotatedElement entity, boolean isJavaMethod) {
            this.entity = entity;
            this.isJavaMethod = isJavaMethod;
            this.namesTags = new LinkedList<String>();
            this.tagParams = new LinkedHashMap<String, String>();
            this.tagThrows = new LinkedHashMap<String, String>();
            this.unknownsTags = new LinkedList<String>();
        }

        public List<String> getNamesTags() {
            return this.namesTags;
        }

        public String getJavadocReturnTag() {
            return this.tagReturn;
        }

        public void setJavadocReturnTag(String s) {
            this.tagReturn = s;
        }

        public List<String> getUnknownTags() {
            return this.unknownsTags;
        }

        public void putJavadocParamTag(String paramName, String paramValue, String originalJavadocTag) {
            this.documentedParams.add(paramName);
            this.tagParams.put(paramValue, originalJavadocTag);
        }

        public String getJavadocParamTag(String paramValue) {
            String originalJavadocTag = this.tagParams.get(paramValue);
            if (originalJavadocTag == null && AbstractFixJavadocMojo.this.getLog().isWarnEnabled()) {
                AbstractFixJavadocMojo.this.getLog().warn((CharSequence)this.getMessage(paramValue, "javaEntityTags.tagParams"));
            }
            return originalJavadocTag;
        }

        public boolean hasJavadocParamTag(String paramName) {
            return this.documentedParams.contains(paramName);
        }

        public void putJavadocThrowsTag(String paramName, String originalJavadocTag) {
            this.tagThrows.put(paramName, originalJavadocTag);
        }

        public String getJavadocThrowsTag(String paramName) {
            return this.getJavadocThrowsTag(paramName, false);
        }

        public String getJavadocThrowsTag(String paramName, boolean nullable) {
            String originalJavadocTag = this.tagThrows.get(paramName);
            if (!nullable && originalJavadocTag == null && AbstractFixJavadocMojo.this.getLog().isWarnEnabled()) {
                AbstractFixJavadocMojo.this.getLog().warn((CharSequence)this.getMessage(paramName, "javaEntityTags.tagThrows"));
            }
            return originalJavadocTag;
        }

        private String getMessage(String paramName, String mapName) {
            StringBuilder msg = new StringBuilder();
            msg.append("No param '").append(paramName).append("' key found in ").append(mapName).append(" for the entity: ");
            if (this.isJavaMethod) {
                JavaMethod javaMethod = (JavaMethod)this.entity;
                msg.append(AbstractFixJavadocMojo.getJavaMethodAsString((JavaExecutable)javaMethod));
            } else {
                JavaClass javaClass = (JavaClass)this.entity;
                msg.append(javaClass.getFullyQualifiedName());
            }
            return msg.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("namesTags=").append(this.namesTags).append("\n");
            sb.append("tagParams=").append(this.tagParams).append("\n");
            sb.append("tagReturn=").append(this.tagReturn).append("\n");
            sb.append("tagThrows=").append(this.tagThrows).append("\n");
            sb.append("unknownsTags=").append(this.unknownsTags).append("\n");
            return sb.toString();
        }
    }
}

