/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;

public class CoreAdminRequest
extends SolrRequest {
    protected String core = null;
    protected String other = null;
    protected boolean isIndexInfoNeeded = true;
    protected CoreAdminParams.CoreAdminAction action = null;

    public CoreAdminRequest() {
        super(SolrRequest.METHOD.GET, "/admin/cores");
    }

    public CoreAdminRequest(String path) {
        super(SolrRequest.METHOD.GET, path);
    }

    public final void setCoreName(String coreName) {
        this.core = coreName;
    }

    public final void setOtherCoreName(String otherCoreName) {
        this.other = otherCoreName;
    }

    public final void setIndexInfoNeeded(boolean isIndexInfoNeeded) {
        this.isIndexInfoNeeded = isIndexInfoNeeded;
    }

    public void setAction(CoreAdminParams.CoreAdminAction action) {
        this.action = action;
    }

    @Override
    public SolrParams getParams() {
        if (this.action == null) {
            throw new RuntimeException("no action specified!");
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", this.action.toString());
        params.set("core", this.core);
        params.set("indexInfo", this.isIndexInfoNeeded ? "true" : "false");
        if (this.other != null) {
            params.set("other", this.other);
        }
        return params;
    }

    @Override
    public Collection<ContentStream> getContentStreams() throws IOException {
        return null;
    }

    @Override
    public CoreAdminResponse process(SolrServer server) throws SolrServerException, IOException {
        long startTime = System.currentTimeMillis();
        CoreAdminResponse res = new CoreAdminResponse();
        res.setResponse(server.request(this));
        res.setElapsedTime(System.currentTimeMillis() - startTime);
        return res;
    }

    public static CoreAdminResponse reloadCore(String name, SolrServer server) throws SolrServerException, IOException {
        CoreAdminRequest req = new CoreAdminRequest();
        req.setCoreName(name);
        req.setAction(CoreAdminParams.CoreAdminAction.RELOAD);
        return req.process(server);
    }

    public static CoreAdminResponse unloadCore(String name, SolrServer server) throws SolrServerException, IOException {
        return CoreAdminRequest.unloadCore(name, false, server);
    }

    public static CoreAdminResponse unloadCore(String name, boolean deleteIndex, SolrServer server) throws SolrServerException, IOException {
        Unload req = new Unload(deleteIndex);
        req.setCoreName(name);
        return req.process(server);
    }

    public static CoreAdminResponse renameCore(String coreName, String newName, SolrServer server) throws SolrServerException, IOException {
        CoreAdminRequest req = new CoreAdminRequest();
        req.setCoreName(coreName);
        req.setOtherCoreName(newName);
        req.setAction(CoreAdminParams.CoreAdminAction.RENAME);
        return req.process(server);
    }

    public static CoreAdminResponse getStatus(String name, SolrServer server) throws SolrServerException, IOException {
        CoreAdminRequest req = new CoreAdminRequest();
        req.setCoreName(name);
        req.setAction(CoreAdminParams.CoreAdminAction.STATUS);
        return req.process(server);
    }

    public static CoreAdminResponse createCore(String name, String instanceDir, SolrServer server) throws SolrServerException, IOException {
        return CoreAdminRequest.createCore(name, instanceDir, server, null, null);
    }

    public static CoreAdminResponse createCore(String name, String instanceDir, SolrServer server, String configFile, String schemaFile) throws SolrServerException, IOException {
        return CoreAdminRequest.createCore(name, instanceDir, server, configFile, schemaFile, null, null);
    }

    public static CoreAdminResponse createCore(String name, String instanceDir, SolrServer server, String configFile, String schemaFile, String dataDir, String tlogDir) throws SolrServerException, IOException {
        Create req = new Create();
        req.setCoreName(name);
        req.setInstanceDir(instanceDir);
        if (dataDir != null) {
            req.setDataDir(dataDir);
        }
        if (tlogDir != null) {
            req.setUlogDir(tlogDir);
        }
        if (configFile != null) {
            req.setConfigName(configFile);
        }
        if (schemaFile != null) {
            req.setSchemaName(schemaFile);
        }
        return req.process(server);
    }

    @Deprecated
    public static CoreAdminResponse persist(String fileName, SolrServer server) throws SolrServerException, IOException {
        Persist req = new Persist();
        req.setFileName(fileName);
        return req.process(server);
    }

    public static CoreAdminResponse mergeIndexes(String name, String[] indexDirs, String[] srcCores, SolrServer server) throws SolrServerException, IOException {
        MergeIndexes req = new MergeIndexes();
        req.setCoreName(name);
        req.setIndexDirs(Arrays.asList(indexDirs));
        req.setSrcCores(Arrays.asList(srcCores));
        return req.process(server);
    }

    public static class Unload
    extends CoreAdminRequest {
        protected boolean deleteIndex;
        private boolean deleteDataDir;

        public Unload(boolean deleteIndex) {
            this.action = CoreAdminParams.CoreAdminAction.UNLOAD;
            this.deleteIndex = deleteIndex;
        }

        public boolean isDeleteIndex() {
            return this.deleteIndex;
        }

        public void setDeleteIndex(boolean deleteIndex) {
            this.deleteIndex = deleteIndex;
        }

        public void setDeleteDataDir(boolean deleteDataDir) {
            this.deleteDataDir = deleteDataDir;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("deleteIndex", this.deleteIndex);
            params.set("deleteDataDir", this.deleteDataDir);
            return params;
        }
    }

    public static class MergeIndexes
    extends CoreAdminRequest {
        protected List<String> indexDirs;
        protected List<String> srcCores;

        public MergeIndexes() {
            this.action = CoreAdminParams.CoreAdminAction.MERGEINDEXES;
        }

        public void setIndexDirs(List<String> indexDirs) {
            this.indexDirs = indexDirs;
        }

        public List<String> getIndexDirs() {
            return this.indexDirs;
        }

        public List<String> getSrcCores() {
            return this.srcCores;
        }

        public void setSrcCores(List<String> srcCores) {
            this.srcCores = srcCores;
        }

        @Override
        public SolrParams getParams() {
            if (this.action == null) {
                throw new RuntimeException("no action specified!");
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", this.action.toString());
            params.set("core", this.core);
            if (this.indexDirs != null) {
                for (String indexDir : this.indexDirs) {
                    params.add("indexDir", indexDir);
                }
            }
            if (this.srcCores != null) {
                for (String srcCore : this.srcCores) {
                    params.add("srcCore", srcCore);
                }
            }
            return params;
        }
    }

    public static class Persist
    extends CoreAdminRequest {
        protected String fileName = null;

        public Persist() {
            this.action = CoreAdminParams.CoreAdminAction.PERSIST;
        }

        public void setFileName(String name) {
            this.fileName = name;
        }

        public String getFileName() {
            return this.fileName;
        }

        @Override
        public SolrParams getParams() {
            if (this.action == null) {
                throw new RuntimeException("no action specified!");
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", this.action.toString());
            if (this.fileName != null) {
                params.set("file", this.fileName);
            }
            return params;
        }
    }

    public static class RequestSyncShard
    extends CoreAdminRequest {
        private String shard;
        private String collection;

        public RequestSyncShard() {
            this.action = CoreAdminParams.CoreAdminAction.REQUESTSYNCSHARD;
        }

        @Override
        public SolrParams getParams() {
            if (this.action == null) {
                throw new RuntimeException("no action specified!");
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", this.action.toString());
            params.set("shard", this.shard);
            params.set("collection", this.collection);
            params.set("core", this.core);
            return params;
        }

        public String getShard() {
            return this.shard;
        }

        public void setShard(String shard) {
            this.shard = shard;
        }

        public String getCollection() {
            return this.collection;
        }

        public void setCollection(String collection) {
            this.collection = collection;
        }
    }

    public static class RequestRecovery
    extends CoreAdminRequest {
        public RequestRecovery() {
            this.action = CoreAdminParams.CoreAdminAction.REQUESTRECOVERY;
        }

        @Override
        public SolrParams getParams() {
            if (this.action == null) {
                throw new RuntimeException("no action specified!");
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", this.action.toString());
            params.set("core", this.core);
            return params;
        }
    }

    public static class WaitForState
    extends CoreAdminRequest {
        protected String nodeName;
        protected String coreNodeName;
        protected String state;
        protected Boolean checkLive;
        protected Boolean onlyIfLeader;

        public WaitForState() {
            this.action = CoreAdminParams.CoreAdminAction.PREPRECOVERY;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getCoreNodeName() {
            return this.coreNodeName;
        }

        public void setCoreNodeName(String coreNodeName) {
            this.coreNodeName = coreNodeName;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public Boolean getCheckLive() {
            return this.checkLive;
        }

        public void setCheckLive(Boolean checkLive) {
            this.checkLive = checkLive;
        }

        public boolean isOnlyIfLeader() {
            return this.onlyIfLeader;
        }

        public void setOnlyIfLeader(boolean onlyIfLeader) {
            this.onlyIfLeader = onlyIfLeader;
        }

        @Override
        public SolrParams getParams() {
            if (this.action == null) {
                throw new RuntimeException("no action specified!");
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", this.action.toString());
            params.set("core", this.core);
            if (this.nodeName != null) {
                params.set("nodeName", this.nodeName);
            }
            if (this.coreNodeName != null) {
                params.set("coreNodeName", this.coreNodeName);
            }
            if (this.state != null) {
                params.set("state", this.state);
            }
            if (this.checkLive != null) {
                params.set("checkLive", this.checkLive);
            }
            if (this.onlyIfLeader != null) {
                params.set("onlyIfLeader", this.onlyIfLeader);
            }
            return params;
        }
    }

    public static class Create
    extends CoreAdminRequest {
        protected String instanceDir;
        protected String configName = null;
        protected String schemaName = null;
        protected String dataDir = null;
        protected String ulogDir = null;
        protected String collection;
        private Integer numShards;
        private String shardId;
        private String roles;
        private String coreNodeName;
        private Boolean loadOnStartup;
        private Boolean isTransient;

        public Create() {
            this.action = CoreAdminParams.CoreAdminAction.CREATE;
        }

        public void setInstanceDir(String instanceDir) {
            this.instanceDir = instanceDir;
        }

        public void setSchemaName(String schema) {
            this.schemaName = schema;
        }

        public void setConfigName(String config) {
            this.configName = config;
        }

        public void setDataDir(String dataDir) {
            this.dataDir = dataDir;
        }

        public void setUlogDir(String ulogDir) {
            this.ulogDir = ulogDir;
        }

        public void setCollection(String collection) {
            this.collection = collection;
        }

        public void setNumShards(int numShards) {
            this.numShards = numShards;
        }

        public void setShardId(String shardId) {
            this.shardId = shardId;
        }

        public void setRoles(String roles) {
            this.roles = roles;
        }

        public void setCoreNodeName(String coreNodeName) {
            this.coreNodeName = coreNodeName;
        }

        public void setIsTransient(Boolean isTransient) {
            this.isTransient = isTransient;
        }

        public void setIsLoadOnStartup(Boolean loadOnStartup) {
            this.loadOnStartup = loadOnStartup;
        }

        public String getInstanceDir() {
            return this.instanceDir;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getConfigName() {
            return this.configName;
        }

        public String getDataDir() {
            return this.dataDir;
        }

        public String getUlogDir() {
            return this.ulogDir;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getShardId() {
            return this.shardId;
        }

        public String getRoles() {
            return this.roles;
        }

        public String getCoreNodeName() {
            return this.coreNodeName;
        }

        public Boolean getIsLoadOnStartup() {
            return this.loadOnStartup;
        }

        public Boolean getIsTransient() {
            return this.isTransient;
        }

        @Override
        public SolrParams getParams() {
            if (this.action == null) {
                throw new RuntimeException("no action specified!");
            }
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", this.action.toString());
            if (this.action.equals((Object)CoreAdminParams.CoreAdminAction.CREATE)) {
                params.set("name", this.core);
            } else {
                params.set("core", this.core);
            }
            params.set("instanceDir", this.instanceDir);
            if (this.configName != null) {
                params.set("config", this.configName);
            }
            if (this.schemaName != null) {
                params.set("schema", this.schemaName);
            }
            if (this.dataDir != null) {
                params.set("dataDir", this.dataDir);
            }
            if (this.ulogDir != null) {
                params.set("ulogDir", this.ulogDir);
            }
            if (this.collection != null) {
                params.set("collection", this.collection);
            }
            if (this.numShards != null) {
                params.set("numShards", this.numShards);
            }
            if (this.shardId != null) {
                params.set("shard", this.shardId);
            }
            if (this.roles != null) {
                params.set("roles", this.roles);
            }
            if (this.coreNodeName != null) {
                params.set("coreNodeName", this.coreNodeName);
            }
            if (this.isTransient != null) {
                params.set("transient", this.isTransient);
            }
            if (this.loadOnStartup != null) {
                params.set("loadOnStartup", this.loadOnStartup);
            }
            return params;
        }
    }
}

